/*
 * IntervalType.java
 *
 * Created on 22. August 2007, 14:32
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package net.sourceforge.ganttproject.calendar;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;

/**
 * An IntervalType  is assigned to one or more Intervals.
 * It holds the properties color, description and locked
 * valid for all assigned Intervals.
 * @author shofmann
 */
public class IntervalType implements Comparable{
    
    /** Creates a new instance of IntervalType */
    public IntervalType() {
        this.intervals = new HashSet<Interval>();
    }
    
    /**
     * Holds value of property description.
     */
    private String description;
    
    /**
     * Getter for property description.
     * @return Value of property description.
     */
    public String getDescription() {
        return this.description;
    }
    
    /**
     * Setter for property description.
     * @param description New value of property description.
     */
    public void setDescription(String description) {
        this.description = description;
    }
    
    /**
     * Holds value of property locked.
     */
    private boolean locked;
    
    /**
     * Getter for property locked.
     * @return Value of property locked.
     */
    public boolean isLocked() {
        return this.locked;
    }
    
    /**
     * Setter for property locked.
     * @param locked New value of property locked.
     */
    public void setLocked(boolean locked) {
        this.locked = locked;
    }
    
    /**
     * Holds value of property color.
     */
    private Color color;
    
    /**
     * Getter for property color.
     * @return Value of property color.
     */
    public Color getColor() {
        return this.color;
    }
    
    /**
     * Setter for property color.
     * @param color New value of property color.
     */
    public void setColor(Color color) {
        this.color = color;
    }
    
    /**
     * Returns the string representation of this object
     * @return string representation of this object
     */
    @Override
    public String toString() {
        return "IntervalType [description: "+this.description+", color: "+this.color+", locked: "+this.locked+"]";
    }
    
    /**
     * Compares this object with the specified object for order.
     * @param o the Object to be compared.
     * @return Returns a negative integer, zero, or a positive integer as this object is less than, equal to, or greater than the specified object
     */
    public int compareTo(Object o) {
        return this.description.compareToIgnoreCase(((IntervalType)o).getDescription());
    }
    
    /**
     * the Object to be compared.
     * @param obj the reference object with which to compare.
     * @return true if this object is the same as the obj argument; false otherwise.
     */
    @Override
    public boolean equals(Object obj) {
        IntervalType that;
        try{
            that = (IntervalType)obj;
        }catch(Exception e){
            return false;
        }
        return this.color.equals(that.getColor()) 
            && this.description.equals(that.getDescription()) 
            && this.locked == that.isLocked();
    }

    /**
     * Holds value of property intervals.
     */
    private Set<Interval> intervals;

    /**
     * Getter for property intervals.
     * @return Value of property intervals.
     */
    public Set<Interval> getIntervals() {
        return this.intervals;
    }

    /**
     * Setter for property intervals.
     * @param intervals New value of property intervals.
     */
    public void setIntervals(Set<Interval> intervals) {
        this.intervals = intervals;
    }
}
