/*
 * Interval.java
 *
 * Created on 26. Februar 2007, 11:59
 *
 */

package net.sourceforge.ganttproject.calendar;

import java.awt.Color;
import java.util.Date;

/**
 * This class holds the values of an interval defined in projects xml file.
 * An interval consists of a start and an end date an a color to be displayed
 * in the gantt chart. It may have an additional description which is not uesd
 * yet. An interval may be locked so that the days it covers are treated as a
 * non working day.
 *
 * @author shofmann <sebastian.hofmann@sourcepark.de>
 */
public class Interval {
    
    /** Creates a new instance of Interval */
    public Interval() {
    }
    
    /**
     * Holds value of property startDate.
     */
    private Date startDate;
    
    /**
     * Getter for property startDate.
     * @return Value of property startDate.
     */
    public Date getStartDate() {
        return this.startDate;
    }
    
    /**
     * Setter for property startDate.
     * @param startDate New value of property startDate.
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    
    /**
     * Holds value of property endDate.
     */
    private Date endDate;
    
    /**
     * Getter for property endDate.
     * @return Value of property endDate.
     */
    public Date getEndDate() {
        return this.endDate;
    }
    
    /**
     * Setter for property endDate.
     * @param endDate New value of property endDate.
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    
    /**
     * Returns the string representation of this object
     * @return string representation of this object
     */
    @Override
    public String toString() {
        return "Interval [startdate: "+this.startDate+", enddate: "+this.endDate+", type: "+this.type.toString()+"]";
    }
    
    /**
     * Holds value of property type.
     */
    private IntervalType type;
    
    /**
     * Getter for property type.
     * @return Value of property type.
     */
    public IntervalType getType() {
        return this.type;
    }
    
    /**
     * Setter for property type.
     * @param type New value of property type.
     */
    public void setType(IntervalType type) {
        if(type != null){
            this.type = type;
            this.type.getIntervals().add(this);
        }else{
            this.type = null;
        }
    }
    
}
