/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.util.ArrayList;
import java.util.Arrays;
import org.bardsoftware.impl.eclipsito.ExtensionsProcessor;
import org.bardsoftware.impl.eclipsito.PluginDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

public class ExtensionRegistryImpl
implements IExtensionRegistry {
    private final IExtensionPoint[] myExtensionPoints;

    public ExtensionRegistryImpl(IExtensionPoint[] points) {
        this.myExtensionPoints = points;
    }

    public ExtensionRegistryImpl(PluginDescriptor[] descriptors) {
        this.myExtensionPoints = ExtensionsProcessor.resolveExtensionPoints(descriptors);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String extensionPointId) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtensionPoint point = this.getExtensionPoint(extensionPointId);
        if (point != null) {
            IExtension[] extensions = this.getExtensionPoint(extensionPointId).getExtensions();
            int i = 0;
            while (extensions != null && i < extensions.length) {
                result.addAll(Arrays.asList(extensions[i].getConfigurationElements()));
                ++i;
            }
        }
        return result.toArray(new IConfigurationElement[result.size()]);
    }

    public IExtension getExtension(String extensionId) {
        IExtension result = null;
        int i = 0;
        while (this.myExtensionPoints != null && i < this.myExtensionPoints.length) {
            IExtension extension = this.myExtensionPoints[i].getExtension(extensionId);
            if (extension != null) {
                result = extension;
                break;
            }
            ++i;
        }
        return result;
    }

    public IExtension getExtension(String extensionPointId, String extensionId) {
        IExtension result = null;
        int i = 0;
        while (this.myExtensionPoints != null && i < this.myExtensionPoints.length) {
            IExtension extension = this.myExtensionPoints[i].getExtension(extensionId);
            if (this.myExtensionPoints[i].getUniqueIdentifier().equals(extensionPointId) && extension != null) {
                result = extension;
                break;
            }
            ++i;
        }
        return result;
    }

    public IExtensionPoint[] getExtensionPoints() {
        return this.myExtensionPoints;
    }

    public IExtensionPoint getExtensionPoint(String extensionPointId) {
        IExtensionPoint result = null;
        int i = 0;
        while (this.myExtensionPoints != null && i < this.myExtensionPoints.length) {
            if (this.myExtensionPoints[i].getUniqueIdentifier().equals(extensionPointId)) {
                result = this.myExtensionPoints[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public IConfigurationElement[] getConfigurationElementsFor(String namespace, String extensionPointName) {
        throw new UnsupportedOperationException();
    }

    public IConfigurationElement[] getConfigurationElementsFor(String namespace, String extensionPointName, String extensionId) {
        throw new UnsupportedOperationException();
    }

    public IExtension getExtension(String namespace, String extensionPointName, String extensionId) {
        throw new UnsupportedOperationException();
    }

    public IExtension[] getExtensions(String namespace) {
        throw new UnsupportedOperationException();
    }

    public IExtensionPoint getExtensionPoint(String namespace, String extensionPointName) {
        throw new UnsupportedOperationException();
    }

    public IExtensionPoint[] getExtensionPoints(String namespace) {
        throw new UnsupportedOperationException();
    }

    public String[] getNamespaces() {
        throw new UnsupportedOperationException();
    }
}

