/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXNumberFormat;
import com.tapsterrock.mpx.ToStringRequiresFile;

final class MPXUnits
extends Number
implements ToStringRequiresFile {
    private double m_value;
    static final String DECIMAL_FORMAT_STRING = "#.##";
    private static final MPXNumberFormat DEFAULT_DECIMAL_FORMAT = new MPXNumberFormat("#.##", '.', ',');

    MPXUnits(String value, MPXNumberFormat format) throws MPXException {
        this.m_value = format.parse(value).doubleValue() * 100.0;
    }

    MPXUnits(Number value) {
        this.m_value = value.doubleValue();
    }

    MPXUnits(double value) {
        this.m_value = value;
    }

    public String toString() {
        return this.toString(DEFAULT_DECIMAL_FORMAT);
    }

    public String toString(MPXFile mpx) {
        return this.toString(mpx.getUnitsDecimalFormat());
    }

    String toString(MPXNumberFormat format) {
        return format.format(this.m_value / 100.0);
    }

    public int intValue() {
        return (int)this.m_value;
    }

    public long longValue() {
        return (long)this.m_value;
    }

    public float floatValue() {
        return (float)this.m_value;
    }

    public double doubleValue() {
        return this.m_value;
    }
}

