/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpp;

import com.tapsterrock.mpp.MPPFile;
import com.tapsterrock.mpx.CurrencySymbolPosition;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.TimeUnit;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

final class MPPUtility {
    private static final long EPOCH = 441676800000L;
    private static final long MS_PER_DAY = 86400000L;
    private static final long MS_PER_MINUTE = 60000L;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int DURATION_UNITS_MASK = 31;
    private static final int DEFAULT_DST_SAVINGS = 3600000;
    private static boolean HAS_DST_SAVINGS;
    static /* synthetic */ Class class$java$util$TimeZone;

    private MPPUtility() {
    }

    public static final void getByteArray(byte[] data, int offset, int size, byte[] buffer, int bufferOffset) {
        for (int loop = 0; loop < size; ++loop) {
            buffer[bufferOffset + loop] = data[offset + loop];
        }
    }

    public static final int getByte(byte[] data, int offset) {
        int result = data[offset] & 0xF;
        return result += (data[offset] >> 4 & 0xF) * 16;
    }

    public static final int getByte(byte[] data) {
        return MPPUtility.getByte(data, 0);
    }

    public static final int getShort(byte[] data, int offset) {
        int result = data[offset] & 0xF;
        result += (data[offset] >> 4 & 0xF) * 16;
        result += (data[offset + 1] & 0xF) * 256;
        return result += (data[offset + 1] >> 4 & 0xF) * 4096;
    }

    public static final int getShort(byte[] data) {
        return MPPUtility.getShort(data, 0);
    }

    public static final int getInt(byte[] data, int offset) {
        int result = data[offset] & 0xF;
        result += (data[offset] >> 4 & 0xF) * 16;
        result += (data[offset + 1] & 0xF) * 256;
        result += (data[offset + 1] >> 4 & 0xF) * 4096;
        result += (data[offset + 2] & 0xF) * 65536;
        result += (data[offset + 2] >> 4 & 0xF) * 0x100000;
        result += (data[offset + 3] & 0xF) * 0x1000000;
        return result += (data[offset + 3] >> 4 & 0xF) * 0x10000000;
    }

    public static final int getInt(byte[] data) {
        return MPPUtility.getInt(data, 0);
    }

    public static final long getLong(byte[] data, int offset) {
        long result = data[offset] & 0xF;
        result += (long)((data[offset] >> 4 & 0xF) * 16);
        result += (long)((data[offset + 1] & 0xF) * 256);
        result += (long)((data[offset + 1] >> 4 & 0xF) * 4096);
        result += (long)((data[offset + 2] & 0xF) * 65536);
        result += (long)((data[offset + 2] >> 4 & 0xF) * 0x100000);
        result += (long)((data[offset + 3] & 0xF) * 0x1000000);
        result += (long)((data[offset + 3] >> 4 & 0xF) * 0x10000000);
        result += (long)(data[offset + 4] & 0xF) * 0x100000000L;
        result += (long)(data[offset + 4] >> 4 & 0xF) * 0x1000000000L;
        result += (long)(data[offset + 5] & 0xF) * 0x10000000000L;
        result += (long)(data[offset + 5] >> 4 & 0xF) * 0x100000000000L;
        result += (long)(data[offset + 6] & 0xF) * 0x1000000000000L;
        result += (long)(data[offset + 6] >> 4 & 0xF) * 0x10000000000000L;
        result += (long)(data[offset + 7] & 0xF) * 0x100000000000000L;
        return result += (long)(data[offset + 7] >> 4 & 0xF) * 0x1000000000000000L;
    }

    public static final long getLong6(byte[] data, int offset) {
        long result = data[offset] & 0xF;
        result += (long)((data[offset] >> 4 & 0xF) * 16);
        result += (long)((data[offset + 1] & 0xF) * 256);
        result += (long)((data[offset + 1] >> 4 & 0xF) * 4096);
        result += (long)((data[offset + 2] & 0xF) * 65536);
        result += (long)((data[offset + 2] >> 4 & 0xF) * 0x100000);
        result += (long)((data[offset + 3] & 0xF) * 0x1000000);
        result += (long)((data[offset + 3] >> 4 & 0xF) * 0x10000000);
        result += (long)(data[offset + 4] & 0xF) * 0x100000000L;
        result += (long)(data[offset + 4] >> 4 & 0xF) * 0x1000000000L;
        result += (long)(data[offset + 5] & 0xF) * 0x10000000000L;
        return result += (long)(data[offset + 5] >> 4 & 0xF) * 0x100000000000L;
    }

    public static final long getLong6(byte[] data) {
        return MPPUtility.getLong6(data, 0);
    }

    public static final long getLong(byte[] data) {
        return MPPUtility.getLong(data, 0);
    }

    public static final double getDouble(byte[] data, int offset) {
        return Double.longBitsToDouble(MPPUtility.getLong(data, offset));
    }

    public static final double getDouble(byte[] data) {
        return Double.longBitsToDouble(MPPUtility.getLong(data, 0));
    }

    public static final Date getDate(byte[] data, int offset) {
        long days = MPPUtility.getShort(data, offset);
        Date result = days == 65535L ? null : new Date(441676800000L + days * 86400000L);
        return result;
    }

    public static final Date getTime(byte[] data, int offset) {
        int time = MPPUtility.getShort(data, offset) / 10;
        Calendar cal = Calendar.getInstance();
        cal.set(11, time / 60);
        cal.set(12, time % 60);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static final Date getTime(byte[] data) {
        return MPPUtility.getTime(data, 0);
    }

    public static final long getDuration(byte[] data, int offset) {
        return (long)MPPUtility.getShort(data, offset) * 60000L / 10L;
    }

    public static final Date getTimestamp(byte[] data, int offset) {
        Date result;
        long days = MPPUtility.getShort(data, offset + 2);
        if (days == 65535L) {
            result = null;
        } else {
            long time;
            TimeZone tz = TimeZone.getDefault();
            if (tz.inDaylightTime(result = new Date(441676800000L + days * 86400000L + (time = (long)MPPUtility.getShort(data, offset)) * 60000L / 10L - (long)tz.getRawOffset()))) {
                int savings = HAS_DST_SAVINGS ? tz.getDSTSavings() : 3600000;
                result = new Date(result.getTime() - (long)savings);
            }
        }
        return result;
    }

    public static final Date getTimestamp(byte[] data) {
        return MPPUtility.getTimestamp(data, 0);
    }

    public static final String getUnicodeString(byte[] data) {
        return MPPUtility.getUnicodeString(data, 0);
    }

    public static final String getUnicodeString(byte[] data, int offset) {
        char c;
        StringBuffer buffer = new StringBuffer();
        for (int loop = offset; loop < data.length - 1 && (c = (char)MPPUtility.getShort(data, loop)) != '\u0000'; loop += 2) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static final String getUnicodeString(byte[] data, int offset, int length) {
        char c;
        StringBuffer buffer = new StringBuffer();
        int loop = offset;
        for (int byteLength = 0; loop < data.length - 1 && byteLength < length && (c = (char)MPPUtility.getShort(data, loop)) != '\u0000'; loop += 2, byteLength += 2) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static final String getString(byte[] data) {
        return MPPUtility.getString(data, 0);
    }

    public static final String getString(byte[] data, int offset) {
        char c;
        StringBuffer buffer = new StringBuffer();
        int loop = 0;
        while (offset + loop < data.length && (c = (char)data[offset + loop]) != '\u0000') {
            buffer.append(c);
            ++loop;
        }
        return buffer.toString();
    }

    public static final MPXDuration getDuration(int value, TimeUnit type) {
        return MPPUtility.getDuration((double)value, type);
    }

    public static final MPXDuration getDuration(double value, TimeUnit type) {
        double duration;
        switch (type.getValue()) {
            case 0: 
            case 7: {
                duration = value / 10.0;
                break;
            }
            case 1: 
            case 8: {
                duration = value / 600.0;
                break;
            }
            case 2: 
            case 9: {
                duration = value / 4800.0;
                break;
            }
            case 3: 
            case 10: {
                duration = value / 24000.0;
                break;
            }
            case 4: 
            case 11: {
                duration = value / 96000.0;
                break;
            }
            default: {
                duration = value;
            }
        }
        return MPXDuration.getInstance(duration, type);
    }

    public static final TimeUnit getDurationTimeUnits(int type) {
        TimeUnit units;
        switch (type & 0x1F) {
            case 3: {
                units = TimeUnit.MINUTES;
                break;
            }
            case 4: {
                units = TimeUnit.ELAPSED_MINUTES;
                break;
            }
            case 5: {
                units = TimeUnit.HOURS;
                break;
            }
            case 6: {
                units = TimeUnit.ELAPSED_HOURS;
                break;
            }
            case 8: {
                units = TimeUnit.ELAPSED_DAYS;
                break;
            }
            case 9: {
                units = TimeUnit.WEEKS;
                break;
            }
            case 10: {
                units = TimeUnit.ELAPSED_WEEKS;
                break;
            }
            case 11: {
                units = TimeUnit.MONTHS;
                break;
            }
            case 12: {
                units = TimeUnit.ELAPSED_MONTHS;
                break;
            }
            default: {
                units = TimeUnit.DAYS;
            }
        }
        return units;
    }

    public static MPXDuration getAdjustedDuration(MPPFile file, int duration, TimeUnit timeUnit) {
        MPXDuration result;
        switch (timeUnit.getValue()) {
            case 2: {
                double unitsPerDay = file.getProjectHeader().getDefaultHoursInDay().doubleValue() * 600.0;
                double totalDays = (double)duration / unitsPerDay;
                result = MPXDuration.getInstance(totalDays, timeUnit);
                break;
            }
            case 9: {
                double unitsPerDay = 14400.0;
                double totalDays = (double)duration / unitsPerDay;
                result = MPXDuration.getInstance(totalDays, timeUnit);
                break;
            }
            default: {
                result = MPPUtility.getDuration(duration, timeUnit);
            }
        }
        return result;
    }

    public static TimeUnit getWorkTimeUnits(int value) {
        TimeUnit result;
        switch (value) {
            case 1: {
                result = TimeUnit.MINUTES;
                break;
            }
            case 3: {
                result = TimeUnit.DAYS;
                break;
            }
            case 4: {
                result = TimeUnit.WEEKS;
                break;
            }
            default: {
                result = TimeUnit.HOURS;
            }
        }
        return result;
    }

    public static CurrencySymbolPosition getSymbolPosition(int value) {
        CurrencySymbolPosition result;
        switch (value) {
            case 1: {
                result = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                result = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                result = CurrencySymbolPosition.AFTER_WITH_SPACE;
                break;
            }
            default: {
                result = CurrencySymbolPosition.BEFORE;
            }
        }
        return result;
    }

    public static final String removeAmpersands(String name) {
        if (name != null && name.indexOf(38) != -1) {
            StringBuffer sb = new StringBuffer();
            for (int index = 0; index < name.length(); ++index) {
                char c = name.charAt(index);
                if (c == '&') continue;
                sb.append(c);
            }
            name = sb.toString();
        }
        return name;
    }

    public static final byte[] cloneSubArray(byte[] data, int offset, int size) {
        byte[] newData = new byte[size];
        System.arraycopy(data, offset, newData, 0, size);
        return newData;
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii) {
        StringBuffer sb = new StringBuffer();
        if (buffer != null) {
            int loop;
            int count = offset + length;
            for (loop = offset; loop < count; ++loop) {
                sb.append(" ");
                sb.append(HEX_DIGITS[(buffer[loop] & 0xF0) >> 4]);
                sb.append(HEX_DIGITS[buffer[loop] & 0xF]);
            }
            if (ascii) {
                sb.append("   ");
                for (loop = offset; loop < count; ++loop) {
                    char c = (char)buffer[loop];
                    if (c > '\u00c8' || c < '\u001b') {
                        c = ' ';
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static final String hexdump(byte[] buffer, boolean ascii) {
        int length = 0;
        if (buffer != null) {
            length = buffer.length;
        }
        return MPPUtility.hexdump(buffer, 0, length, ascii);
    }

    public static final String hexdump(byte[] buffer, boolean ascii, int columns, String prefix) {
        StringBuffer sb = new StringBuffer();
        if (buffer != null) {
            DecimalFormat df = new DecimalFormat("00000");
            for (int index = 0; index < buffer.length; index += columns) {
                if (index + columns > buffer.length) {
                    columns = buffer.length - index;
                }
                sb.append(prefix);
                sb.append(df.format(index));
                sb.append(":");
                sb.append(MPPUtility.hexdump(buffer, index, columns, ascii));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class tz = class$java$util$TimeZone == null ? (class$java$util$TimeZone = MPPUtility.class$("java.util.TimeZone")) : class$java$util$TimeZone;
        try {
            tz.getMethod("getDSTSavings", null);
            HAS_DST_SAVINGS = true;
        }
        catch (NoSuchMethodException ex) {
            HAS_DST_SAVINGS = false;
        }
    }
}

