/*
 * Decompiled with CFR 0.152.
 */
package atest.jmock;

import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.DynamicMockError;

public class CascadedFailuresAcceptanceTest
extends MockObjectTestCase {
    private static final int VALID_ARGUMENT = 2;
    private static final int INVALID_ARGUMENT = 1;
    private Mock mock;
    private ObjectUnderTest objectUnderTest;

    public void setUp() {
        this.mock = this.mock(MockedType.class, "mock");
        this.objectUnderTest = new ObjectUnderTest((MockedType)this.mock.proxy());
        this.mock.stubs().method("f").with(this.eq(2));
    }

    public void testMockReportsFirstFailure() {
        try {
            this.objectUnderTest.methodUnderTest(1);
            CascadedFailuresAcceptanceTest.fail((String)"should have thrown DynamicMockError");
        }
        catch (DynamicMockError err) {
            CascadedFailuresAcceptanceTest.assertEquals((String)"invoked method", (String)"f", (String)err.invocation.invokedMethod.getName());
        }
    }

    public void testResetClearsFirstFailure() {
        try {
            this.objectUnderTest.methodUnderTest(1);
            CascadedFailuresAcceptanceTest.fail((String)"should have thrown DynamicMockError");
        }
        catch (DynamicMockError err) {
            // empty catch block
        }
        this.mock.reset();
        this.mock.stubs().method("f").with(this.eq(2));
        try {
            this.objectUnderTest.methodUnderTest(2);
            CascadedFailuresAcceptanceTest.fail((String)"should have thrown DynamicMockError");
        }
        catch (DynamicMockError err) {
            CascadedFailuresAcceptanceTest.assertEquals((String)"invoked method", (String)"g", (String)err.invocation.invokedMethod.getName());
        }
    }

    public void testSuccessfulVerifyClearsFirstFailure() {
        try {
            this.objectUnderTest.methodUnderTest(1);
            CascadedFailuresAcceptanceTest.fail((String)"should have thrown DynamicMockError");
        }
        catch (DynamicMockError err) {
            // empty catch block
        }
        this.mock.verify();
        try {
            this.objectUnderTest.methodUnderTest(2);
            CascadedFailuresAcceptanceTest.fail((String)"should have thrown DynamicMockError");
        }
        catch (DynamicMockError err) {
            CascadedFailuresAcceptanceTest.assertEquals((String)"invoked method", (String)"g", (String)err.invocation.invokedMethod.getName());
        }
    }

    public static class ObjectUnderTest {
        private MockedType other;

        public ObjectUnderTest(MockedType other) {
            this.other = other;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void methodUnderTest(int i) {
            try {
                this.other.f(i);
            }
            finally {
                this.other.g();
            }
        }
    }

    public static interface MockedType {
        public void f(int var1);

        public void g();
    }
}

