/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.decorator;

import java.awt.Color;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdesktop.swing.decorator.ComponentAdapter;
import org.jdesktop.swing.decorator.ConditionalHighlighter;
import org.jdesktop.swing.decorator.PatternMatcher;

public class PatternHighlighter
extends ConditionalHighlighter
implements PatternMatcher {
    protected Pattern pattern = null;

    public PatternHighlighter() {
        this(null, null, null, 0, 0);
    }

    public PatternHighlighter(Color background, Color foreground, String regExString, int matchFlags, int testColumn) throws PatternSyntaxException {
        this(background, foreground, regExString, matchFlags, testColumn, -1);
    }

    public PatternHighlighter(Color background, Color foreground, String regExString, int matchFlags, int testColumn, int decorateColumn) throws PatternSyntaxException {
        super(background, foreground, testColumn, decorateColumn);
        this.setPattern(regExString, matchFlags);
    }

    protected boolean test(ComponentAdapter adapter) {
        if (this.pattern == null) {
            return false;
        }
        int testColumnV = adapter.modelToView(this.testColumn);
        if (testColumnV < 0) {
            return false;
        }
        Object value = adapter.getFilteredValueAt(adapter.row, testColumnV);
        if (value == null) {
            return false;
        }
        boolean matches = this.pattern.matcher(value.toString()).matches();
        return matches;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(String regularExpr, int matchFlags) {
        if (regularExpr == null || regularExpr.length() == 0) {
            regularExpr = ".*";
        }
        this.setPattern(Pattern.compile(regularExpr, matchFlags));
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }
}

