/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.decorator;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jdesktop.swing.decorator.Filter;
import org.jdesktop.swing.decorator.PatternMatcher;

public class PatternFilter
extends Filter
implements PatternMatcher {
    private ArrayList toPrevious;
    private ArrayList fromPrevious;
    protected Pattern pattern = null;

    public PatternFilter() {
        this(null, 0, 0);
    }

    public PatternFilter(String regularExpr, int matchFlags, int col) {
        super(col);
        this.setPattern(regularExpr, matchFlags);
    }

    protected void init() {
        this.toPrevious = new ArrayList();
        this.fromPrevious = new ArrayList();
    }

    public void setPattern(String regularExpr, int matchFlags) {
        if (regularExpr == null || regularExpr.length() == 0) {
            regularExpr = ".*";
        }
        this.setPattern(Pattern.compile(regularExpr, matchFlags));
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
        this.refresh();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    protected void reset() {
        this.toPrevious.clear();
        Integer none = new Integer(-1);
        int inputSize = this.getInputSize();
        this.fromPrevious = new ArrayList(inputSize);
        int i = 0;
        while (i < inputSize) {
            this.fromPrevious.add(i, none);
            ++i;
        }
    }

    protected void generateMappingFromPrevious() {
        int outputSize = this.toPrevious.size();
        int i = 0;
        while (i < outputSize) {
            Integer index = (Integer)this.toPrevious.get(i);
            this.fromPrevious.set(index, new Integer(i));
            ++i;
        }
    }

    protected void filter() {
        if (this.pattern != null) {
            int inputSize = this.getInputSize();
            int i = 0;
            while (i < inputSize) {
                if (this.test(i)) {
                    this.toPrevious.add(new Integer(i));
                }
                ++i;
            }
        }
    }

    public boolean test(int row) {
        if (this.pattern == null) {
            return false;
        }
        if (this.adapter.modelToView(this.getColumnIndex()) < 0) {
            return false;
        }
        Object value = this.getInputValue(row, this.getColumnIndex());
        if (value == null) {
            return false;
        }
        boolean matches = this.pattern.matcher(value.toString()).matches();
        return matches;
    }

    public int getSize() {
        return this.toPrevious.size();
    }

    protected int translateFromPreviousFilter(int row) {
        return (Integer)this.fromPrevious.get(row);
    }

    protected int translateToPreviousFilter(int row) {
        return (Integer)this.toPrevious.get(row);
    }
}

