/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.decorator;

import java.awt.Color;
import java.awt.Component;
import org.jdesktop.swing.decorator.ComponentAdapter;
import org.jdesktop.swing.decorator.Highlighter;

public class HierarchicalColumnHighlighter
extends Highlighter {
    public HierarchicalColumnHighlighter() {
    }

    public HierarchicalColumnHighlighter(Color background, Color foreground) {
        super(background, foreground);
    }

    protected Color computeBackground(Component component, ComponentAdapter adapter) {
        if (adapter.isHierarchical()) {
            Color background = this.getBackground();
            Color seed = background == null ? component.getBackground() : background;
            seed = this.computeBackgroundSeed(seed);
            return adapter.isSelected() ? this.computeSelectedBackground(seed) : seed;
        }
        return null;
    }

    public Color getForeground(Component component, ComponentAdapter adapter) {
        if (adapter.isHierarchical() && this.getForeground() != null) {
            return super.computeForeground(component, adapter);
        }
        return null;
    }

    protected Color computeBackgroundSeed(Color seed) {
        return new Color(Math.max((int)((double)seed.getRed() * 0.95), 0), Math.max((int)((double)seed.getGreen() * 0.95), 0), Math.max((int)((double)seed.getBlue() * 0.95), 0));
    }
}

