/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.jdesktop.swing.data.DefaultDataModel;
import org.jdesktop.swing.data.MetaData;

public class JavaBeanDataModel
extends DefaultDataModel {
    private BeanInfo info;
    private Class beanClass;
    private Object bean;

    public JavaBeanDataModel(Class beanClass) throws IntrospectionException {
        this(beanClass, null);
    }

    public JavaBeanDataModel(Class beanClass, Object bean) throws IntrospectionException {
        this.beanClass = beanClass;
        this.bean = bean;
        this.info = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] props = this.info.getPropertyDescriptors();
        int i = 0;
        while (i < props.length) {
            this.addField(new MetaData(props[i].getName(), props[i].getPropertyType(), props[i].getDisplayName()));
            ++i;
        }
    }

    public void setJavaBean(Object bean) {
        if (bean != null && bean.getClass() != this.beanClass) {
            throw new RuntimeException("ERROR: argument is not a " + this.beanClass.toString());
        }
        Object oldBean = this.bean;
        this.bean = bean;
        if (bean != oldBean) {
            String[] fieldNames = this.getFieldNames();
            int i = 0;
            while (i < fieldNames.length) {
                this.fireValueChanged(fieldNames[i]);
                ++i;
            }
        }
    }

    public Object getJavaBean() {
        return this.bean;
    }

    public Object getValue(String fieldName) {
        if (this.getJavaBean() == null) {
            return null;
        }
        PropertyDescriptor prop = this.getPropertyDescriptor(fieldName);
        Method readMethod = prop.getReadMethod();
        if (readMethod != null) {
            try {
                return readMethod.invoke(this.getJavaBean(), new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected void setValueImpl(String fieldName, Object value) {
        if (this.getJavaBean() == null) {
            return;
        }
        PropertyDescriptor prop = this.getPropertyDescriptor(fieldName);
        Method writeMethod = prop.getWriteMethod();
        if (writeMethod != null) {
            try {
                writeMethod.invoke(this.getJavaBean(), value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor pd = null;
        PropertyDescriptor[] desc = this.info.getPropertyDescriptors();
        int i = 0;
        while (i < desc.length) {
            if (name.equals(desc[i].getName())) {
                pd = desc[i];
                break;
            }
            ++i;
        }
        return pd;
    }
}

