/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import org.jdesktop.swing.data.Converter;
import org.jdesktop.swing.data.HierarchicalDataMetaData;
import org.jdesktop.swing.treetable.DefaultTreeTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMAdapter
extends DefaultTreeTableModel {
    protected Document dom = null;
    private HierarchicalDataMetaData metaData;

    public DOMAdapter() {
    }

    public DOMAdapter(Document dom) {
        this.bind(dom);
    }

    public final void bind(Document dom) {
        if (dom == null) {
            throw new IllegalArgumentException("null document object model");
        }
        if (this.dom != null) {
            throw new IllegalArgumentException("dom already bound");
        }
        this.dom = dom;
        Element metaDataElem = (Element)dom.getDocumentElement().getElementsByTagNameNS("http://www.jdesktop.org/2004/05/jdnc", "metaData").item(0);
        this.setMetaData(new HierarchicalDataMetaData(metaDataElem));
    }

    public String convertValueToText(Object value) {
        Object realValue;
        if (value != null && (realValue = this.getValueAt(value, 0)) != null) {
            return realValue.toString();
        }
        return "";
    }

    public Object getRoot() {
        return this.dom.getDocumentElement().getElementsByTagNameNS("http://www.jdesktop.org/2004/05/jdnc", "rows").item(0);
    }

    public Class getColumnClass(int column) {
        return column == 0 ? super.getColumnClass(0) : this.getMetaData().getColumnClass(column + 1);
    }

    public Object getChild(Object parent, int index) {
        Element parentElement = (Element)parent;
        NodeList list = parentElement.getChildNodes();
        int i = 0;
        int k = index;
        int max = list.getLength();
        while (i < max) {
            Element elem;
            Node node;
            if (!((node = list.item(i++)) instanceof Element) || !(elem = (Element)node).getLocalName().equals("row") || k-- != 0) continue;
            return elem;
        }
        return null;
    }

    public int getChildCount(Object parent) {
        Element parentElement = (Element)parent;
        NodeList list = parentElement.getChildNodes();
        int i = 0;
        int k = 0;
        int max = list.getLength();
        Element elem = null;
        while (i < max) {
            Node node;
            if (!((node = list.item(i++)) instanceof Element) || !(elem = (Element)node).getLocalName().equals("row")) continue;
            ++k;
        }
        return k;
    }

    public void setMetaData(HierarchicalDataMetaData metaData) {
        this.metaData = metaData;
    }

    public HierarchicalDataMetaData getMetaData() {
        return this.metaData;
    }

    public int getColumnCount() {
        return this.getMetaData().getColumnCount();
    }

    public int getColumnIndex(String columnName) {
        return this.getMetaData().getColumnIndex(columnName);
    }

    public String getColumnName(int column) {
        return this.getMetaData().getColumnName(column + 1);
    }

    public Object getValueAt(Object node, int column) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null; " + column);
        }
        Element parentElement = (Element)node;
        NodeList list = parentElement.getChildNodes();
        int i = 0;
        int k = column;
        int max = list.getLength();
        while (i < max) {
            Element elem;
            Node n;
            if (!((n = list.item(i++)) instanceof Element) || !(elem = (Element)n).getLocalName().equals("cell") || k-- != 0) continue;
            Node cellData = elem.getFirstChild();
            String rawValue = cellData == null ? "" : cellData.getNodeValue();
            Converter converter = this.getMetaData().getColumnConverter(column + 1);
            if (converter == null) {
                return rawValue;
            }
            try {
                return converter.decode(rawValue, null);
            }
            catch (Exception ex) {
                return rawValue;
            }
        }
        return null;
    }
}

