/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import java.util.ArrayList;
import java.util.HashMap;
import org.jdesktop.swing.data.DataModel;
import org.jdesktop.swing.data.MetaData;
import org.jdesktop.swing.data.Validator;
import org.jdesktop.swing.data.ValueChangeEvent;
import org.jdesktop.swing.data.ValueChangeListener;

public abstract class AbstractDataModel
implements DataModel {
    protected ArrayList validators;
    private ArrayList valueChangeListeners;
    private HashMap valueChangeEvents;

    public abstract String[] getFieldNames();

    public MetaData[] getMetaData() {
        String[] fieldNames = this.getFieldNames();
        MetaData[] metaData = new MetaData[fieldNames.length];
        int i = 0;
        while (i < fieldNames.length) {
            metaData[i] = this.getMetaData(fieldNames[i]);
            ++i;
        }
        return metaData;
    }

    public abstract MetaData getMetaData(String var1);

    public abstract Object getValue(String var1);

    public void setValue(String fieldName, Object value) {
        Object oldValue = this.getValue(fieldName);
        this.setValueImpl(fieldName, value);
        if (oldValue != null && !oldValue.equals(value) || oldValue == null && value != null) {
            this.fireValueChanged(fieldName);
        }
    }

    protected abstract void setValueImpl(String var1, Object var2);

    public void addValidator(Validator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    public Validator[] getValidators() {
        if (this.validators != null) {
            return this.validators.toArray(new Validator[this.validators.size()]);
        }
        return new Validator[0];
    }

    public void addValueChangeListener(ValueChangeListener l) {
        if (this.valueChangeListeners == null) {
            this.valueChangeListeners = new ArrayList();
        }
        this.valueChangeListeners.add(l);
    }

    public void removeValueChangeListener(ValueChangeListener l) {
        if (this.valueChangeListeners != null) {
            this.valueChangeListeners.remove(l);
        }
    }

    public ValueChangeListener[] getValueChangeListeners() {
        if (this.valueChangeListeners != null) {
            return this.valueChangeListeners.toArray(new ValueChangeListener[1]);
        }
        return new ValueChangeListener[0];
    }

    protected void fireValueChanged(String fieldName) {
        ValueChangeListener[] formListeners = this.getValueChangeListeners();
        ValueChangeEvent e = this.getCachedEvent(fieldName);
        if (this.valueChangeListeners != null) {
            int i = 0;
            while (i < this.valueChangeListeners.size()) {
                ValueChangeListener vcl = (ValueChangeListener)this.valueChangeListeners.get(i);
                vcl.valueChanged(e);
                ++i;
            }
        }
    }

    private ValueChangeEvent getCachedEvent(String fieldName) {
        ValueChangeEvent event;
        if (this.valueChangeEvents == null) {
            this.valueChangeEvents = new HashMap();
        }
        if ((event = (ValueChangeEvent)this.valueChangeEvents.get(fieldName)) == null) {
            event = new ValueChangeEvent(this, fieldName);
            this.valueChangeEvents.put(fieldName, event);
        }
        return event;
    }
}

