/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.binding;

import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.swing.binding.AbstractBinding;
import org.jdesktop.swing.data.DataModel;

public class TextBinding
extends AbstractBinding {
    private JComponent component;
    private Document document;

    public TextBinding(JTextComponent textComponent, DataModel model, String fieldName) {
        super(textComponent, model, fieldName, 0);
        this.initDocument(textComponent.getDocument());
    }

    public TextBinding(JTextComponent textComponent, DataModel model, String fieldName, int validationPolicy) {
        super(textComponent, model, fieldName, validationPolicy);
        this.initDocument(textComponent.getDocument());
    }

    public TextBinding(JComponent component, Document document, DataModel dataModel, String fieldName, int validationPolicy) {
        super(component, dataModel, fieldName, validationPolicy);
        this.initDocument(document);
    }

    public JComponent getComponent() {
        return this.component;
    }

    protected void setComponent(JComponent component) {
        this.component = component;
    }

    protected Object getComponentValue() {
        String txt;
        try {
            txt = this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException e) {
            txt = null;
        }
        return txt;
    }

    protected void setComponentValue(Object value) {
        try {
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, this.convertFromModelType(value), null);
        }
        catch (BadLocationException e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.component);
        }
    }

    private void initDocument(Document document) {
        this.document = document;
        document.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.maybeModified();
            }

            public void insertUpdate(DocumentEvent e) {
                this.maybeModified();
            }

            public void removeUpdate(DocumentEvent e) {
                this.maybeModified();
            }

            public void maybeModified() {
                if (!TextBinding.this.pulling) {
                    TextBinding.this.setModified(true);
                }
            }
        });
    }
}

