/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.binding;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import org.jdesktop.swing.binding.Binding;
import org.jdesktop.swing.data.ConversionException;
import org.jdesktop.swing.data.Converter;
import org.jdesktop.swing.data.DataModel;
import org.jdesktop.swing.data.MetaData;
import org.jdesktop.swing.data.Validator;
import org.jdesktop.swing.data.ValueChangeEvent;
import org.jdesktop.swing.data.ValueChangeListener;

public abstract class AbstractBinding
implements Binding {
    protected DataModel dataModel;
    protected MetaData metaData;
    protected Object cachedValue;
    protected ArrayList errorList;
    protected boolean modified = false;
    protected int validState = 0;
    protected boolean pulling = false;
    protected boolean pushing = false;
    private PropertyChangeSupport pcs;
    private int validationPolicy;
    static /* synthetic */ Class class$0;

    protected AbstractBinding(JComponent component, DataModel dataModel, String fieldName, int validationPolicy) {
        this.setComponent(component);
        this.dataModel = dataModel;
        this.pcs = new PropertyChangeSupport(this);
        this.setValidationPolicy(validationPolicy);
        if (dataModel != null) {
            this.metaData = dataModel.getMetaData(fieldName);
            dataModel.addValueChangeListener(new ValueChangeListener(){

                public void valueChanged(ValueChangeEvent e) {
                    if (e.getFieldName().equals(AbstractBinding.this.metaData.getName()) && !AbstractBinding.this.pushing) {
                        AbstractBinding.this.pull();
                    }
                }
            });
        }
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public String getFieldName() {
        return this.metaData.getName();
    }

    public void setValidationPolicy(int policy) {
        int oldValidationPolicy = this.validationPolicy;
        this.validationPolicy = policy;
        if (policy != oldValidationPolicy) {
            this.firePropertyChange("validationPolicy", new Integer(oldValidationPolicy), new Integer(policy));
        }
        this.getComponent().setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                if (AbstractBinding.this.validationPolicy != 2) {
                    boolean isValid = AbstractBinding.this.isValid();
                    return isValid || AbstractBinding.this.validationPolicy != 1;
                }
                return true;
            }
        });
    }

    public int getValidationPolicy() {
        return this.validationPolicy;
    }

    public boolean pull() {
        this.pulling = true;
        this.cachedValue = this.dataModel.getValue(this.metaData.getName());
        this.setComponentValue(this.cachedValue);
        this.setModified(false);
        this.setValidState(0);
        this.pulling = false;
        return true;
    }

    public boolean isModified() {
        return this.modified;
    }

    protected void setModified(boolean modified) {
        boolean oldModified = this.modified;
        this.modified = modified;
        if (modified) {
            this.cachedValue = null;
            this.setValidState(0);
        }
        if (oldModified != modified) {
            this.firePropertyChange("modified", oldModified, modified);
        }
    }

    public boolean isValid() {
        if (this.validState != 0) {
            return this.validState == 1;
        }
        this.clearValidationErrors();
        Object componentValue = this.getComponentValue();
        boolean ok = this.checkRequired(componentValue);
        Object convertedValue = null;
        if (ok) {
            try {
                convertedValue = this.convertToModelType(componentValue);
            }
            catch (Exception e) {
                ok = false;
                this.addError("value must be type " + this.metaData.getElementClass().getName());
            }
        }
        if (ok) {
            ok = this.executeValidators(convertedValue);
        }
        if (ok) {
            this.cachedValue = convertedValue;
        }
        this.setValidState(ok ? 1 : 2);
        return this.validState == 1;
    }

    public int getValidState() {
        return this.validState;
    }

    private void setValidState(int validState) {
        int oldValidState = this.validState;
        this.validState = validState;
        if (oldValidState != validState && validState == 0) {
            this.clearValidationErrors();
        }
        if (validState != oldValidState) {
            this.firePropertyChange("validState", new Integer(oldValidState), new Integer(validState));
        }
    }

    private boolean checkRequired(Object componentValue) {
        if (this.metaData.isRequired() && (componentValue == null || componentValue instanceof String && ((String)componentValue).equals(""))) {
            this.addError("requires a value");
            return false;
        }
        return true;
    }

    protected Object convertToModelType(Object componentValue) throws ConversionException {
        Object convertedValue = null;
        if (componentValue == null || componentValue instanceof String && componentValue.equals("")) {
            return convertedValue;
        }
        Class elementClass = this.metaData.getElementClass();
        if (componentValue instanceof String) {
            String stringValue = (String)componentValue;
            Converter converter = this.metaData.getConverter();
            if (converter != null) {
                convertedValue = converter.decode(stringValue, this.metaData.getDecodeFormat());
            } else {
                Class clazz = this.metaData.getElementClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    convertedValue = componentValue;
                }
            }
        } else {
            if (!elementClass.isAssignableFrom(componentValue.getClass())) {
                throw new ConversionException("cannot assign component value");
            }
            convertedValue = componentValue;
        }
        return convertedValue;
    }

    protected String convertFromModelType(Object modelValue) {
        if (modelValue != null) {
            try {
                Converter converter = this.metaData.getConverter();
                return converter.encode(modelValue, this.metaData.getEncodeFormat());
            }
            catch (Exception e) {
                return modelValue.toString();
            }
        }
        return "";
    }

    protected boolean executeValidators(Object value) {
        Validator[] validators = this.metaData.getValidators();
        boolean isValid = true;
        int i = 0;
        while (i < validators.length) {
            String[] error = new String[1];
            boolean passed = validators[i].validate(value, null, error);
            if (!passed) {
                String errorMessage = error[0];
                if (errorMessage != null) {
                    this.addError(errorMessage);
                }
                isValid = false;
            }
            ++i;
        }
        return isValid;
    }

    public String[] getValidationErrors() {
        if (this.errorList != null) {
            return this.errorList.toArray(new String[1]);
        }
        return new String[0];
    }

    public void clearValidationErrors() {
        if (this.errorList != null) {
            this.errorList.clear();
        }
    }

    public abstract JComponent getComponent();

    protected abstract void setComponent(JComponent var1);

    protected abstract Object getComponentValue();

    protected abstract void setComponentValue(Object var1);

    protected void addError(String error) {
        if (this.errorList == null) {
            this.errorList = new ArrayList();
        }
        this.errorList.add(error);
    }

    public boolean push() {
        if (this.isValid()) {
            this.pushing = true;
            this.dataModel.setValue(this.metaData.getName(), this.cachedValue);
            this.setModified(false);
            this.pushing = false;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }
}

