/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIDefaults;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swing.JXFindDialog;
import org.jdesktop.swing.LinkHandler;
import org.jdesktop.swing.PaintUtils;
import org.jdesktop.swing.Searchable;
import org.jdesktop.swing.TablePrintable;
import org.jdesktop.swing.UIAction;
import org.jdesktop.swing.data.Link;
import org.jdesktop.swing.data.MetaData;
import org.jdesktop.swing.data.MetaDataProvider;
import org.jdesktop.swing.decorator.ComponentAdapter;
import org.jdesktop.swing.decorator.FilterPipeline;
import org.jdesktop.swing.decorator.HighlighterPipeline;
import org.jdesktop.swing.decorator.PipelineEvent;
import org.jdesktop.swing.decorator.PipelineListener;
import org.jdesktop.swing.decorator.Sorter;
import org.jdesktop.swing.table.ColumnHeaderRenderer;
import org.jdesktop.swing.table.DefaultTableModelExt;
import org.jdesktop.swing.table.TableColumnExt;

public class JXTable
extends JTable
implements PipelineListener,
Searchable {
    public static boolean TRACE = false;
    public static final int PRINT_MODE_NORMAL = 0;
    public static final int PRINT_MODE_FIT_WIDTH = 1;
    protected Sorter sorter = null;
    protected FilterPipeline filters = null;
    protected HighlighterPipeline highlighters = null;
    private final ComponentAdapter dataAdapter = new TableAdapter(this);
    private final MouseAdapter headerListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            if (JXTable.this.sortable) {
                JTableHeader header = (JTableHeader)e.getSource();
                JXTable table = (JXTable)header.getTable();
                if ((e.getModifiersEx() & 0x40) == 64) {
                    table.resetSorter();
                } else {
                    table.setSorter(header.getColumnModel().getColumnIndexAtX(e.getX()));
                }
                header.repaint();
            }
        }
    };
    private transient boolean isPrinting = false;
    private boolean sortable = false;
    private int visibleRowCount = 18;
    private JXFindDialog dialog = null;
    private int lastCol = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public JXTable() {
        this.init();
    }

    public JXTable(TableModel dm) {
        super(dm);
        this.init();
    }

    public JXTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.init();
    }

    public JXTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.init();
    }

    public JXTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.init();
    }

    public JXTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    public JXTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    protected void init() {
        ActionMap map = this.getActionMap();
        map.put("print", new Actions("print"));
        map.put("find", new Actions("find"));
        LinkHandler handler = new LinkHandler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
    }

    public TableCellRenderer getNewDefaultRenderer(Class columnClass) {
        TableCellRenderer renderer = this.getDefaultRenderer(columnClass);
        if (renderer != null) {
            try {
                return (TableCellRenderer)renderer.getClass().newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void setLazyValue(Hashtable h, Class c, String s) {
        h.put(c, new UIDefaults.ProxyLazyValue(s));
    }

    private void setLazyRenderer(Class c, String s) {
        this.setLazyValue(this.defaultRenderersByColumnClass, c, s);
    }

    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new UIDefaults();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setLazyRenderer(clazz, "javax.swing.table.DefaultTableCellRenderer");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setLazyRenderer(clazz2, "org.jdesktop.swing.JXTable$NumberRenderer");
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setLazyRenderer(clazz3, "org.jdesktop.swing.JXTable$DoubleRenderer");
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setLazyRenderer(clazz4, "org.jdesktop.swing.JXTable$DoubleRenderer");
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setLazyRenderer(clazz5, "org.jdesktop.swing.JXTable$DateRenderer");
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("javax.swing.Icon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setLazyRenderer(clazz6, "org.jdesktop.swing.JXTable$IconRenderer");
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("javax.swing.ImageIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setLazyRenderer(clazz7, "org.jdesktop.swing.JXTable$IconRenderer");
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setLazyRenderer(clazz8, "org.jdesktop.swing.JXTable$BooleanRenderer");
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("org.jdesktop.swing.data.Link");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setLazyRenderer(clazz9, "org.jdesktop.swing.JXTable$LinkRenderer");
    }

    private void find() {
        if (this.dialog == null) {
            this.dialog = new JXFindDialog(this);
        }
        this.dialog.setVisible(true);
    }

    public FilterPipeline getFilters() {
        return this.filters;
    }

    public void setFilters(FilterPipeline pipeline) {
        this.filters = pipeline;
        this.use(this.filters);
    }

    public HighlighterPipeline getHighlighters() {
        return this.highlighters;
    }

    public void setHighlighters(HighlighterPipeline pipeline) {
        this.highlighters = pipeline;
    }

    private void removeSorter() {
        this.sorter = null;
        this.getTableHeader().repaint();
    }

    public void tableChanged(TableModelEvent e) {
        Selection selection = new Selection(this);
        if (this.filters != null) {
            this.filters.flush();
        } else if (this.sorter != null) {
            this.sorter.refresh();
        }
        super.tableChanged(e);
        this.restoreSelection(selection);
    }

    public void contentsChanged(PipelineEvent e) {
        this.removeSorter();
        this.clearSelection();
        this.setRowHeight(this.getRowHeight());
        if (this.getAutoCreateColumnsFromModel()) {
            this.createDefaultColumnsFromModel();
        }
        this.revalidate();
        this.repaint();
    }

    public int getRowCount() {
        int count = this.filters == null ? this.getModel().getRowCount() : this.filters.getOutputSize();
        return count;
    }

    public int convertRowIndexToModel(int row) {
        if (this.sorter == null) {
            if (this.filters == null) {
                return row;
            }
            return this.filters.convertRowIndexToModel(row);
        }
        return this.sorter.convertRowIndexToModel(row);
    }

    public int convertRowIndexToView(int row) {
        if (this.sorter == null) {
            if (this.filters == null) {
                return row;
            }
            return this.filters.convertRowIndexToView(row);
        }
        return this.sorter.convertRowIndexToView(row);
    }

    public Object getValueAt(int row, int column) {
        if (this.sorter == null) {
            if (this.filters == null) {
                return super.getValueAt(row, column);
            }
            return this.filters.getValueAt(row, this.convertColumnIndexToModel(column));
        }
        return this.sorter.getValueAt(row, this.convertColumnIndexToModel(column));
    }

    public void setValueAt(Object aValue, int row, int column) {
        if (this.sorter == null) {
            if (this.filters == null) {
                super.setValueAt(aValue, row, column);
            } else {
                this.filters.setValueAt(aValue, row, this.convertColumnIndexToModel(column));
            }
        } else {
            this.sorter.setValueAt(aValue, row, this.convertColumnIndexToModel(column));
        }
    }

    public boolean isCellEditable(int row, int column) {
        if (this.sorter == null) {
            if (this.filters == null) {
                return super.isCellEditable(row, column);
            }
            return this.filters.isCellEditable(row, this.convertColumnIndexToModel(column));
        }
        return this.sorter.isCellEditable(row, this.convertColumnIndexToModel(column));
    }

    public void setModel(TableModel newModel) {
        super.setModel(newModel);
        this.use(this.filters);
    }

    private void use(FilterPipeline pipeline) {
        if (pipeline != null) {
            pipeline.addPipelineListener(this);
            pipeline.assign(this.getComponentAdapter());
            pipeline.flush();
        }
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (tableHeader != null) {
            tableHeader.addMouseListener(this.headerListener);
            tableHeader.setDefaultRenderer(new ColumnHeaderRenderer());
        }
        super.setTableHeader(tableHeader);
    }

    private void restoreSelection(Selection selection) {
        this.clearSelection();
        int i = 0;
        while (i < selection.selected.length) {
            if (selection.selected[i] != selection.lead) {
                int index = this.convertRowIndexToView(selection.selected[i]);
                this.selectionModel.addSelectionInterval(index, index);
            }
            ++i;
        }
        if (selection.lead >= 0) {
            selection.lead = this.convertRowIndexToView(selection.lead);
            this.selectionModel.addSelectionInterval(selection.lead, selection.lead);
        }
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    protected void resetSorter() {
        if (this.sorter != null) {
            Selection selection = new Selection(this);
            this.removeSorter();
            this.restoreSelection(selection);
        }
    }

    private Sorter refreshSorter(int columnIndex) {
        TableColumnExt column;
        Sorter newSorter;
        TableColumn col = this.getColumnModel().getColumn(columnIndex);
        if (col instanceof TableColumnExt && (newSorter = (column = (TableColumnExt)col).getSorter()) != null) {
            newSorter.interpose(this.filters, this.dataAdapter, this.sorter);
            return newSorter;
        }
        return this.sorter;
    }

    protected void setSorter(int columnIndex) {
        Selection selection = new Selection(this);
        if (this.sorter == null) {
            this.sorter = this.refreshSorter(columnIndex);
        } else {
            int modelColumnIndex = this.convertColumnIndexToModel(columnIndex);
            if (this.sorter.getColumnIndex() == modelColumnIndex) {
                this.sorter.toggle();
            } else {
                this.sorter = this.refreshSorter(columnIndex);
            }
        }
        this.restoreSelection(selection);
    }

    public Sorter getSorter(int columnIndex) {
        return this.sorter == null ? null : (this.sorter.getColumnIndex() == this.convertColumnIndexToModel(columnIndex) ? this.sorter : null);
    }

    protected void removeColumns() {
        TableColumnModel cm = this.getColumnModel();
        while (cm.getColumnCount() > 0) {
            cm.removeColumn(cm.getColumn(0));
        }
    }

    public List getColumns() {
        return null;
    }

    public TableColumnExt getColumnExt(Object identifier) {
        return (TableColumnExt)super.getColumn(identifier);
    }

    public TableColumnExt getColumnExt(int viewColumnIndex) {
        return (TableColumnExt)this.getColumnModel().getColumn(viewColumnIndex);
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultTableModelExt();
    }

    public void createDefaultColumnsFromModel() {
        TableModel model = this.getModel();
        if (model != null) {
            int i;
            int modelColumnCount = model.getColumnCount();
            TableColumn[] newColumns = new TableColumn[modelColumnCount];
            int i2 = 0;
            while (i2 < newColumns.length) {
                newColumns[i2] = this.createColumn(i2);
                ++i2;
            }
            if (model instanceof MetaDataProvider) {
                MetaData[] metaData = ((MetaDataProvider)((Object)model)).getMetaData();
                i = 0;
                while (i < metaData.length) {
                    newColumns[i].setIdentifier(metaData[i].getName());
                    newColumns[i].setHeaderValue(metaData[i].getLabel());
                    ++i;
                }
            }
            TableColumnModel columnModel = this.getColumnModel();
            while (columnModel.getColumnCount() > 0) {
                columnModel.removeColumn(columnModel.getColumn(0));
            }
            i = 0;
            while (i < newColumns.length) {
                this.addColumn(newColumns[i]);
                ++i;
            }
        }
    }

    protected TableColumn createColumn(int modelIndex) {
        return new TableColumnExt(modelIndex);
    }

    public int getColumnMargin() {
        return this.getColumnModel().getColumnMargin();
    }

    public void setColumnMargin(int value) {
        this.getColumnModel().setColumnMargin(value);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component stamp = super.prepareRenderer(renderer, row, column);
        if (this.highlighters == null) {
            return stamp;
        }
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.row = row;
        adapter.column = column;
        return this.highlighters.apply(stamp, adapter);
    }

    protected ComponentAdapter getComponentAdapter() {
        return this.dataAdapter;
    }

    public int search(String searchString) {
        return this.search(searchString, -1);
    }

    public int search(String searchString, int columnIndex) {
        Object pattern = null;
        if (searchString != null) {
            return this.search(Pattern.compile(searchString, 0), columnIndex);
        }
        return -1;
    }

    public int search(Pattern pattern) {
        return this.search(pattern, -1);
    }

    public int search(Pattern pattern, int startIndex) {
        return this.search(pattern, startIndex, false);
    }

    public int search(Pattern pattern, int startIndex, boolean backwards) {
        Container viewport;
        Object value;
        int c;
        int r;
        if (pattern == null) {
            this.lastCol = 0;
            return -1;
        }
        int rows = this.getRowCount();
        int endCol = this.getColumnCount();
        int startRow = startIndex + 1;
        int matchRow = -1;
        if (backwards) {
            r = startRow;
            while (r >= 0 && matchRow == -1) {
                c = endCol;
                while (c >= 0) {
                    value = this.getValueAt(r, c);
                    if (value != null && pattern.matcher(value.toString()).find()) {
                        this.changeSelection(r, c, false, false);
                        matchRow = r;
                        this.lastCol = c;
                        break;
                    }
                    --c;
                }
                if (matchRow == -1) {
                    this.lastCol = endCol;
                }
                --r;
            }
        } else {
            r = startRow;
            while (r < rows && matchRow == -1) {
                c = this.lastCol;
                while (c < endCol) {
                    value = this.getValueAt(r, c);
                    if (value != null && pattern.matcher(value.toString()).find()) {
                        this.changeSelection(r, c, false, false);
                        matchRow = r;
                        this.lastCol = c;
                        break;
                    }
                    ++c;
                }
                if (matchRow == -1) {
                    this.lastCol = 0;
                }
                ++r;
            }
        }
        if (matchRow != -1 && (viewport = this.getParent()) instanceof JViewport) {
            Rectangle rect = this.getCellRect(this.getSelectedRow(), 0, true);
            Point pt = ((JViewport)viewport).getViewPosition();
            rect.setLocation(rect.x - pt.x, rect.y - pt.y);
            ((JViewport)viewport).scrollRectToVisible(rect);
        }
        return matchRow;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension prefSize = super.getPreferredScrollableViewportSize();
        if (prefSize.getWidth() == 450.0 && prefSize.getHeight() == 400.0) {
            TableColumnModel columnModel = this.getColumnModel();
            int columnCount = columnModel.getColumnCount();
            int w = 0;
            int i = 0;
            while (i < columnCount) {
                TableColumn column = columnModel.getColumn(i);
                this.initializeColumnPreferredWidth(column);
                w += column.getPreferredWidth();
                ++i;
            }
            prefSize.width = w;
            JTableHeader header = this.getTableHeader();
            int rowCount = this.getVisibleRowCount();
            prefSize.height = rowCount * this.getRowHeight() + (header != null ? header.getPreferredSize().height : 0);
            this.setPreferredScrollableViewportSize(prefSize);
        }
        return prefSize;
    }

    protected void initializeColumnPreferredWidth(TableColumn column) {
        if (column instanceof TableColumnExt) {
            Dimension cellSpacing = this.getIntercellSpacing();
            TableColumnExt columnx = (TableColumnExt)column;
            Object prototypeValue = columnx.getPrototypeValue();
            if (prototypeValue != null) {
                JTableHeader header;
                TableCellRenderer renderer = this.getCellRenderer(0, this.convertColumnIndexToView(columnx.getModelIndex()));
                Component comp = renderer.getTableCellRendererComponent(this, prototypeValue, false, false, 0, 0);
                int prefWidth = comp.getPreferredSize().width + cellSpacing.width;
                renderer = columnx.getHeaderRenderer();
                if (renderer == null && (header = this.getTableHeader()) != null) {
                    renderer = header.getDefaultRenderer();
                }
                if (renderer != null) {
                    comp = renderer.getTableCellRendererComponent(this, columnx.getHeaderValue(), false, false, 0, this.convertColumnIndexToView(columnx.getModelIndex()));
                    prefWidth = Math.max(comp.getPreferredSize().width, prefWidth);
                }
                columnx.setPreferredWidth(prefWidth += this.getColumnModel().getColumnMargin());
            }
        }
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public boolean print() throws PrinterException {
        return this.print(1);
    }

    public boolean print(int printMode) throws PrinterException {
        return this.print(printMode, null, null);
    }

    public boolean print(int printMode, MessageFormat headerFormat, MessageFormat footerFormat) throws PrinterException {
        return this.print(printMode, headerFormat, footerFormat, true, null);
    }

    public boolean print(int printMode, MessageFormat headerFormat, MessageFormat footerFormat, boolean showPrintDialog, PrintRequestAttributeSet attr) throws PrinterException {
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        if (attr == null) {
            attr = new HashPrintRequestAttributeSet();
        }
        final PrintRequestAttributeSet attrset = attr;
        final PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this.getPrintable(printMode, headerFormat, footerFormat));
        if (showPrintDialog && !job.printDialog(attrset)) {
            return false;
        }
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        JXTable.this.isPrinting = true;
                        try {
                            try {
                                job.print(attrset);
                            }
                            catch (PrinterException e) {
                                e.printStackTrace();
                            }
                        }
                        finally {
                            JXTable.this.isPrinting = false;
                        }
                    }
                });
            }
        };
        timer.schedule(task, 100L);
        return true;
    }

    public Printable getPrintable(int printMode, MessageFormat headerFormat, MessageFormat footerFormat) {
        return new TablePrintable(this, printMode, headerFormat, footerFormat);
    }

    public String getToolTipText(MouseEvent e) {
        int col = this.columnAtPoint(e.getPoint());
        int row = this.rowAtPoint(e.getPoint());
        String res = "";
        Object value = this.getModel().getValueAt(row, this.convertColumnIndexToModel(col));
        if (value != null) {
            StringBuffer sb = new StringBuffer(value.toString());
            int i = 50;
            while (i < value.toString().length()) {
                sb.insert(i, "<br>");
                i += 50;
            }
            value = sb.toString();
        }
        Class<?> clazz = this.getColumnClass(col);
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("javax.swing.Icon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.equals(clazz2)) {
            res = "<html><body bgcolor=#EAEAEA>&nbsp;";
            res = String.valueOf(res) + "<b>" + this.getColumnName(col) + "</b>";
            res = String.valueOf(res) + " : " + value;
            res = String.valueOf(res) + "&nbsp;</body></html>";
        }
        return res;
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("print".equals(this.getName())) {
                try {
                    JXTable.this.print();
                }
                catch (PrinterException ex) {
                    ex.printStackTrace();
                }
            } else if ("find".equals(this.getName())) {
                JXTable.this.find();
            }
        }
    }

    static class TableAdapter
    extends ComponentAdapter {
        private final JTable table;

        public TableAdapter(JTable component) {
            super(component);
            this.table = component;
        }

        public JTable getTable() {
            return this.table;
        }

        public boolean hasFocus() {
            boolean colIsAnchor;
            if (this.table instanceof JXTable && ((JXTable)this.table).isPrinting()) {
                return false;
            }
            boolean rowIsAnchor = this.table.getSelectionModel().getAnchorSelectionIndex() == this.row;
            boolean bl = colIsAnchor = this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex() == this.column;
            return this.table.isFocusOwner() && rowIsAnchor && colIsAnchor;
        }

        public String getColumnName(int columnIndex) {
            TableColumnModel columnModel = this.table.getColumnModel();
            if (columnModel == null) {
                return "Column " + columnIndex;
            }
            TableColumn column = columnModel.getColumn(columnIndex);
            return column == null ? "" : column.getHeaderValue().toString();
        }

        public int getColumnCount() {
            return this.table.getModel().getColumnCount();
        }

        public int getRowCount() {
            return this.table.getModel().getRowCount();
        }

        public Object getValueAt(int row, int column) {
            return this.table.getModel().getValueAt(row, this.viewToModel(column));
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.table.getValueAt(row, column);
        }

        public void setValueAt(Object aValue, int row, int column) {
            this.table.getModel().setValueAt(aValue, row, this.viewToModel(column));
        }

        public boolean isCellEditable(int row, int column) {
            return this.table.getModel().isCellEditable(row, this.viewToModel(column));
        }

        public boolean isSelected() {
            if (this.table instanceof JXTable && ((JXTable)this.table).isPrinting()) {
                return false;
            }
            return this.table.isCellSelected(this.row, this.column);
        }

        public int modelToView(int columnIndex) {
            return this.table.convertColumnIndexToView(columnIndex);
        }

        public int viewToModel(int columnIndex) {
            return this.table.convertColumnIndexToModel(columnIndex);
        }
    }

    private static class Selection {
        protected final int[] selected;
        protected int lead = -1;

        protected Selection(JXTable table) {
            this.selected = table.getSelectedRows();
            int i = 0;
            while (i < this.selected.length) {
                this.selected[i] = table.convertRowIndexToModel(this.selected[i]);
                ++i;
            }
            if (this.selected.length > 0) {
                this.lead = table.convertRowIndexToModel(table.getSelectionModel().getLeadSelectionIndex());
            }
        }
    }

    static class NumberRenderer
    extends DefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            System.out.println("Formatter getTimeZone : " + this.formatter.getTimeZone());
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    static class IconRenderer
    extends DefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    public static class LinkRenderer
    extends DefaultTableCellRenderer {
        private static Color colorLive = new Color(0, 0, 238);
        private static Color colorVisited = new Color(82, 24, 139);

        public void setValue(Object value) {
            if (value != null && value instanceof Link) {
                Link link = (Link)value;
                this.setText(link.getText());
                this.setToolTipText(link.getURL().toString());
                if (link.getVisited()) {
                    this.setForeground(colorVisited);
                } else {
                    this.setForeground(colorLive);
                }
            } else {
                super.setValue(value != null ? value.toString() : "");
            }
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!this.getText().equals("")) {
                Rectangle rect = PaintUtils.getTextBounds(g, this);
                FontMetrics fm = g.getFontMetrics();
                int descent = fm.getDescent();
                g.drawLine(rect.x, rect.y + rect.height - descent + 1, rect.x + rect.width, rect.y + rect.height - descent + 1);
            }
        }
    }
}

