/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.jdesktop.swing.Application;
import org.jdesktop.swing.JXFindDialog;
import org.jdesktop.swing.Searchable;
import org.jdesktop.swing.UIAction;
import org.jdesktop.swing.actions.ActionManager;

public class JXEditorPane
extends JEditorPane
implements Searchable {
    private Matcher matcher;
    private UndoableEditListener undoHandler;
    private UndoManager undoManager;
    private CaretListener caretHandler;
    private JComboBox selector;
    private static final String ACTION_FIND = "find";
    private static final String ACTION_UNDO = "undo";
    private static final String ACTION_REDO = "redo";
    private JXFindDialog dialog = null;
    static /* synthetic */ Class class$0;

    public JXEditorPane() {
        this.init();
    }

    public JXEditorPane(String url) throws IOException {
        super(url);
        this.init();
    }

    public JXEditorPane(String type, String text) {
        super(type, text);
        this.init();
    }

    public JXEditorPane(URL initialPage) throws IOException {
        super(initialPage);
        this.init();
    }

    private void init() {
        this.addPropertyChangeListener(new PropertyHandler());
        this.getDocument().addUndoableEditListener(this.getUndoableEditListener());
        this.initActions();
    }

    CaretListener getCaretListener() {
        return this.caretHandler;
    }

    UndoableEditListener getUndoableEditListener() {
        if (this.undoHandler == null) {
            this.undoHandler = new UndoHandler();
            this.undoManager = new UndoManager();
        }
        return this.undoHandler;
    }

    public void setEditorKit(EditorKit kit) {
        super.setEditorKit(kit);
        if (kit instanceof StyledEditorKit) {
            if (this.caretHandler == null) {
                this.caretHandler = new CaretHandler();
            }
            this.addCaretListener(this.caretHandler);
        }
    }

    protected void initActions() {
        ActionMap map = this.getActionMap();
        map.put(ACTION_FIND, new Actions(ACTION_FIND));
        map.put(ACTION_UNDO, new Actions(ACTION_UNDO));
        map.put(ACTION_REDO, new Actions(ACTION_REDO));
    }

    private void updateActionState() {
        Runnable doEnabled = new Runnable(){

            public void run() {
                ActionManager manager = Application.getInstance().getActionManager();
                manager.setEnabled(JXEditorPane.ACTION_UNDO, JXEditorPane.this.undoManager.canUndo());
                manager.setEnabled(JXEditorPane.ACTION_REDO, JXEditorPane.this.undoManager.canRedo());
            }
        };
        SwingUtilities.invokeLater(doEnabled);
    }

    public JComboBox getParagraphSelector() {
        if (this.selector == null) {
            this.selector = new ParagraphSelector();
        }
        return this.selector;
    }

    protected void applyTag(HTML.Tag tag) {
        Document doc = this.getDocument();
        if (!(doc instanceof HTMLDocument)) {
            return;
        }
        HTMLDocument hdoc = (HTMLDocument)doc;
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        Element element = hdoc.getParagraphElement(start);
        SimpleAttributeSet newAttrs = new SimpleAttributeSet(element.getAttributes());
        newAttrs.addAttribute(StyleConstants.NameAttribute, tag);
        hdoc.setParagraphAttributes(start, end - start, newAttrs, true);
    }

    public void paste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this);
        if (content != null) {
            DataFlavor[] flavors = content.getTransferDataFlavors();
            try {
                int i = 0;
                while (i < flavors.length) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(flavors[i].getRepresentationClass())) {
                        Object data = content.getTransferData(flavors[i]);
                        if (flavors[i].isMimeTypeEqual("text/plain")) {
                            this.replaceSelection(data.toString());
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void find() {
        if (this.dialog == null) {
            this.dialog = new JXFindDialog(this);
        }
        this.dialog.setVisible(true);
    }

    public int search(String searchString) {
        return this.search(searchString, -1);
    }

    public int search(String searchString, int columnIndex) {
        Object pattern = null;
        if (searchString != null) {
            return this.search(Pattern.compile(searchString, 0), columnIndex);
        }
        return -1;
    }

    public int search(Pattern pattern) {
        return this.search(pattern, -1);
    }

    public int search(Pattern pattern, int startIndex) {
        return this.search(pattern, startIndex, false);
    }

    public int search(Pattern pattern, int startIndex, boolean backwards) {
        if (pattern == null) {
            return -1;
        }
        int start = startIndex + 1;
        int end = -1;
        Segment segment = new Segment();
        try {
            Document doc = this.getDocument();
            doc.getText(start, doc.getLength() - start, segment);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.matcher = pattern.matcher(segment.toString());
        if (!this.matcher.find()) {
            return -1;
        }
        start = this.matcher.start() + startIndex;
        end = this.matcher.end() + startIndex;
        this.select(start + 1, end + 1);
        return end;
    }

    private class PropertyHandler
    implements PropertyChangeListener {
        private PropertyHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("document")) {
                Document doc = (Document)evt.getOldValue();
                if (doc != null) {
                    doc.removeUndoableEditListener(JXEditorPane.this.getUndoableEditListener());
                }
                if ((doc = (Document)evt.getNewValue()) != null) {
                    doc.addUndoableEditListener(JXEditorPane.this.getUndoableEditListener());
                }
            }
        }
    }

    private class UndoHandler
    implements UndoableEditListener {
        private UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent evt) {
            JXEditorPane.this.undoManager.addEdit(evt.getEdit());
            JXEditorPane.this.updateActionState();
        }
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            String name = this.getName();
            if (JXEditorPane.ACTION_FIND.equals(name)) {
                JXEditorPane.this.find();
            } else if (JXEditorPane.ACTION_UNDO.equals(name)) {
                try {
                    JXEditorPane.this.undoManager.undo();
                }
                catch (CannotUndoException ex) {
                    ex.printStackTrace();
                }
                JXEditorPane.this.updateActionState();
            } else if (JXEditorPane.ACTION_REDO.equals(name)) {
                try {
                    JXEditorPane.this.undoManager.redo();
                }
                catch (CannotRedoException ex) {
                    ex.printStackTrace();
                }
                JXEditorPane.this.updateActionState();
            } else {
                System.out.println("ActionHandled: " + name);
            }
        }
    }

    private class ParagraphSelector
    extends JComboBox
    implements ItemListener {
        private Map itemMap = new HashMap();

        public ParagraphSelector() {
            this.itemMap.put(HTML.Tag.P, "Paragraph");
            this.itemMap.put(HTML.Tag.H1, "Heading 1");
            this.itemMap.put(HTML.Tag.H2, "Heading 2");
            this.itemMap.put(HTML.Tag.H3, "Heading 3");
            this.itemMap.put(HTML.Tag.H4, "Heading 4");
            this.itemMap.put(HTML.Tag.H5, "Heading 5");
            this.itemMap.put(HTML.Tag.H6, "Heading 6");
            this.itemMap.put(HTML.Tag.PRE, "Preformatted");
            Vector<HTML.Tag> items = new Vector<HTML.Tag>();
            items.addElement(HTML.Tag.P);
            items.addElement(HTML.Tag.H1);
            items.addElement(HTML.Tag.H2);
            items.addElement(HTML.Tag.H3);
            items.addElement(HTML.Tag.H4);
            items.addElement(HTML.Tag.H5);
            items.addElement(HTML.Tag.H6);
            items.addElement(HTML.Tag.PRE);
            this.setModel(new DefaultComboBoxModel(items));
            this.setRenderer(new ParagraphRenderer());
            this.addItemListener(this);
            this.setFocusable(false);
        }

        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                JXEditorPane.this.applyTag((HTML.Tag)evt.getItem());
            }
        }

        private class ParagraphRenderer
        extends DefaultListCellRenderer {
            public ParagraphRenderer() {
                this.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText((String)ParagraphSelector.this.itemMap.get(value));
                return this;
            }
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        public void caretUpdate(CaretEvent evt) {
            StyledDocument document = (StyledDocument)JXEditorPane.this.getDocument();
            int dot = evt.getDot();
            Element elem = document.getCharacterElement(dot);
            AttributeSet set = elem.getAttributes();
            ActionManager manager = Application.getInstance().getActionManager();
            manager.setSelected("font-bold", StyleConstants.isBold(set));
            manager.setSelected("font-italic", StyleConstants.isItalic(set));
            manager.setSelected("font-underline", StyleConstants.isUnderline(set));
            elem = document.getParagraphElement(dot);
            set = elem.getAttributes();
            if (JXEditorPane.this.selector != null) {
                JXEditorPane.this.selector.setSelectedItem(set.getAttribute(StyleConstants.NameAttribute));
            }
            switch (StyleConstants.getAlignment(set)) {
                case 0: {
                    manager.setSelected("left-justify", true);
                    break;
                }
                case 1: {
                    manager.setSelected("center-justify", true);
                    break;
                }
                case 2: {
                    manager.setSelected("right-justify", true);
                }
            }
        }
    }
}

