/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdnc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import org.jdesktop.jdnc.JNComponent;
import org.jdesktop.swing.actions.BoundAction;
import org.jdesktop.swing.binding.BindException;
import org.jdesktop.swing.data.DataModel;
import org.jdesktop.swing.data.TabularDataModel;
import org.jdesktop.swing.form.JForm;

public class JNForm
extends JNComponent {
    private JForm form;
    private JComponent buttonPanel;
    private Component trailGlue;

    public JNForm() {
        this.setLayout(new BorderLayout());
        this.form = this.createForm();
        this.add("Center", this.form);
        this.buttonPanel = this.createButtonPanel();
        this.addAction(this.form.getActionMap().get("reset"));
        this.addAction(this.form.getActionMap().get("submit"));
        this.add("South", this.buttonPanel);
    }

    protected JForm createForm() {
        return new JForm();
    }

    public JForm getForm() {
        return this.form;
    }

    public void bind(TabularDataModel tabularData) throws BindException {
        this.form.bind(tabularData);
    }

    public void bind(TabularDataModel tabularData, String columnName) throws BindException {
        this.form.bind(tabularData, columnName);
    }

    public void bind(Object bean) throws BindException {
        this.form.bind(bean);
    }

    public void bind(Object bean, String propertyName) throws BindException {
        this.form.bind(bean, propertyName);
    }

    public void bind(DataModel model) throws BindException {
        this.form.bind(model);
    }

    public void bind(DataModel model, String fieldName) throws BindException {
        this.form.bind(model, fieldName);
    }

    public JButton addAction(Action action) {
        JButton button = new JButton(action);
        button.setBackground(this.getBackground());
        if (action instanceof BoundAction) {
            BoundAction ba = (BoundAction)action;
            Object id = ba.getActionCommand();
            if ("submit".equals(id)) {
                ba.registerCallback(this.form, "doSubmit");
            } else if ("reset".equals(id)) {
                ba.registerCallback(this.form, "doReset");
            }
        }
        this.addToButtonPanel(button);
        return button;
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.form != null) {
            this.form.setBackground(background);
        }
        if (this.buttonPanel != null) {
            this.buttonPanel.setBackground(background);
            Component[] children = this.buttonPanel.getComponents();
            int i = 0;
            while (i < children.length) {
                children[i].setBackground(background);
                ++i;
            }
        }
    }

    protected JComponent createButtonPanel() {
        Box box = Box.createHorizontalBox();
        box.setBorder(new EmptyBorder(6, 6, 6, 6));
        box.add(Box.createHorizontalGlue());
        return box;
    }

    protected void addToButtonPanel(JComponent component) {
        int childCount = this.buttonPanel.getComponentCount();
        if (childCount > 1) {
            this.buttonPanel.remove(this.trailGlue);
            this.buttonPanel.add(Box.createHorizontalStrut(20));
        }
        this.buttonPanel.add(component);
        if (this.trailGlue == null) {
            this.trailGlue = Box.createHorizontalGlue();
        }
        this.buttonPanel.add(this.trailGlue);
    }
}

