#ifndef _SCANDIR_HPP_
#define _SCANDIR_HPP_

#include <time.h>
#include "a_list.hpp"
#include "utils.hpp"
#include "fidoaddr.h"
#include "msg.hpp"
#include "msgbase.hpp"
#include "outbound.hpp"
#include "ufmtypes.h"
#include "parsetpl.hpp"
#include "tmstamp.hpp"
#include "mask.hpp"

typedef enum { ACT_ERROR,
               ACT_MOVE, ACT_COPY, ACT_DELETE, ACT_REWRITE, ACT_NEWMSG,
               ACT_IGNORE, ACT_DISPLAY, ACT_ROUTE, ACT_FLAG, ACT_WRITEFILE,
               ACT_CALL, ACT_DELETEATTACH, ACT_CHANGEPATH, ACT_MOVEATTACH,
               ACT_SPLIT, ACT_ADDFILE, ACT_ADDNOTE, ACT_DELFILE, ACT_POLL,
               ACT_COPYATTACH, ACT_RECODE, ACT_SCRIPT
} tAct;

class Action {
public:
   IndBiList<tTimes> _Times;
   FA   _f;
   tAct _Act;
   char *_TplName;
   PKTMode _Flav;
   Template *_Tpl;
   char *_OutDir;
   MSGBASE *_Base;
   Mask   *_Mask;
   int    _Lines;
   ScanDir *sd;
   ScanDir *Before;
   ScanDir *After;
   Action();
   ~Action();
   void Print(void);
   int Do(MSGBASE &b, cMSG &m);
};   

class DoList {
   IndBiList<Mask> Masks;
   IndBiList<Action> Actions;
public:
   DoList();
   ~DoList();
   void AddAction(Action &Act);
   void AddMask(Mask &Msk);
   void Print(void);
   int Do(MSGBASE &b, cMSG &m);
   MaskType InMask(cMSG &m);
   
};

class ScanDir {
public:
   IndBiList<DoList> _DoLists;
   IndBiList<tTimes> _Times;
   MSGBASE *_Base;
   int     _Renumber;
   int     _Unpack;
   int     _Fresh;
   uint    _MaxAge;
   uint    _MaxAttachSize;
   char    *_LoopStr;
   char    *_FlagFile;
   char    *_FileInbound;
   char    *_ScriptBefore;
   char    *_ScriptAfter;
   ScanDir();
   ~ScanDir();
   void SetBase(MSGBASE *B) { _Base = B; };
   MSGBASE *Base(void) { return _Base; };
   void Print(void);
   int Do(void);
   int DoWithRoute(MSGBASE &b, cMSG &m);
   int Execute(MSGBASE &b, cMSG &m);
   int Flagged(void);
inline   uint MaxAge(void) { if (_MaxAge == 0) { return ::MaxAge; } else { return _MaxAge;}; };
inline   uint MaxAttachSize(void) { if (_MaxAttachSize == 0) return ::MaxAttachSize; else return _MaxAttachSize; };
inline   char *LoopStr(void) { if (_LoopStr == NULL) return ::LoopStr; else return _LoopStr; };
inline   char *FileInbound(void) { if (_FileInbound == NULL) return ::FileInbound; else return _FileInbound; };

};

extern IndBiList<ScanDir> ScanDirs;

int AddScanDir(void);
void PrintScanDirs(void);
void DoScanDirs(void);
int AddAction(void);

#endif

