/*
 * Decompiled with CFR 0.152.
 */
package uk.org.skeet.png;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import uk.org.skeet.png.Chunk;
import uk.org.skeet.png.Palette;
import uk.org.skeet.util.IOUtil;

public class PngEncoder {
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public static void encode(BufferedImage bi, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            PngEncoder.encode(bi, fos);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOUtil.close((OutputStream)fos);
            throw throwable;
        }
        IOUtil.close((OutputStream)fos);
    }

    public static void encode(BufferedImage bi, String filename) throws IOException {
        PngEncoder.encode(bi, new File(filename));
    }

    public static void encode(BufferedImage bi, File file, Palette pal) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            PngEncoder.encode(bi, fos, pal);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IOUtil.close((OutputStream)fos);
            throw throwable;
        }
        IOUtil.close((OutputStream)fos);
    }

    public static void encode(BufferedImage bi, String filename, Palette pal) throws IOException {
        PngEncoder.encode(bi, new File(filename), pal);
    }

    public static void encode(BufferedImage bi, OutputStream os) throws IOException {
        PngEncoder.encode(bi, os, new Palette(bi, 256, true));
    }

    public static void encode(BufferedImage bi, OutputStream os, Palette pal) throws IOException {
        Chunk header = new Chunk("IHDR");
        Chunk palChunk = new Chunk("PLTE");
        Chunk trans = new Chunk("tRNS");
        Chunk data = new Chunk("IDAT");
        Chunk end = new Chunk("IEND");
        DeflaterOutputStream dos = new DeflaterOutputStream(data.getDataStream());
        try {
            os.write(PNG_SIGNATURE);
            int width = bi.getWidth();
            int height = bi.getHeight();
            header.writeInt(width);
            header.writeInt(height);
            header.writeByte(8);
            header.writeByte(3);
            header.writeByte(0);
            header.writeByte(0);
            header.writeByte(0);
            header.output(os);
            int i = 0;
            while (i < pal.getSize()) {
                palChunk.writeByte(pal.getRed(i));
                palChunk.writeByte(pal.getGreen(i));
                palChunk.writeByte(pal.getBlue(i));
                ++i;
            }
            palChunk.output(os);
            int i2 = 0;
            while (i2 < pal.getTransparentIndex()) {
                trans.writeByte(255);
                ++i2;
            }
            trans.writeByte(0);
            trans.output(os);
            int[] rgb = new int[width];
            boolean xx = false;
            int y = 0;
            while (y < height) {
                bi.getRGB(0, y, width, 1, rgb, 0, width);
                byte[] indices = pal.getIndices(rgb, 0, rgb.length);
                dos.write(0);
                dos.write(indices, 0, width);
                ++y;
            }
            dos.finish();
            data.output(os);
            end.output(os);
            Object var18_17 = null;
            header.close();
            palChunk.close();
            trans.close();
            data.close();
            end.close();
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            header.close();
            palChunk.close();
            trans.close();
            data.close();
            end.close();
            IOUtil.close((OutputStream)dos);
            throw throwable;
        }
        IOUtil.close((OutputStream)dos);
    }
}

