/*
 * Decompiled with CFR 0.152.
 */
package ftjava.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLUtilities {
    private static String indent = "    ";

    public static Document getDOMDocument(InputStream in) throws Exception {
        Document d = null;
        DOMParser parser = new DOMParser();
        parser.parse(new InputSource(in));
        d = parser.getDocument();
        return d;
    }

    public static Document getDOMDocument(File in) throws Exception {
        InputStream is = in.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(in)) : new FileInputStream(in);
        return XMLUtilities.getDOMDocument(is);
    }

    public static void setIndent(String i) {
        indent = i;
    }

    public static String getIndent() {
        return indent;
    }

    public static boolean attributeExists(Node node, String name) {
        return XMLUtilities.getAttribute(node, name) != null;
    }

    public static String getAttribute(Node node, String name) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node tempnode = attrs.item(i);
                if (!tempnode.getNodeName().equals(name)) continue;
                return tempnode.getNodeValue();
            }
        }
        return null;
    }

    public static double getNumericAttribute(Node node, String name) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node tempnode = attrs.item(i);
                if (!tempnode.getNodeName().equals(name)) continue;
                String theValue = tempnode.getNodeValue();
                if (theValue.indexOf(44) != -1) {
                    theValue = theValue.replace(',', '.');
                }
                return Double.valueOf(theValue);
            }
        }
        return 0.0;
    }

    public static boolean getBooleanAttribute(Node node, String name) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node tempnode = attrs.item(i);
                if (!tempnode.getNodeName().equals(name)) continue;
                return Boolean.valueOf(tempnode.getNodeValue());
            }
        }
        return false;
    }

    public static String wrapSpecialCharsXML(String input) {
        char[] inputArray = input.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < inputArray.length; ++i) {
            if (inputArray[i] == '&') {
                sb.append("&amp;");
                continue;
            }
            if (inputArray[i] == '<') {
                sb.append("&lt;");
                continue;
            }
            if (inputArray[i] == '>') {
                sb.append("&gt;");
                continue;
            }
            sb.append(inputArray[i]);
        }
        return sb.toString();
    }

    public static String unwrapSpecialCharsXML(String input) {
        int indexAmp = input.indexOf("&amp;");
        int indexLt = input.indexOf("&lt;");
        int indexGt = input.indexOf("&gt;");
        if (indexAmp == -1 && indexLt == -1 && indexGt == -1) {
            return input;
        }
        StringBuffer sb = new StringBuffer(input);
        if (indexLt != -1) {
            sb.replace(indexLt, indexLt + 4, "<");
            return XMLUtilities.unwrapSpecialCharsXML(sb.toString());
        }
        if (indexGt != -1) {
            sb.replace(indexGt, indexGt + 4, ">");
            return XMLUtilities.unwrapSpecialCharsXML(sb.toString());
        }
        if (indexAmp != -1) {
            sb.delete(indexAmp + 1, indexAmp + 4);
            return XMLUtilities.unwrapSpecialCharsXML(sb.toString());
        }
        return input;
    }
}

