/*
 * Decompiled with CFR 0.152.
 */
package ftjava.util;

import ftjava.std.GameEngine;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import java.util.StringTokenizer;

public class ParserUtilities {
    public static final int UNASSIGNED = -1;
    public static final int MAIN_DRIVE_BURN = 0;
    public static final int ROTATE_PORT = 1;
    public static final int ROTATE_STARBOARD = 2;
    public static final int PUSH_PORT = 3;
    public static final int PUSH_STARBOARD = 4;
    public static final int PUSH_AFT = 5;
    public static final int ROLL = 6;
    public static final int JUMP = 7;
    public static final int FTL = 8;
    public static final int STRIKE = 9;
    private static final int NUM_CINEMATIC_ELEMENTS = 6;
    public static final int CINEMATIC_COURSE = 0;
    public static final int CINEMATIC_SPEED = 1;
    public static final int CINEMATIC_ROLL = 2;
    public static final int CINEMATIC_JUMP = 3;
    public static final int CINEMATIC_STRIKE = 4;
    public static final int CINEMATIC_SIDESLIP = 5;
    public static final String FTL_ORDERS = "FTL";
    public static final String STRIKE_ORDERS = "STRIKE";

    private ParserUtilities() {
    }

    public static int parseCinematicOrdersCourse(String orders) {
        int[] results = ParserUtilities.parseCinematicOrders(orders);
        return results[0];
    }

    public static int parseCinematicOrdersSideslip(String orders) {
        int[] results = ParserUtilities.parseCinematicOrders(orders);
        return results[5];
    }

    public static int parseCinematicOrdersSpeed(String orders) {
        int[] results = ParserUtilities.parseCinematicOrders(orders);
        return results[1];
    }

    public static int parseCinematicOrdersRoll(String orders) {
        int[] results = ParserUtilities.parseCinematicOrders(orders);
        return results[2];
    }

    public static int parseCinematicOrdersJump(String orders) {
        int[] results = ParserUtilities.parseCinematicOrders(orders);
        return results[3];
    }

    public static int parseCinematicOrdersStrike(String orders) {
        int[] results = ParserUtilities.parseCinematicOrders(orders);
        return results[4];
    }

    public static int[] parseCinematicOrders(String orders) {
        int i;
        Character p = new Character('P');
        Character s = new Character('S');
        Character zChar = new Character('Z');
        Character cChar = new Character('C');
        Character r = new Character('R');
        Character plus = new Character('+');
        Character minus = new Character('-');
        Character j = new Character('J');
        int[] results = new int[6];
        int courseSign = 0;
        int course = 0;
        int velocitySign = 0;
        int velocity = 0;
        int roll = 0;
        int sideslip = 0;
        boolean jump = false;
        boolean strike = false;
        int rCourse = 0;
        int rVelocity = 0;
        int rRoll = 0;
        int rJump = 0;
        int rStrike = 0;
        int rSideslip = 0;
        int firstDigit = -1;
        int secondDigit = -1;
        for (i = 0; i < results.length; ++i) {
            results[i] = 0;
        }
        if (orders.length() == 0) {
            return results;
        }
        orders = orders.toUpperCase();
        char[] byChar = orders.toCharArray();
        for (i = 0; i < byChar.length; ++i) {
            if (Character.isWhitespace(byChar[i])) continue;
            Character c = new Character(byChar[i]);
            if (c.equals(r)) {
                roll = 1;
            }
            if (c.equals(p) && courseSign == 0) {
                courseSign = -1;
            }
            if (c.equals(s) && courseSign == 0) {
                courseSign = 1;
            }
            if (c.equals(zChar) && courseSign == 0) {
                courseSign = -1;
                sideslip = 1;
            }
            if (c.equals(cChar) && courseSign == 0) {
                courseSign = 1;
                sideslip = 1;
            }
            if (c.equals(plus) && velocitySign == 0) {
                velocitySign = 1;
            }
            if (c.equals(minus) && velocitySign == 0) {
                velocitySign = -1;
            }
            if (c.equals(j)) {
                jump = true;
            }
            if (!Character.isDigit(byChar[i])) continue;
            if (firstDigit == -1) {
                firstDigit = Character.getNumericValue(byChar[i]);
                continue;
            }
            if (secondDigit != -1) continue;
            secondDigit = Character.getNumericValue(byChar[i]);
        }
        if (orders.indexOf(FTL_ORDERS) > -1) {
            jump = true;
        }
        if (orders.indexOf(STRIKE_ORDERS) > -1) {
            strike = true;
        }
        if (strike || jump || firstDigit == -1) {
            course = 0;
            courseSign = 0;
            velocitySign = 0;
            velocity = 0;
            sideslip = 0;
        } else if (firstDigit != -1 && secondDigit == -1) {
            if (courseSign == 0) {
                velocity = firstDigit;
            } else {
                course = firstDigit;
            }
        } else if (firstDigit != -1 && secondDigit != -1) {
            course = firstDigit;
            velocity = secondDigit;
        }
        if (velocity != 0 && velocitySign == 0) {
            velocitySign = 1;
        }
        rCourse = courseSign * course;
        rVelocity = velocitySign * velocity;
        rRoll = roll;
        rJump = jump ? 1 : 0;
        rStrike = strike ? 1 : 0;
        rSideslip = sideslip;
        results[0] = rCourse;
        results[1] = rVelocity;
        results[2] = rRoll;
        results[3] = rJump;
        results[4] = rStrike;
        results[5] = rSideslip;
        return results;
    }

    public static int parseArcString(String a) {
        int arcs = 0;
        if (a.length() == 0) {
            return arcs;
        }
        String p = a.replace('(', ' ');
        p = p.replace(')', ' ');
        p = p.replace('/', ' ');
        if ((p = p.toUpperCase()).indexOf(" F ") >= 0) {
            arcs |= Weapon.FORE_ARC;
        }
        if (p.indexOf(" FP ") >= 0) {
            arcs |= Weapon.FORE_PORT_ARC;
        }
        if (p.indexOf(" FS ") >= 0) {
            arcs |= Weapon.FORE_STARBOARD_ARC;
        }
        if (p.indexOf(" A ") >= 0) {
            arcs |= Weapon.AFT_ARC;
        }
        if (p.indexOf(" AP ") >= 0) {
            arcs |= Weapon.AFT_PORT_ARC;
        }
        if (p.indexOf(" AS ") >= 0) {
            arcs |= Weapon.AFT_STARBOARD_ARC;
        }
        if (p.indexOf(" ALL ") >= 0) {
            arcs |= Weapon.ALL_ARCS;
        }
        if (p.indexOf(" P ") >= 0) {
            arcs |= Weapon.PORT_BROADSIDE_ARCS;
        }
        if (p.indexOf(" S ") >= 0) {
            arcs |= Weapon.STARBOARD_BROADSIDE_ARCS;
        }
        return arcs;
    }

    public static double[] parseCoordinates(String a) {
        int i = 0;
        double[] coords = new double[]{0.0, 0.0, 0.0};
        if (a.length() == 0) {
            return coords;
        }
        StringTokenizer st = new StringTokenizer(a, "(/, )");
        while (i < 3 && st.hasMoreTokens()) {
            coords[i++] = Double.valueOf(st.nextToken());
        }
        return coords;
    }

    public static SpaceObject parseName(String a, GameEngine g) {
        Ship o = null;
        a = a.toUpperCase();
        int count = 0;
        for (int i = 0; i < g.getNumberOfShips(); ++i) {
            String name = g.getShip(i).getName();
            if (!(name = name.toUpperCase()).startsWith(a)) continue;
            ++count;
            o = g.getShip(i);
        }
        return o;
    }

    public static int parseInteger(String s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        StringBuffer sb = new StringBuffer(s);
        int i = 0;
        while (i < sb.length()) {
            if (!Character.isDigit(sb.charAt(i))) {
                sb.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return Integer.parseInt(sb.toString());
    }

    public static int parseVectorOrder(String token) {
        if (token == null || token.length() == 0) {
            return 0;
        }
        if (token.indexOf("MD") >= 0) {
            return 0;
        }
        if (token.indexOf("TP") >= 0) {
            return 1;
        }
        if (token.indexOf("RP") >= 0) {
            return 1;
        }
        if (token.indexOf("TS") >= 0) {
            return 2;
        }
        if (token.indexOf("RS") >= 0) {
            return 2;
        }
        if (token.indexOf("PP") >= 0) {
            return 3;
        }
        if (token.indexOf("PS") >= 0) {
            return 4;
        }
        if (token.indexOf("PR") >= 0) {
            return 5;
        }
        if (token.indexOf("PA") >= 0) {
            return 5;
        }
        if (token.indexOf("RO") >= 0) {
            return 6;
        }
        if (token.indexOf("J") >= 0) {
            return 7;
        }
        if (token.indexOf(FTL_ORDERS) >= 0) {
            return 7;
        }
        if (token.indexOf(STRIKE_ORDERS) >= 0) {
            return 9;
        }
        return 0;
    }
}

