/*
 * Decompiled with CFR 0.152.
 */
package ftjava.util;

public class MathUtil {
    private MathUtil() {
    }

    public static double toRadians(double deg) {
        return deg / 180.0 * Math.PI;
    }

    public static double toDegrees(double rad) {
        return rad / Math.PI * 180.0;
    }

    public static double angleFromHeading(int h) {
        double angle;
        for (angle = 90.0 - (double)h * 30.0; angle < 0.0; angle += 360.0) {
        }
        return angle;
    }

    public static double angleFromHeading(double h) {
        double angle;
        for (angle = 90.0 - h * 30.0; angle < 0.0; angle += 360.0) {
        }
        return angle;
    }

    public static double headingFromAngle(double angle) {
        double h;
        for (h = (90.0 - angle) / 30.0; h < 1.0; h += 12.0) {
        }
        return h;
    }

    public static double X(int heading) {
        return Math.cos(MathUtil.toRadians(MathUtil.angleFromHeading(heading)));
    }

    public static double Y(int heading) {
        return Math.sin(MathUtil.toRadians(MathUtil.angleFromHeading(heading)));
    }

    public static double X(double heading) {
        return Math.cos(MathUtil.toRadians(MathUtil.angleFromHeading(heading)));
    }

    public static double Y(double heading) {
        return Math.sin(MathUtil.toRadians(MathUtil.angleFromHeading(heading)));
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static double[] intersectLineCircle(double x1In, double y1In, double x2In, double y2In, double xcIn, double ycIn, double radius) {
        double x1 = x1In - xcIn;
        double y1 = y1In - ycIn;
        double x2 = x2In - xcIn;
        double y2 = y2In - ycIn;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dr = Math.sqrt(dx * dx + dy * dy);
        double D = x1 * y2 - x2 * y1;
        double drSqr = dr * dr;
        double dis = radius * radius * dr * dr - D * D;
        if (dis < 0.0) {
            return new double[0];
        }
        dis = Math.sqrt(dis);
        double sign = Math.signum(dy);
        if (sign == 0.0) {
            sign = 1.0;
        }
        double xInt1 = (D * dy + sign * dx * dis) / drSqr;
        double yInt1 = (-D * dx + Math.abs(dy) * dis) / drSqr;
        double xInt2 = (D * dy - sign * dx * dis) / drSqr;
        double yInt2 = (-D * dx - Math.abs(dy) * dis) / drSqr;
        xInt1 += xcIn;
        yInt1 += ycIn;
        xInt2 += xcIn;
        yInt2 += ycIn;
        double t1 = 0.0;
        double t2 = 0.0;
        if (dx != 0.0) {
            t1 = (xInt1 - x1In) / dx;
            t2 = (xInt2 - x1In) / dx;
        } else {
            t1 = (yInt1 - y1In) / dy;
            t2 = (yInt2 - y1In) / dy;
        }
        double[] result = new double[6];
        if (t1 < t2) {
            result[0] = xInt1;
            result[1] = yInt1;
            result[2] = t1;
            result[3] = xInt2;
            result[4] = yInt2;
            result[5] = t2;
        } else {
            result[0] = xInt2;
            result[1] = yInt2;
            result[2] = t2;
            result[3] = xInt1;
            result[4] = yInt1;
            result[5] = t1;
        }
        return result;
    }
}

