/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std.victoryconditions;

import ftjava.std.GameEngine;
import ftjava.std.victoryconditions.ShipFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class VictoryCondition {
    protected ArrayList children = new ArrayList();
    protected ArrayList filters = new ArrayList();
    public HashMap parameters = new HashMap();

    public String toXML() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        StringBuffer xml = new StringBuffer();
        xml.append("<" + name + " ");
        Iterator keys = this.parameters.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            xml.append(key + "=\"" + this.parameters.get(key) + "\" ");
        }
        xml.append(">\n");
        Iterator i = this.filters.iterator();
        while (i.hasNext()) {
            ShipFilter filter = (ShipFilter)i.next();
            xml.append(filter.toXML());
        }
        xml.append("<Children>\n");
        i = this.children.iterator();
        while (i.hasNext()) {
            VictoryCondition c = (VictoryCondition)i.next();
            xml.append(c.toXML());
        }
        xml.append("</Children>\n");
        xml.append("</" + name + ">\n");
        return xml.toString();
    }

    public abstract boolean isSatisfied(GameEngine var1);

    public void addChild(VictoryCondition condition) {
        this.children.add(condition);
    }

    public void addFilter(ShipFilter filter) {
        this.filters.add(filter);
    }

    public ArrayList getAllMatchingShips(GameEngine engine) {
        ArrayList matches = new ArrayList();
        Iterator i = this.filters.iterator();
        while (i.hasNext()) {
            ShipFilter filter = (ShipFilter)i.next();
            matches.add(filter.getMatchingShips(engine).iterator());
        }
        return matches;
    }
}

