/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std.victoryconditions;

import ftjava.std.GameEngine;
import ftjava.std.Player;
import ftjava.std.Ship;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class ShipFilter {
    public static final int SHIP_MODE = 0;
    public static final int PLAYER_MODE = 1;
    public static final int TEAM_MODE = 2;
    protected int mode = 0;
    protected String match;
    protected HashSet ids = new HashSet();

    public void setMatchPlayer(String player) {
        this.match = player;
        this.mode = 1;
    }

    public void setMatchTeam(String team) {
        this.match = team;
        this.mode = 2;
    }

    public void setMatchShips() {
        this.mode = 0;
    }

    public void clearIds() {
        this.ids.clear();
    }

    public void addShipToMatch(Ship s) {
        this.addShipToMatch(s.getId());
    }

    public void addShipToMatch(int i) {
        this.ids.add(new Integer(i));
    }

    public void addShipToMatch(String s) {
        this.addShipToMatch(Integer.parseInt(s));
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<Filter ");
        if (this.mode == 2) {
            xml.append("Team=\"" + this.match + "\" ");
        }
        if (this.mode == 1) {
            xml.append("Player=\"" + this.match + "\" ");
        }
        xml.append(">\n");
        Iterator i = this.ids.iterator();
        while (i.hasNext()) {
            xml.append("<Id>" + i.next() + "</Id>\n");
        }
        xml.append("</Filter>");
        return xml.toString();
    }

    public ArrayList getMatchingShips(GameEngine engine) {
        ArrayList<Object> matches = new ArrayList<Object>();
        if (this.mode == 2) {
            if (engine.getTeams().containsKey(this.match)) {
                matches.add((ArrayList)engine.getTeams().get(this.match));
            }
            return matches;
        }
        if (this.mode == 1) {
            Iterator i = engine.getPlayers().iterator();
            while (i.hasNext()) {
                Player player = (Player)i.next();
                if (!player.getName().equals(this.match)) continue;
                matches.add(player.getShips());
                return matches;
            }
            return matches;
        }
        if (this.mode == 0) {
            Iterator shipIterator = engine.getShips().iterator();
            while (shipIterator.hasNext()) {
                Ship s = (Ship)shipIterator.next();
                if (!this.ids.contains(new Integer(s.getId()))) continue;
                matches.add(s);
            }
            return matches;
        }
        return matches;
    }
}

