/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std.variant;

import ftjava.std.PulseTorpedo;
import ftjava.std.ShipSystem;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;

public class ShortRangePulseTorpedo
extends PulseTorpedo {
    public ShortRangePulseTorpedo() {
        this(Weapon.FORE_ARC);
    }

    public ShortRangePulseTorpedo(String arcString) {
        this(Weapon.parseArcString(arcString));
    }

    public ShortRangePulseTorpedo(int a) {
        this.setArcs(a);
        this.setSystemName("Short Range Pulse Torpedo Launcher " + this.getArcsString());
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setMaximumRange(3.33 * this.getOptions().getPulseTorpedoRangeBand());
    }

    public void setValue(String Name, String Value) {
        if (Name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(Value));
            this.setSystemName("Short Range Pulse Torpedo Launcher " + this.getArcsString());
        } else {
            super.setValue(Name, Value);
        }
    }

    public double getRangeBand() {
        return 0.666 * this.getOptions().getPulseTorpedoRangeBand();
    }

    public int computeMass() {
        int mass = 2;
        int count = this.computeNumberOfArcs();
        if (count > 1) {
            mass = 3;
        }
        return mass;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String s = "";
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        if (level >= 6) {
            return s;
        }
        sb.append(t);
        sb.append(t);
        sb.append("<ShortRangePulseTorpedo");
        if (level > 0) {
            sb.append(" id=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" arcs=\"");
        sb.append(this.getArcsString());
        sb.append("\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"");
            sb.append(this.getSystemStatus());
            sb.append("\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        sb.append(sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("ShortRangePulseTorpedo", new ShortRangePulseTorpedo());
    }
}

