/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std.importer;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.AntiMatterTorpedoLauncher;
import ftjava.std.AreaDefenseFireControl;
import ftjava.std.BeamBattery;
import ftjava.std.FighterBay;
import ftjava.std.FighterGroup;
import ftjava.std.FighterOrders;
import ftjava.std.FireControl;
import ftjava.std.GameEngine;
import ftjava.std.KineticGun;
import ftjava.std.Missile;
import ftjava.std.MissileLauncher;
import ftjava.std.MissileSalvo;
import ftjava.std.NovaCannon;
import ftjava.std.NovaCannonBolt;
import ftjava.std.PlasmaBolt;
import ftjava.std.PlasmaBoltLauncher;
import ftjava.std.Player;
import ftjava.std.PointDefense;
import ftjava.std.Pulser;
import ftjava.std.SalvoMissileLauncher;
import ftjava.std.SalvoMissileRack;
import ftjava.std.Scattergun;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.VapourShroud;
import ftjava.std.WaveGun;
import ftjava.std.WaveGunBolt;
import ftjava.std.Weapon;
import ftjava.std.importer.ImportMessages;
import ftjava.util.GameOptions;
import ftjava.util.XMLUtilities;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportOrders {
    public ImportOrders() {
    }

    public ImportOrders(GameEngine theGame) {
    }

    public void readOrders(GameEngine g, File inFile) throws Exception {
        Document d = XMLUtilities.getDOMDocument(inFile);
        this.parseOrders(g, null, null, null, d.getDocumentElement());
    }

    public void readOrders(GameEngine g, InputStream inStream) throws Exception {
        Document d = XMLUtilities.getDOMDocument(inStream);
        this.parseOrders(g, null, null, null, d.getDocumentElement());
    }

    private void parseOrders(GameEngine game, Player p, Ship s, FighterGroup f, Node node) throws Exception {
        NodeList children;
        Weapon pd;
        Weapon w;
        int tarId;
        boolean launchable;
        int newId;
        int lid;
        int hdg;
        double y;
        double x;
        int gid = 0;
        int pid = 0;
        int sid = 0;
        int fid = 0;
        int tid = 0;
        int inputKey = 0;
        SpaceObject so = null;
        String name = node.getNodeName();
        if (name.equals("GameEngine") && (gid = (int)XMLUtilities.getNumericAttribute(node, "id")) != game.getId()) {
            throw new Exception("Wrong game!");
        }
        if (name.equals("PlayerOrders")) {
            pid = (int)XMLUtilities.getNumericAttribute(node, "id");
            p = game.getPlayerById(pid);
            if (p == null) {
                throw new Exception("No player in this game!");
            }
            inputKey = (int)XMLUtilities.getNumericAttribute(node, "key");
            if (p.getKey() != inputKey) {
                System.out.println("Security violation - Bad keycodes");
                throw new Exception("Security violation - Bad keycodes");
            }
            String sendCompressed = XMLUtilities.getAttribute(node, "compress");
            if (sendCompressed != null && sendCompressed.equals("true")) {
                p.setSendCompressed(true);
            }
        }
        if (name.equals("Messages")) {
            ArrayList t = ImportMessages.parseMessages(node);
            if (p == null) {
                throw new Exception("Null player!");
            }
            p.setOutgoingMessageLog(t);
        }
        if (name.equals("ShipOrders")) {
            sid = (int)XMLUtilities.getNumericAttribute(node, "id");
            if (p == null) {
                throw new Exception("Null player!");
            }
            if (!p.doesPlayerOwnShipId(sid)) {
                throw new Exception("Player does not own this ship!");
            }
            s = game.getShipById(sid);
            if (s == null) {
                throw new Exception("No ship in this game!");
            }
        }
        if (name.equals("FighterOrders")) {
            fid = (int)XMLUtilities.getNumericAttribute(node, "id");
            if (p == null) {
                throw new Exception("Null player!");
            }
            if (!p.doesPlayerOwnSpaceObjectId(fid)) {
                throw new Exception("Player does not own this fighter!");
            }
            so = game.getObjectById(fid);
            if (so == null) {
                throw new Exception("No fighter " + fid + " in this game!");
            }
            if (so instanceof FighterGroup) {
                f = (FighterGroup)so;
                s = null;
            } else {
                throw new Exception("No fighter " + fid + " in this game!");
            }
        }
        if (name.equals("Orders")) {
            if (p == null) {
                throw new Exception("Null player!");
            }
            if (f == null && s == null) {
                throw new Exception("Null object!");
            }
            Node nn = null;
            if (s != null) {
                nn = node.getFirstChild();
                if (nn == null) {
                    s.setOrders("0");
                } else {
                    s.setOrders(node.getFirstChild().getNodeValue());
                }
            } else if (f != null) {
                nn = node.getFirstChild();
                if (nn == null) {
                    f.setFighterOrders((FighterOrders)FighterGroup.orderChoices.get(0));
                } else {
                    String inO = node.getFirstChild().getNodeValue();
                    FighterOrders fo = null;
                    for (int i = 0; i < FighterGroup.orderChoices.size(); ++i) {
                        fo = (FighterOrders)FighterGroup.orderChoices.get(i);
                        if (!fo.toString().equals(inO)) continue;
                        f.setFighterOrders(fo);
                    }
                }
            }
        }
        if (name.equals("MoveTo")) {
            if (p == null) {
                throw new Exception("Null player!");
            }
            if (f == null) {
                throw new Exception("Null fighter!");
            }
            x = XMLUtilities.getNumericAttribute(node, "x");
            y = XMLUtilities.getNumericAttribute(node, "y");
            hdg = (int)XMLUtilities.getNumericAttribute(node, "heading");
            f.setMoveToX(x);
            f.setMoveToY(y);
            f.setMoveToHeading(hdg);
        }
        if (name.equals("SecondaryMovement")) {
            if (p == null) {
                throw new Exception("Null player!");
            }
            if (f == null) {
                throw new Exception("Null fighter!");
            }
            String sec = XMLUtilities.getAttribute(node, "value");
            f.setMayUseSecondaryMove(false);
            if (sec.equals("true")) {
                f.setMayUseSecondaryMove(true);
            }
        }
        if (name.equals("OnBoard")) {
            if (p == null) {
                throw new Exception("Null player!");
            }
            if (f == null) {
                throw new Exception("Null fighter!");
            }
            String onBoard = XMLUtilities.getAttribute(node, "value");
            boolean isLanding = onBoard.equals("true") && !f.isOnBoard();
            boolean isLaunching = onBoard.equals("false") && f.isOnBoard();
            FighterBay theBay = (FighterBay)f.getFighterBay();
            if (theBay != null && (isLanding || isLaunching)) {
                theBay.setActive(true);
            }
            if (onBoard.equals("true")) {
                f.setOnBoard(true);
            } else {
                Ship carrier = f.getCarrierShip();
                if (f.isOnBoard()) {
                    f.setLaunching(true);
                    f.setPastX(carrier.getFighterLaunchXPosition());
                    f.setPastY(carrier.getFighterLaunchYPosition());
                }
                f.setOnBoard(false);
                f.setFighterBayId(0);
            }
        }
        if (name.equals("Target")) {
            if (p == null) {
                throw new Exception("Null player!");
            }
            if (f == null) {
                throw new Exception("Null fighter!");
            }
            tid = (int)XMLUtilities.getNumericAttribute(node, "id");
            f.setTargetId(tid);
        }
        if (name.equals("DamageControl")) {
            if (p == null || s == null) {
                throw new Exception();
            }
            if (XMLUtilities.attributeExists(node, "ids")) {
                String Value = XMLUtilities.getAttribute(node, "ids");
                ArrayList<Integer> d = new ArrayList<Integer>();
                StringTokenizer st = new StringTokenizer(Value, ",");
                while (st.hasMoreTokens()) {
                    String id = st.nextToken();
                    Integer iobj = new Integer(id);
                    d.add(iobj);
                }
                s.setDamageControlIds(d);
            }
        }
        if (name.equals("Missile")) {
            if (p == null) {
                throw new Exception("Player is null!");
            }
            fid = (int)XMLUtilities.getNumericAttribute(node, "id");
            lid = 0;
            hdg = 0;
            newId = 0;
            so = game.getObjectById(fid);
            boolean didCreate = false;
            if (so == null) {
                so = new Missile();
                so.setId(fid);
                didCreate = true;
            } else if (!(so instanceof Missile)) {
                newId = game.findUniqueId();
                so = new Missile();
                so.setId(newId);
                didCreate = true;
            }
            if (!(so instanceof Missile)) {
                throw new Exception("No Missile " + fid + " in this game!");
            }
            Missile m = (Missile)so;
            s = null;
            if (XMLUtilities.attributeExists(node, "move")) {
                int move = (int)XMLUtilities.getNumericAttribute(node, "move");
                m.setMove(move);
            }
            if (XMLUtilities.attributeExists(node, "turn")) {
                int turn = (int)XMLUtilities.getNumericAttribute(node, "turn");
                m.setTurn(turn);
            }
            if (XMLUtilities.attributeExists(node, "targetId")) {
                tid = (int)XMLUtilities.getNumericAttribute(node, "targetId");
                m.setTargetId(tid);
            }
            if (XMLUtilities.attributeExists(node, "needleTargetId")) {
                m.setNeedleTargetId((int)XMLUtilities.getNumericAttribute(node, "needleTargetId"));
            }
            if (didCreate) {
                sid = (int)XMLUtilities.getNumericAttribute(node, "shipId");
                lid = (int)XMLUtilities.getNumericAttribute(node, "launcherId");
                m.setLaunchingShipId(sid);
                m.setLauncherId(lid);
                Ship launching = (Ship)game.getObjectById(sid);
                MissileLauncher ml = null;
                if (launching != null) {
                    m.setRace(launching.getRace());
                    m.setIconFamily(launching.getIconFamily());
                    m.setPlayer(p);
                    m.setGameEngine(game);
                    ml = (MissileLauncher)launching.getWeaponById(m.getLauncherId());
                    m.setXPosition(launching.getXPosition());
                    m.setYPosition(launching.getYPosition());
                    m.setHeading(launching.getHeading());
                    m.setType(ml.getType());
                    launchable = launching.canLaunch(m);
                } else {
                    launchable = false;
                }
                if (launchable) {
                    ml.fireMissile(launching, m);
                    p.SpaceObjects.add(m);
                    game.addObject(m);
                } else {
                    System.err.println("Missile not launchable");
                }
            }
        }
        if (name.equals("LaunchSalvo")) {
            if (p == null) {
                throw new Exception("Player is null!");
            }
            lid = 0;
            hdg = 0;
            newId = game.findUniqueId();
            MissileSalvo ms = new MissileSalvo();
            ms.setId(newId);
            ms.setName("SM " + newId);
            sid = (int)XMLUtilities.getNumericAttribute(node, "shipId");
            lid = (int)XMLUtilities.getNumericAttribute(node, "launcherId");
            x = XMLUtilities.getNumericAttribute(node, "x");
            y = XMLUtilities.getNumericAttribute(node, "y");
            hdg = (int)XMLUtilities.getNumericAttribute(node, "heading");
            String type = XMLUtilities.getAttribute(node, "salvoType");
            ms.setLaunchingShipId(sid);
            ms.setLauncherId(lid);
            ms.setXPosition(x);
            ms.setYPosition(y);
            ms.setHeading(hdg);
            ms.setSalvoType(type);
            Ship launching = (Ship)game.getObjectById(sid);
            if (launching != null) {
                ms.setRace(launching.getRace());
                ms.setIconFamily(launching.getIconFamily());
                ms.setTeam(launching.getTeam());
                ms.setPlayer(p);
                ms.setGameEngine(game);
                launchable = launching.canLaunch(ms);
            } else {
                launchable = false;
            }
            if (launchable) {
                Weapon w2 = launching.getWeaponById(ms.getLauncherId());
                if (w2 instanceof SalvoMissileRack) {
                    ((SalvoMissileRack)w2).fireSalvo(launching, ms);
                }
                if (w2 instanceof SalvoMissileLauncher) {
                    ((SalvoMissileLauncher)w2).fireSalvo(launching, ms);
                }
                p.SpaceObjects.add(ms);
                game.addObject(ms);
            }
        }
        if (name.equals("LaunchBolt")) {
            if (p == null) {
                throw new Exception("Player is null!");
            }
            lid = 0;
            hdg = 0;
            int str = 0;
            newId = game.findUniqueId();
            PlasmaBolt pb = new PlasmaBolt();
            pb.setId(newId);
            sid = (int)XMLUtilities.getNumericAttribute(node, "shipId");
            lid = (int)XMLUtilities.getNumericAttribute(node, "launcherId");
            x = XMLUtilities.getNumericAttribute(node, "x");
            y = XMLUtilities.getNumericAttribute(node, "y");
            hdg = (int)XMLUtilities.getNumericAttribute(node, "heading");
            str = (int)XMLUtilities.getNumericAttribute(node, "strength");
            pb.setLaunchingShipId(sid);
            pb.setLauncherId(lid);
            pb.setXPosition(x);
            pb.setYPosition(y);
            pb.setHeading(hdg);
            pb.setStrength(str);
            pb.setName();
            Ship launching = (Ship)game.getObjectById(sid);
            if (launching != null) {
                pb.setRace(launching.getRace());
                pb.setIconFamily(launching.getIconFamily());
                pb.setTeam(launching.getTeam());
                pb.setPlayer(p);
                pb.setGameEngine(game);
                launchable = launching.canLaunch(pb);
                game.getOptions();
                if (GameOptions.getDebugMode()) {
                    System.out.println("ship Launch? " + launchable);
                }
            } else {
                launchable = false;
                game.getOptions();
                if (GameOptions.getDebugMode()) {
                    System.out.println("no ship Launch? " + launchable);
                }
            }
            if (launchable) {
                Weapon w3 = launching.getWeaponById(pb.getLauncherId());
                ((PlasmaBoltLauncher)w3).fireBolt(launching, pb);
                p.SpaceObjects.add(pb);
                game.addObject(pb);
            }
        }
        if (name.equals("LaunchNovaBolt")) {
            if (p == null) {
                throw new Exception("Player is null!");
            }
            lid = 0;
            hdg = 0;
            newId = game.findUniqueId();
            NovaCannonBolt ncb = new NovaCannonBolt();
            ncb.setId(newId);
            sid = (int)XMLUtilities.getNumericAttribute(node, "shipId");
            lid = (int)XMLUtilities.getNumericAttribute(node, "launcherId");
            x = XMLUtilities.getNumericAttribute(node, "x");
            y = XMLUtilities.getNumericAttribute(node, "y");
            hdg = (int)XMLUtilities.getNumericAttribute(node, "heading");
            ncb.setLaunchingShipId(sid);
            ncb.setLauncherId(lid);
            ncb.setXPosition(x);
            ncb.setYPosition(y);
            ncb.setHeading(hdg);
            ncb.setAge(0);
            ncb.setName();
            Ship launching = (Ship)game.getObjectById(sid);
            if (launching != null) {
                ncb.setRace(launching.getRace());
                ncb.setIconFamily(launching.getIconFamily());
                ncb.setTeam(launching.getTeam());
                ncb.setPlayer(p);
                ncb.setGameEngine(game);
                launchable = launching.canLaunch(ncb);
                game.getOptions();
                if (GameOptions.getDebugMode()) {
                    System.out.println("ship Launch? " + launchable);
                }
            } else {
                launchable = false;
                game.getOptions();
                if (GameOptions.getDebugMode()) {
                    System.out.println("no ship Launch? " + launchable);
                }
            }
            if (launchable) {
                Weapon w4 = launching.getWeaponById(ncb.getLauncherId());
                ((NovaCannon)w4).fireBolt(launching, ncb);
                p.SpaceObjects.add(ncb);
                game.addObject(ncb);
            }
        }
        if (name.equals("LaunchWaveBolt")) {
            if (p == null) {
                throw new Exception("Player is null!");
            }
            lid = 0;
            hdg = 0;
            newId = game.findUniqueId();
            WaveGunBolt wgb = new WaveGunBolt();
            wgb.setId(newId);
            sid = (int)XMLUtilities.getNumericAttribute(node, "shipId");
            lid = (int)XMLUtilities.getNumericAttribute(node, "launcherId");
            x = XMLUtilities.getNumericAttribute(node, "x");
            y = XMLUtilities.getNumericAttribute(node, "y");
            hdg = (int)XMLUtilities.getNumericAttribute(node, "heading");
            wgb.setLaunchingShipId(sid);
            wgb.setLauncherId(lid);
            wgb.setXPosition(x);
            wgb.setYPosition(y);
            wgb.setHeading(hdg);
            wgb.setName();
            Ship launching = (Ship)game.getObjectById(sid);
            if (launching != null) {
                wgb.setRace(launching.getRace());
                wgb.setIconFamily(launching.getIconFamily());
                wgb.setTeam(launching.getTeam());
                wgb.setPlayer(p);
                wgb.setGameEngine(game);
                launchable = launching.canLaunch(wgb);
                game.getOptions();
                if (GameOptions.getDebugMode()) {
                    System.out.println("ship Launch? " + launchable);
                }
            } else {
                launchable = false;
                game.getOptions();
                if (GameOptions.getDebugMode()) {
                    System.out.println("no ship Launch? " + launchable);
                }
            }
            if (launchable) {
                Weapon w5 = launching.getWeaponById(wgb.getLauncherId());
                ((WaveGun)w5).fireBolt(launching, wgb);
                p.SpaceObjects.add(wgb);
                game.addObject(wgb);
            }
        }
        if (name.equals("LaunchAMT")) {
            if (p == null) {
                throw new Exception("Player is null!");
            }
            lid = 0;
            hdg = 0;
            newId = game.findUniqueId();
            AntiMatterTorpedo amt = new AntiMatterTorpedo();
            amt.setId(newId);
            sid = (int)XMLUtilities.getNumericAttribute(node, "shipId");
            lid = (int)XMLUtilities.getNumericAttribute(node, "launcherId");
            x = XMLUtilities.getNumericAttribute(node, "x");
            y = XMLUtilities.getNumericAttribute(node, "y");
            hdg = (int)XMLUtilities.getNumericAttribute(node, "heading");
            amt.setLaunchingShipId(sid);
            amt.setLauncherId(lid);
            amt.setXPosition(x);
            amt.setYPosition(y);
            amt.setHeading(hdg);
            amt.setName();
            Ship launching = (Ship)game.getObjectById(sid);
            if (launching != null) {
                amt.setRace(launching.getRace());
                amt.setIconFamily(launching.getIconFamily());
                amt.setTeam(launching.getTeam());
                amt.setPlayer(p);
                amt.setGameEngine(game);
                launchable = launching.canLaunch(amt);
                game.getOptions();
                if (GameOptions.getDebugMode()) {
                    System.out.println("ship Launch? " + launchable);
                }
            } else {
                launchable = false;
                game.getOptions();
                if (GameOptions.getDebugMode()) {
                    System.out.println("no ship Launch? " + launchable);
                }
            }
            if (launchable) {
                Weapon w6 = launching.getWeaponById(amt.getLauncherId());
                ((AntiMatterTorpedoLauncher)w6).fireAMT(launching);
                p.SpaceObjects.add(amt);
                game.addObject(amt);
            }
        }
        VapourShroud vp = null;
        ShipSystem ss = null;
        if (name.equals("VapourShroud")) {
            int vpId = 0;
            if (p == null || s == null) {
                throw new Exception("Null player and null ship!");
            }
            if (XMLUtilities.attributeExists(node, "id")) {
                vpId = (int)XMLUtilities.getNumericAttribute(node, "id");
                ss = s.getShipSystemById(vpId);
                if (ss == null || !(ss instanceof VapourShroud)) {
                    throw new Exception("No vapour shroud! [vpId == 0]");
                }
                vp = (VapourShroud)ss;
            }
            if (XMLUtilities.attributeExists(node, "active")) {
                if (vpId == 0) {
                    throw new Exception("No vapour shroud! [vpId == 0]");
                }
                String value = XMLUtilities.getAttribute(node, "active");
                if (value.equals("true")) {
                    vp.setActive(true);
                    s.shutdownAllWeapons();
                } else {
                    vp.setActive(false);
                }
            }
        }
        if (name.equals("FireControl")) {
            int fcId = 0;
            tarId = 0;
            FireControl fc = null;
            ArrayList ids = null;
            if (p == null || s == null) {
                throw new Exception("Null player and null ship!");
            }
            if (XMLUtilities.attributeExists(node, "id")) {
                fcId = (int)XMLUtilities.getNumericAttribute(node, "id");
                ss = s.getShipSystemById(fcId);
                if (ss == null || !(ss instanceof FireControl)) {
                    throw new Exception("No fire control! [fcId == 0]");
                }
                fc = (FireControl)ss;
                fc.unslaveAllWeapons();
            }
            if (XMLUtilities.attributeExists(node, "targetId")) {
                if (fcId == 0) {
                    throw new Exception("No fire control! [fcId == 0]");
                }
                tarId = (int)XMLUtilities.getNumericAttribute(node, "targetId");
                ss = s.getShipSystemById(fcId);
                if (ss == null || !(ss instanceof FireControl)) {
                    throw new Exception("No fire control! [ss == null]");
                }
                fc = (FireControl)ss;
                fc.setTargetId(tarId);
            }
            if (XMLUtilities.attributeExists(node, "slavedWeapons")) {
                if (tarId == 0) {
                    fc.unslaveAllWeapons();
                } else {
                    fc.unslaveAllWeapons();
                    fc.setValue("slavedWeapons", XMLUtilities.getAttribute(node, "slavedWeapons"));
                    ids = fc.getSlavedWeaponsIds();
                    if (!ids.isEmpty()) {
                        for (int j = 0; j < ids.size(); ++j) {
                            Integer kInt = (Integer)ids.get(j);
                            int k = kInt;
                            Weapon w7 = s.getWeaponById(k);
                            if (w7 == null) continue;
                            fc.slaveWeapon(w7);
                        }
                    }
                }
            }
        }
        if (name.equals("AreaDefenseFireControl")) {
            int adfcId = 0;
            int defId = 0;
            AreaDefenseFireControl adfc = null;
            if (p == null || s == null) {
                throw new Exception("Null player and null ship!");
            }
            if (XMLUtilities.attributeExists(node, "id")) {
                adfcId = (int)XMLUtilities.getNumericAttribute(node, "id");
                ss = s.getShipSystemById(adfcId);
                if (ss == null || !(ss instanceof AreaDefenseFireControl)) {
                    throw new Exception("No AD fire control! [fcId == 0]");
                }
                adfc = (AreaDefenseFireControl)ss;
            }
            if (XMLUtilities.attributeExists(node, "defendedTargetId")) {
                if (adfcId == 0) {
                    throw new Exception("No AD fire control! [adfcId == 0]");
                }
                defId = (int)XMLUtilities.getNumericAttribute(node, "defendedTargetId");
                ss = s.getShipSystemById(adfcId);
                if (ss == null || !(ss instanceof AreaDefenseFireControl)) {
                    throw new Exception("No AD fire control! [ss == null]");
                }
                adfc = (AreaDefenseFireControl)ss;
                adfc.setDefendedTargetId(defId);
            }
        }
        if (name.equals("PointDefense")) {
            int pdId = 0;
            tarId = 0;
            if (p == null || s == null) {
                throw new Exception("Null player and/or null ship!");
            }
            if (XMLUtilities.attributeExists(node, "id")) {
                pdId = (int)XMLUtilities.getNumericAttribute(node, "id");
            }
            if (XMLUtilities.attributeExists(node, "targetId")) {
                if (pdId == 0) {
                    throw new Exception("No point defense!");
                }
                tarId = (int)XMLUtilities.getNumericAttribute(node, "targetId");
                w = s.getWeaponById(pdId);
                if (w == null || !(w instanceof PointDefense)) {
                    throw new Exception("No point defense!");
                }
                pd = (PointDefense)w;
                pd.setTargetId(tarId);
            }
        }
        if (name.equals("Scattergun")) {
            int pdId = 0;
            tarId = 0;
            if (p == null || s == null) {
                throw new Exception("Null player and null ship!");
            }
            if (XMLUtilities.attributeExists(node, "id")) {
                pdId = (int)XMLUtilities.getNumericAttribute(node, "id");
            }
            if (XMLUtilities.attributeExists(node, "targetId")) {
                if (pdId == 0) {
                    throw new Exception("No scattergun!");
                }
                tarId = (int)XMLUtilities.getNumericAttribute(node, "targetId");
                w = s.getWeaponById(pdId);
                if (w == null || !(w instanceof Scattergun)) {
                    throw new Exception("No scattergun!");
                }
                pd = (Scattergun)w;
                pd.setTargetId(tarId);
            }
        }
        if (name.equals("BeamBattery")) {
            int pdId = 0;
            tarId = 0;
            if (p == null || s == null) {
                throw new Exception("Null player and/or null ship!");
            }
            if (XMLUtilities.attributeExists(node, "id")) {
                pdId = (int)XMLUtilities.getNumericAttribute(node, "id");
            }
            if (XMLUtilities.attributeExists(node, "targetId")) {
                if (pdId == 0) {
                    throw new Exception("No point defense!");
                }
                tarId = (int)XMLUtilities.getNumericAttribute(node, "targetId");
                w = s.getWeaponById(pdId);
                if (w == null || !(w instanceof BeamBattery)) {
                    throw new Exception("No point defense!");
                }
                BeamBattery bb = (BeamBattery)w;
                bb.setTargetId(tarId);
            }
        }
        if (name.equals("KineticGun")) {
            int pdId = 0;
            tarId = 0;
            if (p == null || s == null) {
                throw new Exception("Null player and/or null ship!");
            }
            if (XMLUtilities.attributeExists(node, "id")) {
                pdId = (int)XMLUtilities.getNumericAttribute(node, "id");
            }
            if (XMLUtilities.attributeExists(node, "targetId")) {
                if (pdId == 0) {
                    throw new Exception("No point defense!");
                }
                tarId = (int)XMLUtilities.getNumericAttribute(node, "targetId");
                w = s.getWeaponById(pdId);
                if (w == null || !(w instanceof KineticGun)) {
                    throw new Exception("No point defense!");
                }
                KineticGun kg = (KineticGun)w;
                kg.setTargetId(tarId);
            }
        }
        if (name.equals("Pulser")) {
            int pdId = 0;
            tarId = 0;
            if (p == null || s == null) {
                throw new Exception("Null player and/or null ship!");
            }
            if (XMLUtilities.attributeExists(node, "id")) {
                pdId = (int)XMLUtilities.getNumericAttribute(node, "id");
            }
            if (XMLUtilities.attributeExists(node, "targetId")) {
                if (pdId == 0) {
                    throw new Exception("No point defense!");
                }
                tarId = (int)XMLUtilities.getNumericAttribute(node, "targetId");
                w = s.getWeaponById(pdId);
                if (w == null || !(w instanceof Pulser)) {
                    throw new Exception("No point defense!");
                }
                Pulser pr = (Pulser)w;
                pr.setTargetId(tarId);
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int length = children.getLength();
            for (int j = 0; j < length; ++j) {
                this.parseOrders(game, p, s, f, children.item(j));
            }
        }
    }
}

