/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std.importer;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterBay;
import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.LogRecord;
import ftjava.std.MissileSalvo;
import ftjava.std.Player;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.importer.ImportMessages;
import ftjava.std.importer.ImportShip;
import ftjava.std.importer.ImportSpaceObject;
import ftjava.std.importer.ImportVictoryCondition;
import ftjava.util.GameOptions;
import ftjava.util.XMLUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportGameEngine {
    private GameEngine engine;
    private File file = null;

    public GameEngine readGameEngine(File in) throws Exception {
        this.file = in;
        this.engine = new GameEngine();
        this.engine.setCurrentGame(true);
        try {
            Document d = XMLUtilities.getDOMDocument(in);
            this.parseGameEngine(d.getDocumentElement());
        }
        catch (Exception e) {
            this.engine.setCurrentGame(false);
            throw e;
        }
        return this.engine;
    }

    public GameEngine readGameEngine(InputStream in) throws Exception {
        this.engine = new GameEngine();
        this.engine.setCurrentGame(true);
        try {
            Document d = XMLUtilities.getDOMDocument(in);
            this.parseGameEngine(d.getDocumentElement());
        }
        catch (Exception e) {
            this.engine.setCurrentGame(false);
            throw e;
        }
        return this.engine;
    }

    public void parseGameEngine(Node node) throws Exception {
        NodeList children;
        String name = node.getNodeName();
        if (name.equals("GameEngine")) {
            int value = 0;
            String scenario = "";
            int turnNumber = 0;
            String ph = "";
            value = (int)XMLUtilities.getNumericAttribute(node, "id");
            this.engine.setId(value);
            scenario = XMLUtilities.getAttribute(node, "name");
            this.engine.setName(scenario);
            turnNumber = (int)XMLUtilities.getNumericAttribute(node, "turn");
            this.engine.setGameTurn(turnNumber);
            ph = XMLUtilities.getAttribute(node, "combat");
            if (ph == null || ph.equals("false")) {
                this.engine.setCombatPhase(false);
            } else {
                this.engine.setCombatPhase(true);
            }
        }
        if (name.equals("Briefing")) {
            this.handleScenarioBriefing(node);
        }
        if (name.equals("GameOptions")) {
            this.handleGameOptions(node);
        }
        if (name.equals("Report")) {
            this.handleTurnReport(node);
        }
        if (name.equals("Player")) {
            this.handlePlayer(node);
            return;
        }
        if (name.equals("VictoryCondition")) {
            NodeList vcnodes = node.getChildNodes();
            for (int vv = 0; vv < vcnodes.getLength(); ++vv) {
                if (vcnodes.item(vv).getNodeType() != 1) continue;
                this.engine.setVictoryCondition(ImportVictoryCondition.parseVictoryCondition(vcnodes.item(vv)));
                return;
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int length = children.getLength();
            for (int j = 0; j < length; ++j) {
                this.parseGameEngine(children.item(j));
            }
        }
        this.engine.cleanUp(true);
    }

    private void handleTurnReport(Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return;
        }
        if (children != null) {
            int l = children.getLength();
            for (int i = 0; i < l; ++i) {
                Node child = children.item(i);
                String name = child.getNodeName();
                if (!name.equals("Record")) continue;
                LogRecord r = new LogRecord();
                String record = child.getFirstChild().getNodeValue();
                record = record.trim();
                NamedNodeMap attributes = child.getAttributes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node a = attributes.item(j);
                    r.setValue(a.getNodeName(), a.getNodeValue());
                }
                r.setRecord(record);
                this.engine.addTurnReport(r);
            }
        }
    }

    private void handleScenarioBriefing(Node node) {
        Node child = node.getFirstChild();
        if (child == null) {
            return;
        }
        String briefing = XMLUtilities.unwrapSpecialCharsXML(child.getNodeValue());
        this.engine.setScenarioBriefing(briefing);
    }

    private void handleObjectives(Player p, Node node) {
        Node child = node.getFirstChild();
        if (child == null) {
            return;
        }
        String objectives = XMLUtilities.unwrapSpecialCharsXML(child.getNodeValue());
        p.setObjectives(objectives);
    }

    private void handlePlayer(Node node) throws Exception {
        NodeList children;
        Player player = new Player();
        player.setGameEngine(this.engine);
        player.setId((int)XMLUtilities.getNumericAttribute(node, "id"));
        player.setName(XMLUtilities.getAttribute(node, "name"));
        player.setEmail(XMLUtilities.getAttribute(node, "email"));
        player.setTeam(XMLUtilities.getAttribute(node, "team"));
        player.setKey((int)XMLUtilities.getNumericAttribute(node, "key"));
        player.setGameMaster(false);
        String isGameMaster = XMLUtilities.getAttribute(node, "gameMaster");
        if (isGameMaster != null && isGameMaster.equals("true")) {
            player.setGameMaster(true);
        }
        if ((children = node.getChildNodes()) != null) {
            int l = children.getLength();
            for (int i = 0; i < l; ++i) {
                Node child = children.item(i);
                String name = child.getNodeName();
                Ship s = null;
                SpaceObject so = null;
                if (name.equals("Objectives")) {
                    this.handleObjectives(player, child);
                }
                if (name.equals("Messages")) {
                    ArrayList t = ImportMessages.parseMessages(child);
                    player.setIncomingMessageLog(t);
                }
                if (name.equals("Ship") && (s = ImportShip.getShip(child)) != null) {
                    s.setPlayer(player);
                    s.setGameEngine(this.engine);
                    player.Ships.add(s);
                    this.engine.addShip(s);
                }
                if (name.equals("Missile") && (so = ImportSpaceObject.getMissile(child)) != null) {
                    so.setPlayer(player);
                    so.setGameEngine(this.engine);
                    player.SpaceObjects.add(so);
                    this.engine.addObject(so);
                }
                if (name.equals("MissileSalvo") && (so = ImportSpaceObject.getMissileSalvo(child)) != null) {
                    so.setPlayer(player);
                    ((MissileSalvo)so).setTeam(player.getTeam());
                    so.setGameEngine(this.engine);
                    player.SpaceObjects.add(so);
                    this.engine.addObject(so);
                }
                if (name.equals("PlasmaBolt") && (so = ImportSpaceObject.getPlasmaBolt(child)) != null) {
                    so.setPlayer(player);
                    so.setGameEngine(this.engine);
                    player.SpaceObjects.add(so);
                    this.engine.addObject(so);
                }
                if (name.equals("NovaCannonBolt") && (so = ImportSpaceObject.getNovaCannonBolt(child)) != null) {
                    so.setPlayer(player);
                    so.setGameEngine(this.engine);
                    player.SpaceObjects.add(so);
                    this.engine.addObject(so);
                }
                if (name.equals("WaveGunBolt") && (so = ImportSpaceObject.getWaveGunBolt(child)) != null) {
                    so.setPlayer(player);
                    so.setGameEngine(this.engine);
                    player.SpaceObjects.add(so);
                    this.engine.addObject(so);
                }
                if (name.equals("AntiMatterTorpedo") && (so = ImportSpaceObject.getAntiMatterTorpedo(child)) != null) {
                    so.setPlayer(player);
                    ((AntiMatterTorpedo)so).setTeam(player.getTeam());
                    so.setGameEngine(this.engine);
                    player.SpaceObjects.add(so);
                    this.engine.addObject(so);
                }
                if (name.equals("FighterGroup") && (so = ImportSpaceObject.getFighterGroup(child)) != null) {
                    FighterBay fb;
                    so.setPlayer(player);
                    FighterGroup fg = (FighterGroup)so;
                    fg.setTeam(player.getTeam());
                    fg.setGameEngine(this.engine);
                    player.SpaceObjects.add(so);
                    this.engine.addObject(so);
                    Ship sCarrier = fg.getCarrierShip();
                    if (sCarrier != null && sCarrier.isDestroyed()) {
                        fg.setCarrierShipId(0);
                    }
                    if ((fb = (FighterBay)fg.getFighterBay()) != null && fb.getLandedFighterGroup() == null) {
                        fb.setLandedFighterGroup(fg);
                    }
                }
                if (name.equals("HeavenlyBody") && (so = ImportSpaceObject.getHeavenlyBody(child)) != null) {
                    so.setPlayer(player);
                    so.setGameEngine(this.engine);
                    player.SpaceObjects.add(so);
                    this.engine.addObject(so);
                }
                if (!name.equals("ShipFile")) continue;
                String parent = "./";
                if (this.file != null) {
                    parent = this.file.getParent() + "/";
                }
                System.out.println("Reading: " + parent + child.getFirstChild().getNodeValue());
                s = ImportShip.readShip(new FileInputStream(new File(parent + child.getFirstChild().getNodeValue())));
                String n = XMLUtilities.getAttribute(child, "name");
                if (n == null) continue;
                s.setName(n);
            }
        }
        this.engine.addPlayer(player);
    }

    private void handleGameOptions(Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return;
        }
        int l = children.getLength();
        for (int i = 0; i < l; ++i) {
            double v;
            int k;
            String r;
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("Variant") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setVariant(r);
            }
            if (name.equals("Deadline") && XMLUtilities.attributeExists(child, "value")) {
                k = (int)XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setDeadline(k);
            }
            if (name.equals("AftArcFire") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setAftArcFire(r.equals("true"));
            }
            if (name.equals("CinematicMovement") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setCinematicMovement(r.equals("true"));
            }
            if (name.equals("CoreSystems") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setCoreSystems(r.equals("true"));
            }
            if (name.equals("PenetratingDamage") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setPenetratingDamage(r.equals("true"));
            }
            if (name.equals("SensorRules") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                if (r.equals("true") || r.equals("false")) {
                    this.engine.getOptions().setSensorRules(0);
                } else {
                    k = (int)XMLUtilities.getNumericAttribute(child, "value");
                    this.engine.getOptions().setSensorRules(k);
                }
            }
            if (name.equals("SensorLevel") && XMLUtilities.attributeExists(child, "value")) {
                k = (int)XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setSensorLevel(k);
            }
            if (name.equals("SensorRangeBand") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setSensorRangeBand(v);
            }
            if (name.equals("SensorBlipBands") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setSensorBlipBands(v);
            }
            if (name.equals("ShipRoll") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setShipRoll(r.equals("true"));
            }
            if (name.equals("SimultaneousFire") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setSimultaneousFire(r.equals("true"));
            }
            if (name.equals("TargetResolution") && XMLUtilities.attributeExists(child, "value")) {
                k = (int)XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setTargetResolution(k);
            }
            if (name.equals("ThresholdDamagedSystems") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setThresholdDamagedSystems(r.equals("true"));
            }
            if (name.equals("PDSFireAtShips") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setPDSFireAtShips(r.equals("true"));
            }
            if (name.equals("FighterMorale") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setFighterMorale(r.equals("true"));
            }
            if (name.equals("PlayTest") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setPlayTest(r.equals("true"));
            }
            if (name.equals("AreaDefenseActivationRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setAreaDefenseActivationRange(v);
            }
            if (name.equals("BeamRangeBand") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setBeamRangeBand(v);
            }
            if (name.equals("KineticGunRangeBand") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setKineticGunRangeBand(v);
            }
            if (name.equals("PointDefenseRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setPointDefenseRange(v);
            }
            if (name.equals("PulseTorpedoRangeBand") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setPulseTorpedoRangeBand(v);
            }
            if (name.equals("MultipleKineticPenetratorPackRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setMultipleKineticPenetratorPackRange(v);
            }
            if (name.equals("NeedleBeamRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setNeedleBeamRange(v);
            }
            if (name.equals("SalvoMissileRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setSalvoMissileRange(v);
            }
            if (name.equals("SalvoMissileExtendedRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setSalvoMissileExtendedRange(v);
            }
            if (name.equals("SalvoMissileLockOn") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setSalvoMissileLockOn(v);
            }
            if (name.equals("MissileLockOnRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setMissileLockOnRange(v);
            }
            if (name.equals("SubmunitionPackRangeBand") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setSubmunitionPackRangeBand(v);
            }
            if (name.equals("ScattergunRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setScattergunRange(v);
            }
            if (name.equals("PulserRangeBand") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setPulserRangeBand(v);
            }
            if (name.equals("PlasmaBoltRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setPlasmaBoltRange(v);
            }
            if (name.equals("PlasmaBoltBlastRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setPlasmaBoltBlastRange(v);
            }
            if (name.equals("GraserRangeBand") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setGraserRangeBand(v);
            }
            if (name.equals("AntiMatterTorpedoRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setAntiMatterTorpedoRange(v);
            }
            if (name.equals("AntiMatterTorpedoLockOnRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setAntiMatterTorpedoLockOnRange(v);
            }
            if (name.equals("AntiMatterTorpedoBlastRange") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setAntiMatterTorpedoBlastRange(v);
            }
            if (name.equals("DebugMode") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions();
                GameOptions.setDebugMode(r.equals("true"));
            }
            if (name.equals("TestingMode") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions();
                GameOptions.setTestingMode(r.equals("true"));
            }
            if (name.equals("ActiveExtent") && XMLUtilities.attributeExists(child, "value")) {
                r = XMLUtilities.getAttribute(child, "value");
                this.engine.getOptions().setActiveExtent(r.equals("true"));
            }
            if (name.equals("XMinExtent") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setXMin(v);
            }
            if (name.equals("XMaxExtent") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setXMax(v);
            }
            if (name.equals("YMinExtent") && XMLUtilities.attributeExists(child, "value")) {
                v = XMLUtilities.getNumericAttribute(child, "value");
                this.engine.getOptions().setYMin(v);
            }
            if (!name.equals("YMaxExtent") || !XMLUtilities.attributeExists(child, "value")) continue;
            v = XMLUtilities.getNumericAttribute(child, "value");
            this.engine.getOptions().setYMax(v);
        }
    }
}

