/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.GameEngine;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;

public class SubmunitionPack
extends Weapon {
    public SubmunitionPack() {
        this(Weapon.FORE_ARC);
    }

    public SubmunitionPack(String arcString) {
        this(Weapon.parseArcString(arcString));
    }

    public SubmunitionPack(int a) {
        if (!this.getOptions().getAftArcFire() && a == Weapon.AFT_ARC) {
            a = Weapon.FORE_ARC;
        }
        this.setArcs(a);
        this.setSystemName("Submunition Pack " + this.getArcsString());
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setMaximumRange(3.0 * this.getOptions().getSubmunitionPackRangeBand());
    }

    public void setValue(String Name, String Value) {
        if (Name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(Value));
            this.setSystemName("Submunition Pack " + this.getArcsString());
        } else {
            super.setValue(Name, Value);
        }
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
        String record;
        int die;
        int i;
        int[] damage = new int[2];
        DecimalFormat df = new DecimalFormat("0.0");
        int dice = 0;
        int rerolls = 0;
        damage[0] = 0;
        damage[1] = 0;
        double rangeBand = this.getOptions().getSubmunitionPackRangeBand();
        if (!this.getSystemStatus().equals("Operational")) {
            return;
        }
        if (!(target instanceof Ship)) {
            return;
        }
        if (!this.fireAtTargetArc(firer.arcTo(target))) {
            return;
        }
        dice = 3;
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        for (i = 1; i < 3; ++i) {
            if (!(range > (double)i * rangeBand)) continue;
            --dice;
        }
        if (firer.rangeTo(target) > this.getMaximumRange()) {
            return;
        }
        this.setFired();
        this.setExpended();
        String targetName = target.getName();
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range) + " ";
        if (range > 3.0 * rangeBand) {
            dice = 0;
        }
        boolean hit = false;
        block11: for (i = 0; i < dice; ++i) {
            die = Dice.rollD6(firer.getCrewQuality());
            playTestResults = playTestResults + "(" + die + ") ";
            switch (die) {
                case 1: 
                case 2: 
                case 3: {
                    continue block11;
                }
                case 4: 
                case 5: {
                    damage[0] = damage[0] + 1;
                    hit = true;
                    continue block11;
                }
                case 6: {
                    damage[0] = damage[0] + 2;
                    hit = true;
                    ++rerolls;
                    continue block11;
                }
            }
        }
        if (this.getOptions().getPenetratingDamage()) {
            block12: for (i = 0; i < rerolls; ++i) {
                die = Dice.rollD6(firer.getCrewQuality());
                playTestResults = playTestResults + "(" + die + "*) ";
                switch (die) {
                    case 1: 
                    case 2: 
                    case 3: {
                        continue block12;
                    }
                    case 4: 
                    case 5: {
                        damage[1] = damage[1] + 1;
                        continue block12;
                    }
                    case 6: {
                        damage[1] = damage[1] + 2;
                        ++rerolls;
                        continue block12;
                    }
                }
            }
        }
        if (!hit) {
            String record2;
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed the " + targetName + "." + playTestResults);
                record2 = firer.getName() + " missed with a submunition pack." + playTestResults;
            } else {
                this.setNotes("Missed the " + targetName + ".");
                record2 = firer.getName() + " missed with a submunition pack.";
            }
            target.addLog("Attack", "Medium", record2);
            return;
        }
        int totalDamage = damage[0] + damage[1];
        if (this.getOptions().getPlayTest()) {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.number(damage[0]) + " armor and " + StringUtils.number(damage[1]) + " hull points." + playTestResults);
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a submunition pack." + playTestResults;
        } else {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.points(totalDamage) + ".");
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a submunition pack.";
        }
        target.addLog("Attack", "High", record);
        if (totalDamage >= 6) {
            GameEngine ge = firer.getGameEngine();
            record = firer.getName() + " hit " + target.getName() + " for " + StringUtils.points(totalDamage) + " with a submunition pack.";
            ge.addTurnReport("Attack", "High", record);
        }
        Ship s = (Ship)target;
        s.takeDamage(damage);
    }

    public int computeMass() {
        return 1;
    }

    public int computePointCost() {
        return 3;
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String t = XMLUtilities.getIndent();
        String sep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t);
        sb.append(t);
        sb.append("<SubmunitionPack ");
        if (level > 0) {
            sb.append(" id=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" arcs=\"");
        sb.append(this.getArcsString());
        sb.append("\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"");
            sb.append(this.getSystemStatus());
            sb.append("\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        sb.append(sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("SubmunitionPack", new SubmunitionPack());
    }
}

