/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.Ship;
import ftjava.util.Dice;
import ftjava.util.GameOptions;

public abstract class ShipSystem {
    public static final String OPERATIONAL = "Operational";
    public static final String DAMAGED = "Damaged";
    public static final String DESTROYED = "Destroyed";
    public static final String EXPENDED = "Expended";
    private String systemName;
    private String systemStatus;
    private static int idCounter = 0;
    private int id;
    private String notes;
    private Ship parent;
    private int xSSD;
    private int ySSD;
    public static final int UNDEFINED = -1;

    public ShipSystem() {
        this.setSystemName("Unknown system");
        this.setSystemStatus(OPERATIONAL);
        this.setNotes("");
        this.xSSD = -1;
        this.ySSD = -1;
        this.parent = null;
    }

    public void setSystemName(String s) {
        this.systemName = s;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemStatus(String s) {
        this.systemStatus = s;
    }

    public String getSystemStatus() {
        return this.systemStatus;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int i) {
        this.id = i;
    }

    public static void resetIdCounter() {
        idCounter = 0;
    }

    public static int getIdCounter() {
        return idCounter;
    }

    public static void incrementIdCounter() {
        ++idCounter;
    }

    public void setNotes(String s) {
        this.notes = s;
    }

    public String getNotes() {
        return this.notes;
    }

    public void resetNotes() {
        this.notes = "";
    }

    public boolean anyNotes() {
        return this.notes.length() > 0;
    }

    public void appendNotes(String s) {
        if (this.notes.length() == 0) {
            this.setNotes(s);
        } else {
            this.notes = this.notes + ", " + s;
        }
    }

    public void setXSSD(int x) {
        this.xSSD = x;
    }

    public void setYSSD(int y) {
        this.ySSD = y;
    }

    public int getXSSD() {
        return this.xSSD;
    }

    public int getYSSD() {
        return this.ySSD;
    }

    public boolean isSSDDefined() {
        return this.xSSD != -1 && this.ySSD != -1;
    }

    public Ship getShip() {
        return this.parent;
    }

    public void setShip(Ship s) {
        this.parent = s;
    }

    public GameOptions getOptions() {
        if (this.parent != null && this.parent.getGameEngine() != null) {
            return this.parent.getGameEngine().getOptions();
        }
        return GameOptions.current();
    }

    public void setValue(String Name, String Value) {
        if (Name.equals("status")) {
            this.setSystemStatus(Value);
        }
        if (Name.equals("id")) {
            this.setId(Integer.valueOf(Value));
        }
        if (Name.equals("notes")) {
            this.setNotes(Value);
        }
        if (Name.equals("xSSD")) {
            this.setXSSD(Integer.valueOf(Value));
        }
        if (Name.equals("ySSD")) {
            this.setYSSD(Integer.valueOf(Value));
        }
    }

    public void takeThresholdCheck(int level) {
        if (this.getSystemStatus().equals(DESTROYED) || this.getSystemStatus().equals(EXPENDED)) {
            return;
        }
        int die = Dice.rollD6();
        String playTestResults = "TC:(" + die + ") ";
        if (this.getOptions().getPlayTest()) {
            this.appendNotes(playTestResults);
        }
        if (die < level) {
            return;
        }
        if (this.getOptions().getThresholdDamagedSystems()) {
            if (this.getSystemStatus().equals(DAMAGED)) {
                this.setDestroyed();
            } else {
                this.setDamaged();
            }
        } else {
            this.setDamaged();
        }
    }

    public void setDestroyed() {
        this.systemStatus = DESTROYED;
    }

    public void setDamaged() {
        this.systemStatus = DAMAGED;
    }

    public void setExpended() {
        this.systemStatus = EXPENDED;
    }

    public void setRepaired() {
        this.systemStatus = OPERATIONAL;
    }

    public void setOperational() {
        this.systemStatus = OPERATIONAL;
    }

    public String attemptRepair(int teams) {
        return this.attemptRepair("First Rate", teams);
    }

    public String attemptRepair(String crewQuality, int teams) {
        String playTestResults = "";
        String result = null;
        if (this.getSystemStatus().equals(DESTROYED) || this.getSystemStatus().equals(EXPENDED) || this.getSystemStatus().equals(OPERATIONAL)) {
            return result;
        }
        int die = Dice.rollD6(crewQuality);
        playTestResults = playTestResults + "DC:(" + die + ") ";
        if (this.getOptions().getPlayTest()) {
            this.appendNotes(playTestResults);
        }
        if (die == 6 && teams > 0) {
            this.setRepaired();
        } else if (die >= 5 && teams > 1) {
            this.setRepaired();
        } else if (die >= 4 && teams > 2) {
            this.setRepaired();
        }
        return result;
    }

    public boolean isOperational() {
        return this.getSystemStatus().equals(OPERATIONAL);
    }

    public boolean isDamaged() {
        return this.getSystemStatus().equals(DAMAGED);
    }

    public boolean isDestroyed() {
        return this.getSystemStatus().equals(DESTROYED);
    }

    public boolean isExpended() {
        return this.getSystemStatus().equals(EXPENDED);
    }

    public int computeMass() {
        return 0;
    }

    public int computePointCost() {
        return 0;
    }

    public int computeMass(int m) {
        return 0;
    }

    public int computePointCost(int m) {
        return 0;
    }

    protected static ShipSystem deepSearchByName(String name) {
        Class<?> systemClass = null;
        int classNameIndex = name.lastIndexOf(46);
        String systemClassName = classNameIndex >= 0 ? name.substring(classNameIndex + 1) : name;
        try {
            systemClass = Class.forName("ftjava.std." + systemClassName);
        }
        catch (ClassNotFoundException cnf) {
            // empty catch block
        }
        try {
            systemClass = Class.forName("ftjava.std.variant." + systemClassName);
        }
        catch (ClassNotFoundException cnf) {
            // empty catch block
        }
        if (systemClass == null) {
            try {
                systemClass = Class.forName(systemClassName);
            }
            catch (ClassNotFoundException cnf) {
                // empty catch block
            }
        }
        if (systemClass == null) {
            try {
                systemClass = Class.forName(name);
            }
            catch (ClassNotFoundException cnf) {
                return null;
            }
        }
        if (systemClass != null) {
            try {
                return (ShipSystem)systemClass.newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public abstract String toXML();

    public abstract String toXML(int var1);
}

