/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.AntiMatterTorpedoLauncher;
import ftjava.std.AreaDefenseFireControl;
import ftjava.std.Armor;
import ftjava.std.BeamBattery;
import ftjava.std.CoreCommandBridge;
import ftjava.std.CoreLifeSupport;
import ftjava.std.CorePowerCore;
import ftjava.std.Defense;
import ftjava.std.FTLDrive;
import ftjava.std.FighterBay;
import ftjava.std.FighterGroup;
import ftjava.std.FireControl;
import ftjava.std.GameEngine;
import ftjava.std.Graser;
import ftjava.std.Hull;
import ftjava.std.KineticGun;
import ftjava.std.LogRecord;
import ftjava.std.MainDrive;
import ftjava.std.Missile;
import ftjava.std.MissileLauncher;
import ftjava.std.MissileSalvo;
import ftjava.std.NovaCannon;
import ftjava.std.NovaCannonBolt;
import ftjava.std.PlasmaBolt;
import ftjava.std.PlasmaBoltLauncher;
import ftjava.std.PointDefense;
import ftjava.std.PulseTorpedo;
import ftjava.std.Pulser;
import ftjava.std.SalvoMissileLauncher;
import ftjava.std.SalvoMissileMagazine;
import ftjava.std.SalvoMissileRack;
import ftjava.std.Scattergun;
import ftjava.std.Screen;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.StealthGenerator;
import ftjava.std.SubmunitionPack;
import ftjava.std.VapourShroud;
import ftjava.std.WaveGun;
import ftjava.std.WaveGunBolt;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.MathUtil;
import ftjava.util.MovementSteps;
import ftjava.util.ParserUtilities;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Ship
extends SpaceObject {
    public static final String JUMPED = "Out of System";
    public static final String DESTROYED = "Destroyed";
    public static final String STRIKE = "Striking its Colors";
    public static int idCounter = 1;
    private String race;
    private String shipClass;
    private String className;
    private String classAbbrev;
    private int pointValue;
    private String streamlining;
    private Armor shipArmor;
    private Hull shipHull;
    private ArrayList electronicsSystems;
    private ArrayList defenseSystems;
    private ArrayList shipHolds;
    private ArrayList weaponSystems;
    private MainDrive mainDriveSystem;
    private FTLDrive FTLDriveSystem;
    private ArrayList coreSystems;
    private CoreCommandBridge shipCommandBridge;
    private CoreLifeSupport shipLifeSupport;
    private CorePowerCore shipPowerCore;
    private ArrayList damageControlIds;
    private int fighterBays;
    private int fighterRecoveries;
    private int countRestrictedMovementLaunches;

    public Ship() {
        this.setId(Ship.getIdCounter());
        Ship.incrementIdCounter();
        ShipSystem.resetIdCounter();
        this.race = "";
        this.shipClass = "";
        this.className = "";
        this.classAbbrev = "";
        this.pointValue = 0;
        this.streamlining = "";
        this.FTLDriveSystem = null;
        this.shipArmor = new Armor(0);
        this.shipHull = new Hull(0);
        this.electronicsSystems = new ArrayList();
        this.defenseSystems = new ArrayList();
        this.shipHolds = new ArrayList();
        this.weaponSystems = new ArrayList();
        this.coreSystems = new ArrayList();
        this.shipCommandBridge = new CoreCommandBridge();
        this.shipLifeSupport = new CoreLifeSupport();
        this.shipPowerCore = new CorePowerCore();
        this.coreSystems.add(this.shipCommandBridge);
        this.coreSystems.add(this.shipLifeSupport);
        this.coreSystems.add(this.shipPowerCore);
        this.damageControlIds = new ArrayList();
        this.fighterBays = -1;
        this.fighterRecoveries = 0;
        this.countRestrictedMovementLaunches = 0;
    }

    public static int getIdCounter() {
        return idCounter;
    }

    public static void incrementIdCounter() {
        ++idCounter;
    }

    public void setRace(String s) {
        this.race = s;
    }

    public String getRace() {
        return this.race;
    }

    public void setShipClass(String s) {
        this.shipClass = s;
    }

    public String getShipClass() {
        return this.shipClass;
    }

    public void setClassName(String s) {
        this.className = s;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassAbbrev(String s) {
        this.classAbbrev = s;
    }

    public String getClassAbbrev() {
        return this.classAbbrev;
    }

    public String getClassAbbrevBogey() {
        int shipMass = (int)((double)this.getMass() * this.getMassStealthModifier());
        if (shipMass < 41) {
            return "BogeyDD";
        }
        if (shipMass < 91) {
            return "BogeyCA";
        }
        return "BogeyBB";
    }

    public int getMass() {
        return this.shipHull.getHullSize();
    }

    public void setPointValue(int p) {
        this.pointValue = p;
    }

    public int getPointValue() {
        return this.pointValue;
    }

    public void setStreamlining(String s) {
        this.streamlining = s;
    }

    public String getStreamlining() {
        return this.streamlining;
    }

    public void setMainDrive(MainDrive m) {
        this.mainDriveSystem = m;
    }

    public MainDrive getMainDrive() {
        return this.mainDriveSystem;
    }

    public int getCurrentThrust() {
        if (this.mainDriveSystem == null) {
            return 0;
        }
        return this.mainDriveSystem.getCurrentThrust();
    }

    public void setFTLDrive(FTLDrive m) {
        this.FTLDriveSystem = m;
    }

    public FTLDrive getFTLDrive() {
        return this.FTLDriveSystem;
    }

    public void setShipHolds(ArrayList e) {
        this.shipHolds = e;
    }

    public ArrayList getShipHolds() {
        return this.shipHolds;
    }

    public void setArmor(Armor a) {
        this.shipArmor = a;
    }

    public Armor getArmor() {
        return this.shipArmor;
    }

    public void setHull(Hull h) {
        this.shipHull = h;
    }

    public Hull getHull() {
        return this.shipHull;
    }

    public void setCoreSystems(ArrayList e) {
        this.coreSystems = e;
    }

    public ArrayList getCoreSystems() {
        return this.coreSystems;
    }

    public void setElectronicsSystems(ArrayList e) {
        this.electronicsSystems = e;
    }

    public ArrayList getElectronicsSystems() {
        return this.electronicsSystems;
    }

    public void setDefenseSystems(ArrayList e) {
        this.defenseSystems = e;
    }

    public ArrayList getDefenseSystems() {
        return this.defenseSystems;
    }

    public void setDamageControlIds(ArrayList e) {
        this.damageControlIds = e;
    }

    public ArrayList getDamageControlIds() {
        return this.damageControlIds;
    }

    public void setWeaponSystems(ArrayList e) {
        this.weaponSystems = e;
    }

    public ArrayList getWeaponSystems() {
        return this.weaponSystems;
    }

    public Weapon getWeaponById(int id) {
        Weapon w = null;
        for (int i = 0; i < this.weaponSystems.size(); ++i) {
            Weapon j = (Weapon)this.weaponSystems.get(i);
            int k = j.getId();
            if (k != id) continue;
            return j;
        }
        return w;
    }

    public ShipSystem getShipSystemById(int id) {
        int k;
        int i;
        ShipSystem ss = null;
        for (i = 0; i < this.coreSystems.size(); ++i) {
            ss = (ShipSystem)this.coreSystems.get(i);
            k = ss.getId();
            if (k != id) continue;
            return ss;
        }
        for (i = 0; i < this.electronicsSystems.size(); ++i) {
            ss = (ShipSystem)this.electronicsSystems.get(i);
            k = ss.getId();
            if (k != id) continue;
            return ss;
        }
        for (i = 0; i < this.defenseSystems.size(); ++i) {
            ss = (ShipSystem)this.defenseSystems.get(i);
            k = ss.getId();
            if (k != id) continue;
            return ss;
        }
        for (i = 0; i < this.shipHolds.size(); ++i) {
            ss = (ShipSystem)this.shipHolds.get(i);
            k = ss.getId();
            if (k != id) continue;
            return ss;
        }
        for (i = 0; i < this.weaponSystems.size(); ++i) {
            ss = (ShipSystem)this.weaponSystems.get(i);
            k = ss.getId();
            if (k != id) continue;
            return ss;
        }
        return ss;
    }

    public boolean canFire() {
        boolean canFire = false;
        if (this.getNumberOfActiveFireControls() == 0) {
            return canFire;
        }
        for (int i = 0; i < this.weaponSystems.size(); ++i) {
            Object obj = this.weaponSystems.get(i);
            Weapon w = (Weapon)obj;
            if (!w.getSystemStatus().equals("Operational") || w.hasFired()) continue;
            canFire = true;
            break;
        }
        return canFire;
    }

    public boolean hasOrders() {
        boolean isCombatPhase = this.getGameEngine().isCombatPhase();
        if (isCombatPhase) {
            ArrayList fireCons = this.getActiveFireControls();
            for (int i = 0; i < fireCons.size(); ++i) {
                FireControl fc = (FireControl)fireCons.get(i);
                if (fc.getTargetId() == 0) continue;
                return true;
            }
            return false;
        }
        return !this.getOrders().equals("0");
    }

    public int getNumberOfActiveScreens() {
        int count = 0;
        for (int i = 0; i < this.defenseSystems.size(); ++i) {
            VapourShroud vs;
            ShipSystem o = (ShipSystem)this.defenseSystems.get(i);
            if (o instanceof Screen) {
                Screen s = (Screen)o;
                if (!s.getSystemStatus().equals("Operational")) continue;
                ++count;
                continue;
            }
            if (!(o instanceof VapourShroud) || !(vs = (VapourShroud)o).getSystemStatus().equals("Operational") || !vs.isActive()) continue;
            count += 2;
        }
        if (count > 2) {
            count = 2;
        }
        if (this.hasFiredNovaCannon()) {
            count = 0;
        }
        if (this.hasFiredWaveGun()) {
            count = 0;
        }
        return count;
    }

    public int getNumberOfActiveStealthGenerators() {
        int count = 0;
        for (int i = 0; i < this.defenseSystems.size(); ++i) {
            StealthGenerator s;
            ShipSystem o = (ShipSystem)this.defenseSystems.get(i);
            if (!(o instanceof StealthGenerator) || !(s = (StealthGenerator)o).getSystemStatus().equals("Operational")) continue;
            ++count;
        }
        if (count > 2) {
            count = 2;
        }
        return count;
    }

    public double getRangeStealthModifier() {
        int countGenerators = this.getNumberOfActiveStealthGenerators();
        int countHull = this.shipHull.getRemainingHullStealth();
        int totalStealth = countGenerators + countHull;
        double result = 1.0;
        switch (totalStealth) {
            case 0: {
                result = 1.0;
                break;
            }
            case 1: {
                result = 1.2;
                break;
            }
            case 2: {
                result = 1.5;
                break;
            }
            case 3: {
                result = 1.666;
                break;
            }
            case 4: {
                result = 2.0;
            }
        }
        return result;
    }

    public double getMassStealthModifier() {
        int countGenerators = this.getNumberOfActiveStealthGenerators();
        int countHull = this.shipHull.getRemainingHullStealth();
        int totalStealth = countGenerators + countHull;
        double result = 1.0;
        switch (totalStealth) {
            case 0: {
                result = 1.0;
                break;
            }
            case 1: {
                result = 0.5;
                break;
            }
            case 2: {
                result = 0.25;
                break;
            }
            case 3: {
                result = 0.166;
                break;
            }
            case 4: {
                result = 0.125;
            }
        }
        return result;
    }

    public double getHullPercentage() {
        if (this.isDestroyed() || this.shipHull == null) {
            return 0.0;
        }
        int initialHull = this.shipHull.getTotalHull();
        int currentHull = this.shipHull.getRemainingHull();
        if (initialHull <= 0 || currentHull <= 0) {
            return 0.0;
        }
        return (double)currentHull / (double)initialHull;
    }

    public ArrayList getActiveFireControls() {
        ArrayList<FireControl> a = new ArrayList<FireControl>();
        for (int i = 0; i < this.electronicsSystems.size(); ++i) {
            FireControl s;
            ShipSystem o = (ShipSystem)this.electronicsSystems.get(i);
            if (!(o instanceof FireControl) || !(s = (FireControl)o).getSystemStatus().equals("Operational")) continue;
            a.add(s);
        }
        return a;
    }

    public int getNumberOfActiveFireControls() {
        int count = 0;
        for (int i = 0; i < this.electronicsSystems.size(); ++i) {
            FireControl s;
            ShipSystem o = (ShipSystem)this.electronicsSystems.get(i);
            if (!(o instanceof FireControl) || !(s = (FireControl)o).getSystemStatus().equals("Operational")) continue;
            ++count;
        }
        return count;
    }

    public ArrayList getActiveAreaDefenseFireControls() {
        ArrayList<AreaDefenseFireControl> a = new ArrayList<AreaDefenseFireControl>();
        for (int i = 0; i < this.electronicsSystems.size(); ++i) {
            AreaDefenseFireControl s;
            ShipSystem o = (ShipSystem)this.electronicsSystems.get(i);
            if (!(o instanceof AreaDefenseFireControl) || !(s = (AreaDefenseFireControl)o).getSystemStatus().equals("Operational")) continue;
            a.add(s);
        }
        return a;
    }

    public int getNumberOfActiveAreaDefenseFireControls() {
        return this.getActiveAreaDefenseFireControls().size();
    }

    public void shutdownAllWeapons() {
        this.prepareForFTL();
    }

    public void prepareForFTL() {
        this.unslaveWeapons();
        this.resetTargetsForPDS();
    }

    public void unslaveWeapons() {
        for (int i = 0; i < this.electronicsSystems.size(); ++i) {
            ShipSystem o = (ShipSystem)this.electronicsSystems.get(i);
            if (!(o instanceof FireControl)) continue;
            FireControl fc = (FireControl)o;
            fc.prepareForFTL();
        }
    }

    public void resetTargetsForPDS() {
        for (int i = 0; i < this.getWeaponSystems().size(); ++i) {
            Weapon w = (Weapon)this.getWeaponSystems().get(i);
            w.setTarget(null);
        }
    }

    public SpaceObject getPrimaryTarget() {
        SpaceObject target = null;
        for (int i = 0; i < this.electronicsSystems.size(); ++i) {
            FireControl s;
            ShipSystem o = (ShipSystem)this.electronicsSystems.get(i);
            if (!(o instanceof FireControl) || !(s = (FireControl)o).getSystemStatus().equals("Operational")) continue;
            int id = s.getTargetId();
            return this.getGameEngine().getShipById(id);
        }
        return target;
    }

    public SpaceObject getSecondaryTarget() {
        int count = 0;
        SpaceObject target = null;
        for (int i = 0; i < this.electronicsSystems.size(); ++i) {
            FireControl s;
            ShipSystem o = (ShipSystem)this.electronicsSystems.get(i);
            if (!(o instanceof FireControl) || !(s = (FireControl)o).getSystemStatus().equals("Operational") || ++count != 2) continue;
            int id = s.getTargetId();
            return this.getGameEngine().getShipById(id);
        }
        return target;
    }

    public SpaceObject getTertiaryTarget() {
        int count = 0;
        SpaceObject target = null;
        for (int i = 0; i < this.electronicsSystems.size(); ++i) {
            FireControl s;
            ShipSystem o = (ShipSystem)this.electronicsSystems.get(i);
            if (!(o instanceof FireControl) || !(s = (FireControl)o).getSystemStatus().equals("Operational") || ++count != 3) continue;
            int id = s.getTargetId();
            return this.getGameEngine().getShipById(id);
        }
        return target;
    }

    public void evaluateFireControlTargets() {
        Ship target = null;
        int targetId = 0;
        for (int i = 0; i < this.electronicsSystems.size(); ++i) {
            AreaDefenseFireControl a;
            ShipSystem o = (ShipSystem)this.electronicsSystems.get(i);
            if (o instanceof FireControl) {
                FireControl f = (FireControl)o;
                targetId = f.getTargetId();
                target = targetId == 0 ? null : this.getGameEngine().getShipById(targetId);
                if (target != null && target.isDestroyed()) {
                    f.setTargetId(0);
                    f.unslaveAllWeapons();
                }
                if (this.isDestroyed() || this.hasStruck()) {
                    f.setTargetId(0);
                    f.unslaveAllWeapons();
                }
            }
            if (!(o instanceof AreaDefenseFireControl) || !(a = (AreaDefenseFireControl)o).getSystemStatus().equals("Operational")) continue;
            int tId = a.getDefendedTargetId();
            target = (Ship)this.getGameEngine().getObjectById(tId);
            if (target != null && target.isDestroyed() && !target.isHulk()) {
                a.setDefendedTarget(null);
                a.setDefendedTargetId(0);
            }
            if (!this.isDestroyed() && !this.hasStruck()) continue;
            a.setDefendedTarget(null);
            a.setDefendedTargetId(0);
        }
    }

    public boolean canLaunch(SpaceObject so) {
        boolean result = false;
        if (so instanceof MissileSalvo) {
            MissileSalvo ms = (MissileSalvo)so;
            Weapon w = this.getWeaponById(ms.getLauncherId());
            if (!(w instanceof SalvoMissileRack) && !(w instanceof SalvoMissileLauncher)) {
                return false;
            }
            if (w instanceof SalvoMissileRack) {
                SalvoMissileRack smr = (SalvoMissileRack)w;
                result = smr.canLaunch(this, ms);
                return result;
            }
            if (w instanceof SalvoMissileLauncher) {
                SalvoMissileLauncher sml = (SalvoMissileLauncher)w;
                result = sml.canLaunch(this, ms);
                return result;
            }
        } else {
            if (so instanceof PlasmaBolt) {
                PlasmaBolt pb = (PlasmaBolt)so;
                Weapon w = this.getWeaponById(pb.getLauncherId());
                if (!(w instanceof PlasmaBoltLauncher)) {
                    return false;
                }
                PlasmaBoltLauncher pbl = (PlasmaBoltLauncher)w;
                result = pbl.canLaunch(this, pb);
                return result;
            }
            if (so instanceof NovaCannonBolt) {
                NovaCannonBolt ncb = (NovaCannonBolt)so;
                Weapon w = this.getWeaponById(ncb.getLauncherId());
                if (!(w instanceof NovaCannon)) {
                    return false;
                }
                NovaCannon nc = (NovaCannon)w;
                result = nc.canLaunch(this, ncb);
                return result;
            }
            if (so instanceof WaveGunBolt) {
                WaveGunBolt wgb = (WaveGunBolt)so;
                Weapon w = this.getWeaponById(wgb.getLauncherId());
                if (!(w instanceof WaveGun)) {
                    return false;
                }
                WaveGun wg = (WaveGun)w;
                result = wg.canLaunch(this, wgb);
                return result;
            }
            if (so instanceof AntiMatterTorpedo) {
                AntiMatterTorpedo amt = (AntiMatterTorpedo)so;
                Weapon w = this.getWeaponById(amt.getLauncherId());
                if (!(w instanceof AntiMatterTorpedoLauncher)) {
                    return false;
                }
                AntiMatterTorpedoLauncher amtl = (AntiMatterTorpedoLauncher)w;
                result = amtl.canLaunch(this, amt);
                return result;
            }
            if (so instanceof Missile) {
                Missile m = (Missile)so;
                Weapon w = this.getWeaponById(m.getLauncherId());
                if (!(w instanceof MissileLauncher)) {
                    return false;
                }
                MissileLauncher ml = (MissileLauncher)w;
                result = ml.canLaunch(this, m);
                return result;
            }
            if (so instanceof FighterGroup) {
                FighterGroup fg = (FighterGroup)so;
                if (fg.isOnBoard() && fg.getCarrierShipId() == this.getId() && !this.hasOrders()) {
                    Weapon w = this.getWeaponById(fg.getFighterBayId());
                    return w.isRecharged();
                }
                result = false;
            }
        }
        return result;
    }

    public void takeDamage(int[] damage) {
        if (this.isDestroyed()) {
            return;
        }
        int[] carryOver = this.shipArmor.takeDamage(damage);
        for (int i = 0; i < carryOver.length; ++i) {
            this.shipHull.takeDamage(carryOver[i]);
            if (!this.isDestroyed()) continue;
            this.addLog("Damage", "Critical", this.getName() + " has been destroyed.");
            ArrayList<FighterGroup> fighterGroups = new ArrayList<FighterGroup>();
            Iterator iterator = this.getWeaponSystems().iterator();
            while (iterator.hasNext()) {
                Weapon w = (Weapon)iterator.next();
                if (!(w instanceof FighterBay)) continue;
                fighterGroups.add(((FighterBay)w).getLandedFighterGroup());
            }
            for (int j = 0; j < fighterGroups.size(); ++j) {
                FighterGroup fg = (FighterGroup)fighterGroups.get(j);
                if (fg == null) continue;
                fg.takeDamage(new int[]{12});
            }
            GameEngine ge = this.getGameEngine();
            if (ge != null) {
                ge.addTurnReport("Damage", "Critical", this.getName() + " has been destroyed.");
            }
            return;
        }
    }

    public void checkForThreshold() {
        int sum = this.shipHull.getThresholdCheckSum();
        if (sum == 0) {
            return;
        }
        if ((sum & Hull.FIRST_THRESHOLD_CHECK) == Hull.FIRST_THRESHOLD_CHECK) {
            this.takeThresholdCheck(6);
            this.addLog("Damage", "Medium", "First threshold check.");
        }
        if ((sum & Hull.SECOND_THRESHOLD_CHECK) == Hull.SECOND_THRESHOLD_CHECK) {
            this.takeThresholdCheck(5);
            this.addLog("Damage", "High", "Second threshold check.");
        }
        if ((sum & Hull.THIRD_THRESHOLD_CHECK) == Hull.THIRD_THRESHOLD_CHECK) {
            this.takeThresholdCheck(4);
            this.addLog("Damage", "Urgent", "Third threshold check.");
        }
        this.shipHull.zeroThresholdCheckSum();
    }

    public void takeThresholdCheck(int level) {
        ShipSystem s;
        Object o;
        int i;
        if (this.mainDriveSystem != null) {
            this.mainDriveSystem.takeThresholdCheck(level);
        }
        if (this.FTLDriveSystem != null) {
            this.FTLDriveSystem.takeThresholdCheck(level);
        }
        for (i = 0; i < this.electronicsSystems.size(); ++i) {
            o = this.electronicsSystems.get(i);
            s = (ShipSystem)o;
            s.takeThresholdCheck(level);
        }
        for (i = 0; i < this.defenseSystems.size(); ++i) {
            o = this.defenseSystems.get(i);
            s = (ShipSystem)o;
            s.takeThresholdCheck(level);
        }
        for (i = 0; i < this.shipHolds.size(); ++i) {
            o = this.shipHolds.get(i);
            s = (ShipSystem)o;
            s.takeThresholdCheck(level);
        }
        for (i = 0; i < this.weaponSystems.size(); ++i) {
            o = this.weaponSystems.get(i);
            s = (ShipSystem)o;
            s.takeThresholdCheck(level);
        }
        if (this.getOptions().getCoreSystems()) {
            if (Dice.rollD6() >= level + 1) {
                int choice = Dice.rollD(4);
                switch (choice) {
                    case 1: {
                        this.shipCommandBridge.takeThresholdCheck(0);
                        break;
                    }
                    case 2: {
                        this.shipPowerCore.takeThresholdCheck(0);
                        break;
                    }
                    case 3: {
                        this.shipLifeSupport.takeThresholdCheck(0);
                        break;
                    }
                    case 4: {
                        this.setStatus(STRIKE);
                        this.addLog("Status", "High", STRIKE);
                        this.getGameEngine().addTurnReport("Status", "High", this.getName() + " is " + STRIKE);
                    }
                }
            }
            if (this.shipPowerCore.getSystemStatus().equals(DESTROYED)) {
                this.shipPowerCore.setDestroyed();
                int[] pCoreDamage = new int[]{2000};
                this.takeDamage(pCoreDamage);
            }
        }
    }

    public String evaluateShipStatus() {
        String s = this.shipHull.evaluateStatus();
        if (s.equals(DESTROYED)) {
            this.setStatus(s);
            return s;
        }
        if (this.shipLifeSupport.getSystemStatus().equals(DESTROYED)) {
            s = DESTROYED;
        } else if (this.getStatus().equals(JUMPED)) {
            s = JUMPED;
        } else if (this.getStatus().equals(STRIKE)) {
            s = STRIKE;
        }
        this.setStatus(s);
        return s;
    }

    public boolean isDestroyed() {
        return this.evaluateShipStatus().equals(DESTROYED);
    }

    public boolean hasStruck() {
        return this.evaluateShipStatus().equals(STRIKE);
    }

    public int getTurnDestroyed() {
        ArrayList shipLog = this.getLog();
        if (!this.isDestroyed() || shipLog == null) {
            return -1;
        }
        Iterator it = shipLog.iterator();
        while (it.hasNext()) {
            LogRecord l = (LogRecord)it.next();
            if (!l.getEvent().equals("Damage") || !l.getPriority().equals("Critical") || l.getRecord().indexOf("destroyed") == -1) continue;
            return l.getTurn();
        }
        return -1;
    }

    public boolean hasArrivedThisTurn() {
        return this.getArrivalTurn() == this.getGameEngine().getGameTurn();
    }

    public boolean hasArrived() {
        return this.getArrivalTurn() <= this.getGameEngine().getGameTurn();
    }

    public boolean hasJumped() {
        return this.evaluateShipStatus().equals(JUMPED);
    }

    public int getTurnJumped() {
        ArrayList shipLog = this.getLog();
        if (!this.hasJumped() || shipLog == null) {
            return -1;
        }
        Iterator it = shipLog.iterator();
        while (it.hasNext()) {
            LogRecord l = (LogRecord)it.next();
            if (!l.getEvent().equals("Status") || !l.getPriority().equals("High") || !l.getRecord().equals(JUMPED)) continue;
            return l.getTurn();
        }
        return -1;
    }

    public boolean isHulk() {
        boolean hullDestroyed = false;
        boolean lifeDestroyed = false;
        if (this.shipLifeSupport.getSystemStatus().equals(DESTROYED)) {
            lifeDestroyed = true;
        }
        if (this.evaluateShipStatus().equals(DESTROYED)) {
            hullDestroyed = true;
        }
        return lifeDestroyed && !hullDestroyed;
    }

    public void orderedRepair() {
        int[] teams = new int[200];
        ArrayList repairList = this.getRepairList();
        ArrayList orderedDCP = this.getDamageControlIds();
        if (repairList.size() == 0) {
            return;
        }
        if (orderedDCP.size() == 0) {
            this.autoRepair();
        } else {
            int i;
            for (i = 0; i < orderedDCP.size(); ++i) {
                int index;
                int n = index = ((Integer)orderedDCP.get(i)).intValue();
                teams[n] = teams[n] + 1;
            }
            for (i = 0; i < repairList.size(); ++i) {
                ShipSystem s = (ShipSystem)repairList.get(i);
                int count = teams[s.getId()];
                if (count <= 0) continue;
                String crewReport = s.attemptRepair(this.getCrewQuality(), count);
                if (s.isOperational()) {
                    if (crewReport == null) {
                        crewReport = s.getSystemName() + " has been repaired. ";
                    }
                } else if (crewReport == null) {
                    crewReport = "Damage control was unable to repair the " + s.getSystemName() + ".";
                }
                this.addLog("Repair", "Medium", crewReport);
            }
        }
    }

    public void autoRepair() {
        ShipSystem s;
        Object o;
        int i;
        int[] teams = new int[50];
        int numberDCP = this.shipHull.getRemainingDamageControl();
        ArrayList<ShipSystem> RepairList = new ArrayList<ShipSystem>();
        if (this.getOptions().getCoreSystems()) {
            if (this.shipPowerCore.getSystemStatus().equals("Damaged")) {
                RepairList.add(this.shipPowerCore);
            }
            if (this.shipLifeSupport.getSystemStatus().equals("Damaged")) {
                RepairList.add(this.shipLifeSupport);
            }
            if (this.shipCommandBridge.getSystemStatus().equals("Damaged")) {
                RepairList.add(this.shipCommandBridge);
            }
        }
        int count = 0;
        ShipSystem b = null;
        for (i = 0; i < this.electronicsSystems.size(); ++i) {
            o = this.electronicsSystems.get(i);
            s = (ShipSystem)o;
            if (!(s instanceof FireControl)) continue;
            if (s.getSystemStatus().equals("Operational")) {
                ++count;
            }
            if (!s.getSystemStatus().equals("Damaged")) continue;
            b = s;
        }
        if (count == 0 && b != null) {
            RepairList.add(b);
        }
        if (this.mainDriveSystem != null && this.mainDriveSystem.getSystemStatus().equals("Damaged")) {
            RepairList.add(this.mainDriveSystem);
        }
        for (i = 0; i < this.defenseSystems.size(); ++i) {
            o = this.defenseSystems.get(i);
            s = (ShipSystem)o;
            if (!s.getSystemStatus().equals("Damaged")) continue;
            RepairList.add(s);
        }
        for (i = 0; i < this.weaponSystems.size(); ++i) {
            o = this.weaponSystems.get(i);
            s = (ShipSystem)o;
            if (!s.getSystemStatus().equals("Damaged")) continue;
            RepairList.add(s);
        }
        if (this.FTLDriveSystem != null && this.FTLDriveSystem.getSystemStatus().equals("Damaged")) {
            RepairList.add(this.FTLDriveSystem);
        }
        for (i = 0; i < this.electronicsSystems.size(); ++i) {
            o = this.electronicsSystems.get(i);
            if (RepairList.contains(o) || !(s = (ShipSystem)o).getSystemStatus().equals("Damaged")) continue;
            RepairList.add(s);
        }
        if (RepairList.size() == 0) {
            return;
        }
        if (RepairList.size() > numberDCP) {
            for (i = 0; i < numberDCP; ++i) {
                o = RepairList.get(i);
                s = (ShipSystem)o;
                String crewReport = s.attemptRepair(1);
                if (s.isOperational()) {
                    if (crewReport == null) {
                        crewReport = s.getSystemName() + " has been repaired. ";
                    }
                } else if (crewReport == null) {
                    crewReport = "Damage control was unable to repair the " + s.getSystemName() + ".";
                }
                this.addLog("Repair", "Medium", crewReport);
            }
            return;
        }
        count = 0;
        for (int j = 0; j < 3; ++j) {
            i = 0;
            while (i < RepairList.size() && count < numberDCP) {
                int n = i++;
                teams[n] = teams[n] + 1;
                ++count;
            }
        }
        for (i = 0; i < RepairList.size(); ++i) {
            o = RepairList.get(i);
            s = (ShipSystem)o;
            String crewReport = s.attemptRepair(teams[i]);
            if (s.isOperational()) {
                if (crewReport == null) {
                    crewReport = s.getSystemName() + " has been repaired. ";
                }
            } else if (crewReport == null) {
                crewReport = "Damage control was unable to repair the " + s.getSystemName() + ".";
            }
            this.addLog("Repair", "Medium", crewReport);
        }
    }

    public ArrayList getRepairList() {
        ShipSystem s;
        int i;
        ArrayList<ShipSystem> repairList = new ArrayList<ShipSystem>();
        if (this.getOptions().getCoreSystems()) {
            if (this.shipPowerCore.getSystemStatus().equals("Damaged")) {
                repairList.add(this.shipPowerCore);
            }
            if (this.shipLifeSupport.getSystemStatus().equals("Damaged")) {
                repairList.add(this.shipLifeSupport);
            }
            if (this.shipCommandBridge.getSystemStatus().equals("Damaged")) {
                repairList.add(this.shipCommandBridge);
            }
        }
        if (this.mainDriveSystem != null && this.mainDriveSystem.getSystemStatus().equals("Damaged")) {
            repairList.add(this.mainDriveSystem);
        }
        if (this.FTLDriveSystem != null && this.FTLDriveSystem.getSystemStatus().equals("Damaged")) {
            repairList.add(this.FTLDriveSystem);
        }
        for (i = 0; i < this.electronicsSystems.size(); ++i) {
            s = (ShipSystem)this.electronicsSystems.get(i);
            if (!s.getSystemStatus().equals("Damaged")) continue;
            repairList.add(s);
        }
        for (i = 0; i < this.defenseSystems.size(); ++i) {
            s = (ShipSystem)this.defenseSystems.get(i);
            if (!s.getSystemStatus().equals("Damaged")) continue;
            repairList.add(s);
        }
        for (i = 0; i < this.weaponSystems.size(); ++i) {
            s = (ShipSystem)this.weaponSystems.get(i);
            if (!s.getSystemStatus().equals("Damaged")) continue;
            repairList.add(s);
        }
        return repairList;
    }

    public void moveShip(int courseChange, int speedChange, int sideslip, int roll, int jump, int strike) {
        boolean hasMainDrive;
        boolean bl = hasMainDrive = this.mainDriveSystem != null;
        if (strike == 1) {
            this.setStatus(STRIKE);
        }
        this.setUsedDrives(false);
        if (courseChange != 0 || speedChange != 0 || roll != 0 || jump != 0) {
            this.setUsedDrives(true);
            if (hasMainDrive) {
                this.getMainDrive().setActive(true);
            }
        }
        MovementSteps ms = this.getMovementSteps(courseChange, speedChange, sideslip, roll, jump, strike);
        if (this.FTLDriveSystem != null && this.FTLDriveSystem.isActive()) {
            this.prepareForFTL();
            this.addLog("Status", "High", "FTL Drives have been activated.");
            GameEngine ge = this.getGameEngine();
            if (ge != null) {
                ge.addTurnReport("Status", "High", this.getName() + " FTL Drives have been activated.");
            }
        }
        double xP = this.getXPosition();
        double yP = this.getYPosition();
        int shipSpeed = this.getSpeed();
        this.setPastX(xP);
        this.setPastY(yP);
        this.setPastHeading(this.getHeading());
        this.setXPosition(xP + ms.First[0] + ms.Second[0]);
        this.setYPosition(yP + ms.First[1] + ms.Second[1]);
        if ((shipSpeed += ms.SpeedChange) < 0) {
            shipSpeed = 0;
        }
        this.setSpeed(shipSpeed);
        int shipHeading = ms.Heading[1];
        if (shipHeading <= 0) {
            shipHeading += 12;
        }
        if (shipHeading > 12) {
            shipHeading -= 12;
        }
        this.setHeading(shipHeading);
        if (ms.Roll) {
            this.toggleRolled();
        }
        if (ms.Jumping) {
            this.setStatus(JUMPED);
        }
        if (ms.Striking) {
            this.setStatus(STRIKE);
        }
        this.checkForCollisions(xP, yP, xP + ms.First[0], yP + ms.First[1]);
        this.checkForCollisions(xP + ms.First[0], yP + ms.First[1], xP + ms.First[0] + ms.Second[0], yP + ms.First[1] + ms.Second[1]);
    }

    public void moveShip(int courseChange, int speedChange) {
        this.moveShip(courseChange, speedChange, 0, 0, 0, 0);
    }

    public void moveShip() {
        MovementSteps ms = this.getMovementSteps();
        if (this.FTLDriveSystem != null && this.FTLDriveSystem.isActive()) {
            this.prepareForFTL();
            this.addLog("Status", "High", "FTL Drives have been activated.");
            GameEngine ge = this.getGameEngine();
            if (ge != null) {
                ge.addTurnReport("Status", "High", this.getName() + " FTL Drives have been activated.");
            }
        }
        double xP = this.getXPosition();
        double yP = this.getYPosition();
        this.setPastX(xP);
        this.setPastY(yP);
        this.setPastHeading(this.getHeading());
        this.setXPosition(xP + ms.First[0] + ms.Second[0]);
        this.setYPosition(yP + ms.First[1] + ms.Second[1]);
        this.setVelocity(ms.Second[0], ms.Second[1]);
        this.setCourse(ms.Second[0], ms.Second[1]);
        int shipHeading = ms.Heading[1];
        if (shipHeading <= 0) {
            shipHeading += 12;
        }
        if (shipHeading > 12) {
            shipHeading -= 12;
        }
        this.setHeading(shipHeading);
        if (ms.Roll) {
            this.toggleRolled();
        }
        if (ms.Jumping) {
            this.setStatus(JUMPED);
        }
        if (ms.Striking) {
            this.setStatus(STRIKE);
        }
        this.checkForCollisions(xP, yP, xP + ms.First[0] + ms.Second[0], yP + ms.First[1] + ms.Second[1]);
    }

    private void checkForCollisions(double fromX, double fromY, double toX, double toY) {
        GameEngine theGame = this.getGameEngine();
        if (theGame == null) {
            return;
        }
        ArrayList heavenlyBodies = theGame.getHeavenlyBodies();
        if (heavenlyBodies == null) {
            return;
        }
        if (heavenlyBodies.size() == 0) {
            return;
        }
        for (int i = 0; i < heavenlyBodies.size(); ++i) {
            SpaceObject so = (SpaceObject)heavenlyBodies.get(i);
            if (!so.intersect(fromX, fromY, toX, toY)) continue;
            double[] result = so.intersectionPoint(fromX, fromY, toX, toY);
            double dx = toX - fromX;
            double dy = toY - fromY;
            double length = Math.sqrt(dx * dx + dy * dy);
            this.setXPosition(result[0] - (dx /= length) * 0.1);
            this.setYPosition(result[1] - (dy /= length) * 0.1);
            this.setSpeed(0);
            this.setVelocity(0.0, 0.0);
            this.addLog("Status", "High", "Collision with " + so.getName() + ".");
            GameEngine ge = this.getGameEngine();
            if (ge != null) {
                ge.addTurnReport("Status", "High", this.getName() + " has collided with " + so.getName() + ".");
            }
            this.takeDamage(new int[]{1000});
        }
    }

    public double getPlottedXPosition() {
        boolean defaultOrders = false;
        return this.getPlottedXPosition(defaultOrders);
    }

    public double getPlottedXPosition(boolean defaultOrders) {
        MovementSteps ms = defaultOrders ? (this.getOptions().getCinematicMovement() ? this.getMovementSteps(0, 0) : this.getMovementSteps("0")) : this.getMovementSteps();
        return this.getXPosition() + ms.First[0] + ms.Second[0];
    }

    public double getPlottedYPosition() {
        boolean defaultOrders = false;
        return this.getPlottedYPosition(defaultOrders);
    }

    public double getPlottedYPosition(boolean defaultOrders) {
        MovementSteps ms = defaultOrders ? (this.getOptions().getCinematicMovement() ? this.getMovementSteps(0, 0) : this.getMovementSteps("0")) : this.getMovementSteps();
        return this.getYPosition() + ms.First[1] + ms.Second[1];
    }

    public int getPlottedHeading() {
        boolean defaultOrders = false;
        return this.getPlottedHeading(defaultOrders);
    }

    public int getPlottedHeading(boolean defaultOrders) {
        MovementSteps ms = defaultOrders ? (this.getOptions().getCinematicMovement() ? this.getMovementSteps(0, 0) : this.getMovementSteps("0")) : this.getMovementSteps();
        int shipHeading = ms.Heading[1];
        if (shipHeading <= 0) {
            shipHeading += 12;
        }
        if (shipHeading > 12) {
            shipHeading -= 12;
        }
        return shipHeading;
    }

    public int getPlottedSpeed() {
        boolean defaultOrders = false;
        return this.getPlottedSpeed(defaultOrders);
    }

    public int getPlottedSpeed(boolean defaultOrders) {
        MovementSteps ms = defaultOrders ? (this.getOptions().getCinematicMovement() ? this.getMovementSteps(0, 0) : this.getMovementSteps("0")) : this.getMovementSteps();
        return this.getSpeed() + ms.SpeedChange;
    }

    public double getFighterLaunchXPosition() {
        boolean defaultOrders = true;
        return (this.getXPosition() + this.getPlottedXPosition(defaultOrders)) / 2.0;
    }

    public double getFighterLaunchYPosition() {
        boolean defaultOrders = true;
        return (this.getYPosition() + this.getPlottedYPosition(defaultOrders)) / 2.0;
    }

    public MovementSteps getMovementSteps() {
        if (this.getOptions().getCinematicMovement()) {
            if (this.getOptions().getShipRoll()) {
                return this.getMovementSteps(ParserUtilities.parseCinematicOrdersCourse(this.getOrders()), ParserUtilities.parseCinematicOrdersSpeed(this.getOrders()), ParserUtilities.parseCinematicOrdersSideslip(this.getOrders()), ParserUtilities.parseCinematicOrdersRoll(this.getOrders()), ParserUtilities.parseCinematicOrdersJump(this.getOrders()), ParserUtilities.parseCinematicOrdersStrike(this.getOrders()));
            }
            return this.getMovementSteps(ParserUtilities.parseCinematicOrdersCourse(this.getOrders()), ParserUtilities.parseCinematicOrdersSpeed(this.getOrders()), ParserUtilities.parseCinematicOrdersSideslip(this.getOrders()), 0, ParserUtilities.parseCinematicOrdersJump(this.getOrders()), ParserUtilities.parseCinematicOrdersStrike(this.getOrders()));
        }
        return this.getMovementSteps(this.getOrders());
    }

    public MovementSteps getMovementSteps(int courseChange, int speedChange) {
        return this.getMovementSteps(courseChange, speedChange, 0, 0, 0, 0);
    }

    public MovementSteps getMovementSteps(int courseChange, int speedChange, int sideslip, int roll, int jump, int strike) {
        double ysecond;
        double yfirst;
        double xsecond;
        double xfirst;
        int newSpeed;
        boolean zeroSpeedAccel;
        boolean hasMainDrive;
        boolean isValid = true;
        int thrust = 0;
        int shipSpeed = this.getSpeed();
        int shipHeading = this.getHeading();
        boolean hasFTLDrive = this.FTLDriveSystem != null;
        boolean bl = hasMainDrive = this.mainDriveSystem != null;
        if (strike != 0) {
            courseChange = 0;
            speedChange = 0;
            sideslip = 0;
            roll = 0;
            jump = 0;
        }
        if (jump != 0) {
            if (hasFTLDrive) {
                courseChange = 0;
                speedChange = 0;
                sideslip = 0;
                roll = 0;
                this.FTLDriveSystem.activate();
            } else {
                isValid = false;
            }
        } else if (hasFTLDrive) {
            this.FTLDriveSystem.deactivate();
        }
        if (roll != 0) {
            roll = 1;
        }
        if (hasMainDrive) {
            thrust = this.mainDriveSystem.getCurrentThrust();
        }
        boolean isAdvanced = false;
        if (hasMainDrive) {
            isAdvanced = this.mainDriveSystem.getType().equals("Advanced");
        }
        if (this.getOptions().getCoreSystems() && !this.shipCommandBridge.getSystemStatus().equals("Operational")) {
            courseChange = 0;
            speedChange = 0;
            roll = 0;
        }
        if (this.getOptions().getCoreSystems() && this.isHulk()) {
            courseChange = 0;
            speedChange = 0;
            sideslip = 0;
            roll = 0;
        }
        boolean nonZeroSpeed = shipSpeed > 0;
        boolean bl2 = zeroSpeedAccel = shipSpeed == 0 && speedChange != 0;
        if (nonZeroSpeed || zeroSpeedAccel) {
            int maxTurn = isAdvanced || thrust == 1 ? thrust : (int)Math.floor((double)thrust / 2.0);
            if (sideslip != 0 && Math.abs(2 * courseChange) + roll > maxTurn) {
                isValid = false;
                if (courseChange < 0) {
                    courseChange = -maxTurn / 2;
                    roll = 0;
                } else {
                    courseChange = maxTurn / 2;
                    roll = 0;
                }
            } else if (Math.abs(courseChange) + roll > maxTurn) {
                isValid = false;
                if (courseChange < 0) {
                    courseChange = -maxTurn;
                    roll = 0;
                } else {
                    courseChange = maxTurn;
                    roll = 0;
                }
            }
            int sum = sideslip != 0 ? roll + 2 * Math.abs(courseChange) + Math.abs(speedChange) : roll + Math.abs(courseChange) + Math.abs(speedChange);
            while (thrust < sum) {
                isValid = false;
                if (speedChange < 0) {
                    ++speedChange;
                }
                if (speedChange > 0) {
                    --speedChange;
                }
                sum = roll + Math.abs(courseChange) + Math.abs(speedChange);
                if (speedChange != 0 || thrust >= sum) continue;
                roll = 0;
            }
        }
        if ((newSpeed = shipSpeed + speedChange) < 0) {
            newSpeed = 0;
            speedChange = -shipSpeed;
        }
        double sign = 1.0;
        if (courseChange < 0) {
            sign = -1.0;
        }
        if (sideslip == 0) {
            xfirst = (double)newSpeed / 2.0 * Math.sin(MathUtil.toRadians(((double)shipHeading + sign * Math.floor(Math.abs((double)courseChange / 2.0))) * 30.0));
            xsecond = (double)newSpeed / 2.0 * Math.sin(MathUtil.toRadians((double)(shipHeading + courseChange) * 30.0));
            yfirst = (double)newSpeed / 2.0 * Math.cos(MathUtil.toRadians(((double)shipHeading + sign * Math.floor(Math.abs((double)courseChange / 2.0))) * 30.0));
            ysecond = (double)newSpeed / 2.0 * Math.cos(MathUtil.toRadians((double)(shipHeading + courseChange) * 30.0));
        } else {
            xfirst = (double)newSpeed / 2.0 * Math.sin(MathUtil.toRadians(((double)shipHeading + sign * Math.floor(Math.abs(courseChange))) * 30.0));
            xsecond = (double)newSpeed / 2.0 * Math.sin(MathUtil.toRadians((double)shipHeading * 30.0));
            yfirst = (double)newSpeed / 2.0 * Math.cos(MathUtil.toRadians(((double)shipHeading + sign * Math.floor(Math.abs(courseChange))) * 30.0));
            ysecond = (double)newSpeed / 2.0 * Math.cos(MathUtil.toRadians((double)shipHeading * 30.0));
        }
        MovementSteps ms = new MovementSteps();
        ms.Valid = isValid;
        ms.SpeedChange = speedChange;
        ms.First[0] = xfirst;
        ms.First[1] = yfirst;
        ms.Second[0] = xsecond;
        ms.Second[1] = ysecond;
        ms.Roll = roll == 1;
        ms.Jumping = hasFTLDrive ? this.FTLDriveSystem.isJumping() : false;
        boolean bl3 = ms.Striking = strike == 1;
        if (sideslip == 0) {
            ms.Heading[0] = shipHeading + (int)(sign * Math.floor(Math.abs((double)courseChange / 2.0)));
            if (ms.Heading[0] <= 0) {
                ms.Heading[0] = ms.Heading[0] + 12;
            }
            if (ms.Heading[0] > 0) {
                ms.Heading[0] = ms.Heading[0] - 12;
            }
            ms.Heading[1] = shipHeading + courseChange;
            if (ms.Heading[1] <= 0) {
                ms.Heading[1] = ms.Heading[1] + 12;
            }
            if (ms.Heading[1] > 0) {
                ms.Heading[1] = ms.Heading[1] - 12;
            }
        } else {
            ms.Heading[0] = shipHeading;
            ms.Heading[1] = shipHeading;
        }
        this.setOrdersValid(isValid);
        return ms;
    }

    public MovementSteps getMovementSteps(String orders) {
        boolean isValid = true;
        boolean isAdvanced = false;
        boolean activateFTLDrive = false;
        boolean hasFTLDrive = this.FTLDriveSystem != null;
        boolean hasMainDrive = this.mainDriveSystem != null;
        this.setUsedDrives(false);
        if (hasMainDrive) {
            isAdvanced = this.mainDriveSystem.getType().equals("Advanced");
        }
        if (this.getOptions().getCoreSystems() && !this.shipCommandBridge.getSystemStatus().equals("Operational")) {
            orders = "0";
        }
        if (this.getOptions().getCoreSystems() && this.isHulk()) {
            orders = "0";
        }
        int availableThrust = 0;
        int availableManuever = 0;
        if (this.mainDriveSystem != null) {
            availableThrust = this.mainDriveSystem.getCurrentThrust();
            availableManuever = availableThrust / 2;
        }
        if (isAdvanced) {
            availableManuever = availableThrust;
        }
        if (availableThrust == 1) {
            availableManuever = 1;
        }
        double ordersXVelocity = 0.0;
        double ordersYVelocity = 0.0;
        boolean executePushPort = false;
        boolean executePushStarboard = false;
        boolean executePushAft = false;
        orders = orders.toUpperCase();
        StringTokenizer st = new StringTokenizer(orders, " \t\n\r\f+,.-");
        int currentHeading = this.getHeading();
        boolean roll = false;
        boolean strike = false;
        while (st.hasMoreTokens()) {
            int value;
            String token = st.nextToken();
            try {
                value = ParserUtilities.parseInteger(token);
            }
            catch (Exception e) {
                value = 0;
            }
            int order = ParserUtilities.parseVectorOrder(token);
            switch (order) {
                case 0: {
                    if (value > availableThrust) {
                        isValid = false;
                        value = availableThrust;
                    }
                    availableThrust -= value;
                    this.setUsedDrives(true);
                    if (hasMainDrive) {
                        this.getMainDrive().setActive(true);
                    }
                    ordersXVelocity += (double)value * MathUtil.X(currentHeading);
                    ordersYVelocity += (double)value * MathUtil.Y(currentHeading);
                    break;
                }
                case 6: {
                    if (availableThrust <= 0 || availableManuever <= 0) {
                        isValid = false;
                        break;
                    }
                    --availableThrust;
                    --availableManuever;
                    roll = true;
                    this.setUsedDrives(true);
                    if (!hasMainDrive) break;
                    this.getMainDrive().setActive(true);
                    break;
                }
                case 1: {
                    if (!isAdvanced && availableThrust <= 0) {
                        isValid = false;
                        break;
                    }
                    if (availableManuever <= 0) {
                        isValid = false;
                        break;
                    }
                    if (!isAdvanced) {
                        --availableThrust;
                    }
                    --availableManuever;
                    currentHeading -= value;
                    this.setUsedDrives(true);
                    if (!hasMainDrive) break;
                    this.getMainDrive().setActive(true);
                    break;
                }
                case 2: {
                    if (!isAdvanced && availableThrust <= 0) {
                        isValid = false;
                        break;
                    }
                    if (availableManuever <= 0) {
                        isValid = false;
                        break;
                    }
                    if (!isAdvanced) {
                        --availableThrust;
                    }
                    --availableManuever;
                    currentHeading += value;
                    this.setUsedDrives(true);
                    if (!hasMainDrive) break;
                    this.getMainDrive().setActive(true);
                    break;
                }
                case 3: {
                    if (executePushPort) {
                        isValid = false;
                        break;
                    }
                    if (value > 1) {
                        isValid = false;
                        value = 1;
                    }
                    if (value > availableThrust || value > availableManuever) {
                        isValid = false;
                        break;
                    }
                    --availableThrust;
                    --availableManuever;
                    ordersXVelocity += (double)value * MathUtil.X(currentHeading - 3);
                    ordersYVelocity += (double)value * MathUtil.Y(currentHeading - 3);
                    executePushPort = true;
                    this.setUsedDrives(true);
                    if (!hasMainDrive) break;
                    this.getMainDrive().setActive(true);
                    break;
                }
                case 4: {
                    if (executePushStarboard) {
                        isValid = false;
                        break;
                    }
                    if (value > 1) {
                        isValid = false;
                        value = 1;
                    }
                    if (value > availableThrust || value > availableManuever) {
                        isValid = false;
                        break;
                    }
                    --availableThrust;
                    --availableManuever;
                    ordersXVelocity += (double)value * MathUtil.X(currentHeading + 3);
                    ordersYVelocity += (double)value * MathUtil.Y(currentHeading + 3);
                    executePushStarboard = true;
                    this.setUsedDrives(true);
                    if (!hasMainDrive) break;
                    this.getMainDrive().setActive(true);
                    break;
                }
                case 5: {
                    if (executePushAft) {
                        isValid = false;
                        break;
                    }
                    if (value > 1) {
                        isValid = false;
                        value = 1;
                    }
                    if (value > availableThrust || value > availableManuever) {
                        isValid = false;
                        break;
                    }
                    --availableThrust;
                    --availableManuever;
                    ordersXVelocity += (double)value * MathUtil.X(currentHeading + 6);
                    ordersYVelocity += (double)value * MathUtil.Y(currentHeading + 6);
                    executePushAft = true;
                    this.setUsedDrives(true);
                    if (!hasMainDrive) break;
                    this.getMainDrive().setActive(true);
                    break;
                }
                case 7: 
                case 8: {
                    activateFTLDrive = true;
                    this.setUsedDrives(true);
                    break;
                }
                case 9: {
                    strike = true;
                }
            }
        }
        if (activateFTLDrive) {
            if (hasFTLDrive) {
                this.FTLDriveSystem.activate();
            } else {
                isValid = false;
            }
        } else if (hasFTLDrive) {
            this.FTLDriveSystem.deactivate();
        }
        MovementSteps ms = new MovementSteps();
        ms.Valid = isValid;
        ms.SpeedChange = 0;
        ms.XVelocity = ordersXVelocity;
        ms.YVelocity = ordersYVelocity;
        ms.First[0] = 0.0;
        ms.First[1] = 0.0;
        ms.Second[0] = this.getXVelocity() + ordersXVelocity;
        ms.Second[1] = this.getYVelocity() + ordersYVelocity;
        ms.Heading[0] = 0;
        ms.Heading[1] = currentHeading;
        ms.Roll = roll;
        ms.Striking = strike;
        ms.Jumping = hasFTLDrive ? this.FTLDriveSystem.isJumping() : false;
        this.setOrdersValid(isValid);
        return ms;
    }

    public void fireAllWeaponsAt(SpaceObject o) {
        boolean writeLog = false;
        if (o == null) {
            return;
        }
        if (this.getOptions().getCoreSystems() && !this.shipCommandBridge.getSystemStatus().equals("Operational")) {
            return;
        }
        if (this.getNumberOfActiveFireControls() == 0) {
            return;
        }
        if (this.FTLDriveSystem != null && this.FTLDriveSystem.isActive()) {
            this.FTLDriveSystem.deactivate();
            if (!writeLog) {
                this.addLog("Status", "High", "FTL Drives have been deactivated.");
                GameEngine ge = this.getGameEngine();
                if (ge != null) {
                    ge.addTurnReport("Status", "High", this.getName() + " FTL Drives have been deactivated.");
                }
                writeLog = true;
            }
        }
        for (int i = 0; i < this.weaponSystems.size(); ++i) {
            Object obj = this.weaponSystems.get(i);
            Weapon w = (Weapon)obj;
            if (!w.getSystemStatus().equals("Operational") || w.hasFired()) continue;
            w.fireAt(this, o);
        }
    }

    public void fireTargetedWeapons() {
        FireControl fc = null;
        ArrayList FireControls = null;
        boolean hasFTLDrive = this.FTLDriveSystem != null;
        FireControls = this.getActiveFireControls();
        if (FireControls == null) {
            return;
        }
        for (int j = 0; j < FireControls.size(); ++j) {
            HashSet sw;
            boolean writeLog = false;
            fc = (FireControl)FireControls.get(j);
            if (fc == null || fc.getTargetId() == 0) continue;
            int id = fc.getTargetId();
            Ship target = this.getGameEngine().getShipById(id);
            ArrayList heavenlyBodies = this.getGameEngine().getHeavenlyBodies();
            for (int i = 0; i < heavenlyBodies.size(); ++i) {
                SpaceObject so = (SpaceObject)heavenlyBodies.get(i);
                if (!so.intersect(this, target)) continue;
            }
            if (hasFTLDrive && this.FTLDriveSystem.isActive()) {
                this.FTLDriveSystem.deactivate();
                if (!writeLog) {
                    this.addLog("Status", "High", "FTL Drives have been deactivated.");
                    GameEngine ge = this.getGameEngine();
                    if (ge != null) {
                        ge.addTurnReport("Status", "High", this.getName() + " FTL Drives have been deactivated.");
                    }
                    writeLog = true;
                }
            }
            if ((sw = fc.getSlavedWeapons()) == null) continue;
            Iterator Weapons = fc.getSlavedWeapons().iterator();
            while (Weapons.hasNext()) {
                Weapon w = (Weapon)Weapons.next();
                if (!w.getSystemStatus().equals("Operational") || w.hasFired()) continue;
                w.fireAt(this, target);
            }
        }
    }

    public void firePointDefense(boolean missileDefense) {
        for (int i = 0; i < this.weaponSystems.size(); ++i) {
            SpaceObject so;
            KineticGun kg;
            BeamBattery bb;
            Weapon w = (Weapon)this.weaponSystems.get(i);
            if (w.hasFired() || !w.getSystemStatus().equals("Operational")) continue;
            boolean class1Beam = false;
            if (w instanceof BeamBattery && (bb = (BeamBattery)w).getRating() == 1) {
                class1Beam = true;
            }
            if (w instanceof KineticGun && (kg = (KineticGun)w).getRating() == 1) {
                class1Beam = true;
            }
            if (w instanceof Pulser) {
                class1Beam = true;
            }
            if (!w.isPointDefense() && !class1Beam || w.getTargetId() == 0 && w.getTarget() == null || (so = this.getGameEngine().getObjectById(w.getTargetId())) == null) continue;
            if (so.isShip()) {
                if (missileDefense) continue;
                w.fireAt(this, so);
                continue;
            }
            if (!missileDefense) continue;
            w.fireAt(this, so);
        }
    }

    public void fireWeaponsInPrioritySequence() {
        SpaceObject o = this.getPrimaryTarget();
        this.fireAllWeaponsAt(o);
        o = this.getSecondaryTarget();
        this.fireAllWeaponsAt(o);
        o = this.getTertiaryTarget();
        this.fireAllWeaponsAt(o);
    }

    public void resetWeapons() {
        for (int i = 0; i < this.weaponSystems.size(); ++i) {
            Object obj = this.weaponSystems.get(i);
            Weapon w = (Weapon)obj;
            w.resetFired();
        }
    }

    public void resolveCoreSystems() {
        if (!this.getOptions().getCoreSystems()) {
            return;
        }
        if (this.shipCommandBridge.getSystemStatus().equals("Damaged")) {
            this.shipCommandBridge.decrementTurnsDisabled();
        }
        if (this.shipLifeSupport.getSystemStatus().equals("Damaged")) {
            this.shipLifeSupport.decrementTurnsRemaining();
        }
        if (this.shipPowerCore.getSystemStatus().equals("Damaged") && Dice.rollD6() >= 5) {
            this.shipPowerCore.setDestroyed();
            int[] pCoreDamage = new int[]{2000};
            this.takeDamage(pCoreDamage);
        }
    }

    public boolean hasMissileSalvoThreat() {
        GameEngine engine = this.getGameEngine();
        ArrayList objectList = engine.getActiveObjects();
        int shipId = this.getId();
        for (int i = 0; i < objectList.size(); ++i) {
            MissileSalvo ms;
            SpaceObject so = (SpaceObject)objectList.get(i);
            if (!(so instanceof MissileSalvo) || (ms = (MissileSalvo)so).getTargetId() != shipId) continue;
            return true;
        }
        return false;
    }

    public boolean hasFighterThreat() {
        GameEngine engine = this.getGameEngine();
        ArrayList objectList = engine.getActiveObjects();
        int shipId = this.getId();
        for (int i = 0; i < objectList.size(); ++i) {
            SpaceObject so = (SpaceObject)objectList.get(i);
            if (!(so instanceof FighterGroup)) continue;
            FighterGroup fg = (FighterGroup)so;
            if (this.getTeam().equals(fg.getTeam()) || fg.getTargetId() != shipId) continue;
            return true;
        }
        return false;
    }

    public boolean hasBeams() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            BeamBattery beam;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof BeamBattery) || !(beam = (BeamBattery)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPulseTorps() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            PulseTorpedo pt;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof PulseTorpedo) || !(pt = (PulseTorpedo)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGrasers() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            Graser gr;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof Graser) || !(gr = (Graser)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAntiMatterTorpedos() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            AntiMatterTorpedoLauncher amtl;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof AntiMatterTorpedoLauncher) || !(amtl = (AntiMatterTorpedoLauncher)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasKineticGuns() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            KineticGun kg;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof KineticGun) || !(kg = (KineticGun)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSalvoMissiles() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        boolean hasLauncher = false;
        boolean hasAmmo = true;
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            SalvoMissileMagazine smm;
            SalvoMissileLauncher sml;
            SalvoMissileRack smr;
            Weapon w = (Weapon)iterator.next();
            if (w instanceof SalvoMissileRack && (smr = (SalvoMissileRack)w).isOperational()) {
                return true;
            }
            if (w instanceof SalvoMissileLauncher && (sml = (SalvoMissileLauncher)w).isOperational()) {
                hasLauncher = true;
            }
            if (!(w instanceof SalvoMissileMagazine) || !(smm = (SalvoMissileMagazine)w).isOperational() || !smm.isOneAvailable()) continue;
            hasAmmo = true;
        }
        return hasLauncher && hasAmmo;
    }

    public boolean hasPlasmaBolts() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            PlasmaBoltLauncher pbl;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof PlasmaBoltLauncher) || !(pbl = (PlasmaBoltLauncher)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNovaCannon() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            NovaCannon nc;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof NovaCannon) || !(nc = (NovaCannon)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFiredNovaCannon() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            NovaCannon nc;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof NovaCannon) || !(nc = (NovaCannon)w).isOperational() || !nc.hasFired()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLaunchedOrLandedFighters() {
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            FighterBay aBay;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof FighterBay) || !(aBay = (FighterBay)w).isOperational() || !aBay.isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean hasWaveGun() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            WaveGun wg;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof WaveGun) || !(wg = (WaveGun)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFiredWaveGun() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            WaveGun wg;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof WaveGun) || !(wg = (WaveGun)w).isOperational() || !wg.hasFired()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPulsers() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            Pulser p;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof Pulser) || !(p = (Pulser)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasVapourShroud() {
        ArrayList Defenses = this.getDefenseSystems();
        Iterator iterator = Defenses.iterator();
        while (iterator.hasNext()) {
            VapourShroud vp;
            Defense d = (Defense)iterator.next();
            if (!(d instanceof VapourShroud) || !(vp = (VapourShroud)d).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveVapourShroud() {
        ArrayList Defenses = this.getDefenseSystems();
        Iterator iterator = Defenses.iterator();
        while (iterator.hasNext()) {
            VapourShroud vp;
            Defense d = (Defense)iterator.next();
            if (!(d instanceof VapourShroud) || !(vp = (VapourShroud)d).isOperational() || !vp.isActive()) continue;
            return true;
        }
        return false;
    }

    public VapourShroud getVapourShroud() {
        ArrayList Defenses = this.getDefenseSystems();
        Iterator iterator = Defenses.iterator();
        while (iterator.hasNext()) {
            Defense d = (Defense)iterator.next();
            if (!(d instanceof VapourShroud)) continue;
            return (VapourShroud)d;
        }
        return null;
    }

    public boolean hasLaunchedWeapons() {
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            Weapon w = (Weapon)iterator.next();
            if (w instanceof MissileLauncher) {
                return true;
            }
            if (w instanceof SalvoMissileRack) {
                return true;
            }
            if (w instanceof SalvoMissileLauncher) {
                return true;
            }
            if (w instanceof PlasmaBoltLauncher) {
                return true;
            }
            if (w instanceof AntiMatterTorpedoLauncher) {
                return true;
            }
            if (w instanceof NovaCannon) {
                return true;
            }
            if (w instanceof WaveGun) {
                return true;
            }
            if (!(w instanceof FighterBay)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFighterBay() {
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof FighterBay) || !w.isOperational()) continue;
            return true;
        }
        return false;
    }

    public FighterBay getEmptyFighterBay() {
        FighterBay fb = null;
        Iterator iterator = this.getWeaponSystems().iterator();
        while (iterator.hasNext()) {
            FighterBay temp;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof FighterBay) || !w.isOperational() || (temp = (FighterBay)w).getLandedFighterGroup() != null) continue;
            fb = temp;
        }
        return fb;
    }

    public FighterBay getFighterBayForRecovery() {
        FighterBay fb = null;
        if (this.fighterBays < 0) {
            this.countFighterBays();
        }
        if (!this.hasOrders() && this.fighterRecoveries < this.fighterBays / 2 + this.fighterBays % 2 && (fb = this.getEmptyFighterBay()) != null) {
            ++this.fighterRecoveries;
        }
        return fb;
    }

    private void countFighterBays() {
        int n = 0;
        Iterator iterator = this.getWeaponSystems().iterator();
        while (iterator.hasNext()) {
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof FighterBay) || !w.isOperational()) continue;
            ++n;
        }
        this.fighterBays = n;
    }

    public void incrementRestrictedMovementLaunch() {
        ++this.countRestrictedMovementLaunches;
    }

    public void decrementRestrictedMovementLaunch() {
        --this.countRestrictedMovementLaunches;
    }

    public boolean isMovementRestrictedDueToLaunch() {
        return this.countRestrictedMovementLaunches > 0;
    }

    public boolean hasSubPacks() {
        int count = this.getNumberOfActiveFireControls();
        if (count == 0) {
            return false;
        }
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            SubmunitionPack sp;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof SubmunitionPack) || !(sp = (SubmunitionPack)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPointDefense() {
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            PointDefense pd;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof PointDefense) || !(pd = (PointDefense)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean hasScatterguns() {
        ArrayList Weapons = this.getWeaponSystems();
        Iterator iterator = Weapons.iterator();
        while (iterator.hasNext()) {
            Scattergun sg;
            Weapon w = (Weapon)iterator.next();
            if (!(w instanceof Scattergun) || !(sg = (Scattergun)w).isOperational()) continue;
            return true;
        }
        return false;
    }

    public void resetNotes() {
        ShipSystem s;
        int i;
        if (this.mainDriveSystem != null) {
            this.mainDriveSystem.resetNotes();
        }
        if (this.FTLDriveSystem != null) {
            this.FTLDriveSystem.resetNotes();
        }
        for (i = 0; i < this.electronicsSystems.size(); ++i) {
            s = (ShipSystem)this.electronicsSystems.get(i);
            s.resetNotes();
        }
        for (i = 0; i < this.defenseSystems.size(); ++i) {
            s = (ShipSystem)this.defenseSystems.get(i);
            s.resetNotes();
        }
        for (i = 0; i < this.shipHolds.size(); ++i) {
            s = (ShipSystem)this.shipHolds.get(i);
            s.resetNotes();
        }
        for (i = 0; i < this.weaponSystems.size(); ++i) {
            s = (ShipSystem)this.weaponSystems.get(i);
            s.resetNotes();
        }
        if (this.getOptions().getCoreSystems()) {
            this.shipCommandBridge.resetNotes();
            this.shipPowerCore.resetNotes();
            this.shipLifeSupport.resetNotes();
        }
    }

    public void resetFTLDrive() {
        if (this.FTLDriveSystem != null) {
            this.FTLDriveSystem.decrementRecharge();
        }
    }

    public String getAllNotes() {
        ShipSystem sys;
        int i;
        String s = "";
        String one = " ";
        s = s + one + "System & Weapons Results\n";
        if (this.mainDriveSystem != null && this.mainDriveSystem.anyNotes()) {
            s = s + one + "   " + this.mainDriveSystem.getSystemName() + " " + this.mainDriveSystem.getNotes() + "\n";
        }
        if (this.FTLDriveSystem != null && this.FTLDriveSystem.anyNotes()) {
            s = s + one + "   " + this.FTLDriveSystem.getSystemName() + " " + this.FTLDriveSystem.getNotes() + "\n";
        }
        for (i = 0; i < this.electronicsSystems.size(); ++i) {
            sys = (ShipSystem)this.electronicsSystems.get(i);
            if (!sys.anyNotes()) continue;
            s = s + one + "   " + sys.getSystemName() + " " + sys.getNotes() + "\n";
        }
        for (i = 0; i < this.defenseSystems.size(); ++i) {
            sys = (ShipSystem)this.defenseSystems.get(i);
            if (!sys.anyNotes()) continue;
            s = s + one + "   " + sys.getSystemName() + " " + sys.getNotes() + "\n";
        }
        for (i = 0; i < this.shipHolds.size(); ++i) {
            sys = (ShipSystem)this.shipHolds.get(i);
            if (!sys.anyNotes()) continue;
            s = s + one + "   " + sys.getSystemName() + " " + sys.getNotes() + "\n";
        }
        for (i = 0; i < this.weaponSystems.size(); ++i) {
            sys = (ShipSystem)this.weaponSystems.get(i);
            if (!sys.anyNotes()) continue;
            s = s + one + "   " + sys.getSystemName() + " " + sys.getNotes() + "\n";
        }
        return s;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.classAbbrev + " ");
        buffer.append(this.getName() + " ");
        return buffer.toString();
    }

    public String getTextSSD() {
        ShipSystem s;
        int i;
        boolean isVector;
        String result = "";
        String ten = "          ";
        String one = " ";
        String newLine = "\n";
        DecimalFormat df = new DecimalFormat("0.0");
        result = result + ten + ten + ten + ten + ten + "     " + newLine;
        result = result + one + this.classAbbrev + " " + this.getName() + newLine;
        result = result + one + this.race + " " + this.className + " class " + this.shipClass + newLine;
        result = result + one + "Status: " + this.evaluateShipStatus() + newLine;
        result = result + newLine;
        result = result + one + "Position: ";
        result = result + df.format(this.getXPosition()) + ", ";
        result = result + df.format(this.getYPosition()) + newLine;
        result = result + one + "Heading:  " + this.getHeading() + newLine;
        if (this.getRolled()) {
            result = result + one + "Rolled:   True" + newLine;
        }
        boolean bl = isVector = this.getVectorSpeed() >= 0.0;
        if (isVector) {
            result = result + one + "Course:   " + df.format(this.getVectorCourse()) + newLine;
            result = result + one + "Velocity: " + df.format(this.getVectorSpeed());
            result = result + newLine + newLine;
        } else {
            result = result + one + "Speed:    " + this.getSpeed() + newLine + newLine;
        }
        result = result + this.shipArmor + newLine;
        result = result + this.shipHull + newLine + newLine;
        if (this.mainDriveSystem != null) {
            result = result + this.mainDriveSystem + newLine;
        }
        if (this.FTLDriveSystem != null) {
            result = result + this.FTLDriveSystem + newLine + newLine;
        }
        for (i = 0; i < this.electronicsSystems.size(); ++i) {
            s = (ShipSystem)this.electronicsSystems.get(i);
            result = result + s + newLine;
        }
        for (i = 0; i < this.defenseSystems.size(); ++i) {
            s = (ShipSystem)this.defenseSystems.get(i);
            result = result + s + newLine;
        }
        for (i = 0; i < this.shipHolds.size(); ++i) {
            s = (ShipSystem)this.shipHolds.get(i);
            result = result + s + newLine;
        }
        for (i = 0; i < this.weaponSystems.size(); ++i) {
            s = (ShipSystem)this.weaponSystems.get(i);
            result = result + s + newLine;
        }
        if (this.getOptions().getCoreSystems()) {
            result = result + this.shipCommandBridge + newLine;
            result = result + this.shipLifeSupport + newLine;
            result = result + this.shipPowerCore + newLine;
        }
        return result;
    }

    public String logToString() {
        String s = "";
        String one = " ";
        ArrayList shipLog = null;
        LogRecord l = null;
        shipLog = this.getLog();
        s = s + one + "Ship's Log\n";
        if (shipLog.size() > 0) {
            for (int i = 0; i < shipLog.size(); ++i) {
                l = (LogRecord)shipLog.get(i);
                s = s + l;
                s = s + "\n";
            }
        }
        return s;
    }

    private String ind(int level) {
        if (level > 0) {
            return XMLUtilities.getIndent() + XMLUtilities.getIndent();
        }
        return "";
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        ArrayList shipLog;
        ShipSystem s;
        int i;
        GameEngine ge;
        int currentTurn;
        String t = XMLUtilities.getIndent();
        DecimalFormat df = new DecimalFormat("0.0");
        StringBuffer result = new StringBuffer(1024);
        String newLine = "\n";
        if (level == 10) {
            return result.toString();
        }
        if (level != 0 && (currentTurn = (ge = this.getGameEngine()).getGameTurn()) < this.getArrivalTurn() && level > 1) {
            return result.toString();
        }
        result.append(this.ind(level)).append("<Ship");
        if (level >= 1) {
            result.append(" id=\"");
            result.append(this.getId());
            if (level == 1 || this.hasArrivedThisTurn()) {
                result.append("\"");
                result.append(" arrivalTurn=\"");
                result.append(this.getArrivalTurn());
            }
            result.append("\">").append(newLine);
        } else {
            result.append(">").append(newLine);
        }
        if (level >= 0 && level <= 6) {
            result.append(this.ind(level)).append(t);
            result.append("<Name>");
            result.append(this.getName());
            result.append("</Name>").append(newLine);
            if (this.getIconFamily() != null) {
                result.append(this.ind(level)).append(t);
                result.append("<IconFamily value=\"");
                result.append(this.getIconFamily());
                result.append("\"/>").append(newLine);
            }
        } else if (level > 6 && level < 9) {
            result.append(this.ind(level)).append(t);
            result.append("<Name>Bogey ");
            result.append(this.getId());
            result.append("</Name>").append(newLine);
        } else if (level == 9) {
            result.append(this.ind(level)).append(t).append("<Name>Blip ");
            result.append(this.getId()).append("</Name>").append(newLine);
        }
        if (level >= 1 && level <= 4) {
            result.append(this.ind(level)).append(t);
            result.append("<Status>");
            result.append(this.evaluateShipStatus());
            result.append("</Status>").append(newLine);
        } else if (this.isDestroyed() || this.hasJumped() || this.hasStruck()) {
            result.append(this.ind(level)).append(t);
            result.append("<Status>");
            result.append(this.evaluateShipStatus());
            result.append("</Status>").append(newLine);
        }
        if (level >= 1 && level <= 8) {
            result.append(this.ind(level)).append(t);
            result.append("<Orders>");
            result.append(this.getOrders());
            result.append("</Orders>").append(newLine);
        }
        if (level >= 1 && level <= 4) {
            ArrayList ids = this.getDamageControlIds();
            if (ids.size() == 0) {
                result.append(this.ind(level)).append(t);
                result.append("<DamageControl/>").append(newLine);
            } else {
                result.append(this.ind(level)).append(t);
                result.append("<DamageControl ids=\"");
                for (i = 0; i < ids.size(); ++i) {
                    result.append(((Integer)ids.get(i)).toString());
                    if (i == ids.size() - 1) continue;
                    result.append(",");
                }
                result.append("\"/>").append(newLine);
            }
        }
        if (level >= 1) {
            result.append(this.ind(level)).append(t).append("<Position ");
            result.append("x=\"").append(df.format(this.getXPosition())).append("\" ");
            result.append("y=\"").append(df.format(this.getYPosition())).append("\" ");
            if (level < 9) {
                if (this.getPastHeading() != 13) {
                    result.append("pastX=\"").append(df.format(this.getPastX())).append("\" ");
                    result.append("pastY=\"").append(df.format(this.getPastY())).append("\" ");
                }
                if (this.getRolled() && this.getOptions().getShipRoll()) {
                    result.append("rolled=\"true\" ");
                }
            }
            result.append("/>").append(newLine);
        }
        if (level >= 1 && level < 9) {
            result.append(this.ind(level)).append(t).append("<Heading ");
            result.append("heading=\"").append(this.getHeading()).append("\" ");
            if (this.getPastHeading() != 13) {
                result.append("pastHeading=\"").append(this.getPastHeading()).append("\" ");
            }
            result.append("/>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<Speed speed=\"").append(this.getSpeed());
            result.append("\"/>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<VectorSpeed speed=\"");
            result.append(this.getVectorSpeed());
            result.append("\"/>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<Course course=\"");
            result.append(this.getCourse());
            result.append("\"/>").append(newLine).append(newLine);
        } else if (level == 9) {
            result.append(this.ind(level)).append(t);
            result.append("<Heading ");
            result.append("heading=\"0\"");
            result.append("/>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<Speed speed=\"0\"/>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<VectorSpeed");
            result.append(" speed=\"0.0\"/>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<Course");
            result.append(" course=\"0.0\"/>").append(newLine).append(newLine);
        }
        if (level >= 0 && level <= 5) {
            result.append(this.ind(level)).append(t);
            result.append("<Race>");
            result.append(this.getRace());
            result.append("</Race>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<ClassAbbrev>");
            result.append(this.getClassAbbrev());
            result.append("</ClassAbbrev>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<ClassName>");
            result.append(this.getClassName());
            result.append("</ClassName>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<ShipClass>");
            result.append(this.getShipClass());
            result.append("</ShipClass>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<CrewQuality>");
            result.append(this.getCrewQuality());
            result.append("</CrewQuality>").append(newLine);
        } else if (level == 6) {
            result.append(this.ind(level)).append(t);
            result.append("<Race>");
            result.append(this.getRace());
            result.append("</Race>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<ClassAbbrev>");
            result.append(this.getClassAbbrevBogey());
            result.append("</ClassAbbrev>").append(newLine);
        } else if (level == 7) {
            result.append(this.ind(level)).append(t);
            result.append("<ClassAbbrev>");
            result.append(this.getClassAbbrevBogey());
            result.append("</ClassAbbrev>").append(newLine);
        } else if (level == 8) {
            result.append(this.ind(level)).append(t);
            result.append("<ClassAbbrev>Bogey</ClassAbbrev>");
            result.append(newLine);
        } else if (level == 9) {
            result.append(this.ind(level)).append(t);
            result.append("<ClassAbbrev>Bogey</ClassAbbrev>").append(newLine);
        }
        if (level >= 0 && level <= 7) {
            result.append(this.ind(level)).append(t);
            result.append("<Mass>");
            int adjustedMass = (int)((double)this.getMass() * this.getMassStealthModifier());
            if (level == 7) {
                result.append(adjustedMass);
            } else {
                result.append(this.getMass());
            }
            result.append("</Mass>").append(newLine);
        }
        if (level >= 0 && level <= 5) {
            result.append(this.ind(level)).append(t);
            result.append("<PointValue>");
            result.append(this.getPointValue());
            result.append("</PointValue>").append(newLine);
        }
        if (level < 7) {
            if (this.mainDriveSystem != null) {
                result.append(this.ind(level)).append(this.mainDriveSystem.toXML(level));
            }
            if (this.FTLDriveSystem != null) {
                result.append(this.ind(level)).append(this.FTLDriveSystem.toXML(level));
            }
        }
        if (level < 6) {
            result.append(this.ind(level)).append(this.shipArmor.toXML(level));
        }
        if (this.isDestroyed() || this.hasStruck()) {
            result.append(this.ind(level));
            result.append(this.shipHull.toXML(4));
        } else {
            result.append(this.ind(level)).append(this.shipHull.toXML(level));
        }
        if (level <= 5) {
            result.append(this.ind(level)).append(t);
            result.append("<Electronics>").append(newLine);
            for (i = 0; i < this.electronicsSystems.size(); ++i) {
                s = (ShipSystem)this.electronicsSystems.get(i);
                result.append(this.ind(level)).append(s.toXML(level));
            }
            result.append(this.ind(level)).append(t);
            result.append("</Electronics>").append(newLine);
        }
        if (level <= 6) {
            result.append(this.ind(level)).append(t);
            result.append("<Defenses>").append(newLine);
            for (i = 0; i < this.defenseSystems.size(); ++i) {
                s = (ShipSystem)this.defenseSystems.get(i);
                result.append(this.ind(level)).append(s.toXML(level));
            }
            result.append(this.ind(level)).append(t);
            result.append("</Defenses>").append(newLine);
        }
        if (level <= 5) {
            result.append(this.ind(level)).append(t);
            result.append("<Holds>").append(newLine);
            for (i = 0; i < this.shipHolds.size(); ++i) {
                s = (ShipSystem)this.shipHolds.get(i);
                result.append(this.ind(level)).append(t);
                result.append(s.toXML(level));
            }
            result.append(this.ind(level)).append(t);
            result.append("</Holds>").append(newLine);
        }
        if (level <= 5) {
            result.append(this.ind(level)).append(t);
            result.append("<Weapons>").append(newLine);
            for (i = 0; i < this.weaponSystems.size(); ++i) {
                s = (ShipSystem)this.weaponSystems.get(i);
                result.append(this.ind(level)).append(s.toXML(level));
            }
            result.append(this.ind(level)).append(t);
            result.append("</Weapons>").append(newLine);
        }
        if (level != 0 && level <= 4 && this.getOptions().getCoreSystems()) {
            result.append(this.ind(level)).append(t);
            result.append(this.shipCommandBridge.toXML(level));
            result.append(newLine);
            result.append(this.ind(level)).append(t);
            result.append(this.shipLifeSupport.toXML(level));
            result.append(newLine);
            result.append(this.ind(level)).append(t);
            result.append(this.shipPowerCore.toXML(level));
            result.append(newLine);
        }
        if (level == 1 || level == 2 || level == 3) {
            ArrayList shipLog2 = this.getLog();
            if (shipLog2.size() > 0) {
                result.append(t).append(t).append(t);
                result.append("<Log>").append(newLine);
                for (i = 0; i < shipLog2.size(); ++i) {
                    LogRecord l = (LogRecord)shipLog2.get(i);
                    result.append(l.toXML(level));
                }
                result.append(t).append(t).append(t);
                result.append("</Log>").append(newLine);
            }
        } else if ((this.isDestroyed() || this.hasJumped() || this.hasStruck()) && (shipLog = this.getLog()).size() > 0) {
            result.append(t).append(t).append(t);
            result.append("<Log>").append(newLine);
            for (i = 0; i < shipLog.size(); ++i) {
                LogRecord l = (LogRecord)shipLog.get(i);
                if (l.getEvent().equals("Damage") && l.getPriority().equals("Critical") && l.getRecord().indexOf("destroyed") != -1) {
                    result.append(l.toXML(2));
                }
                if (l.getEvent().equals("Status") && l.getPriority().equals("High") && l.getRecord().indexOf(JUMPED) != -1) {
                    result.append(l.toXML(2));
                }
                if (!l.getEvent().equals("Status") || !l.getPriority().equals("High") || l.getRecord().indexOf(STRIKE) == -1) continue;
                result.append(l.toXML(2));
            }
            result.append(t).append(t).append(t);
            result.append("</Log>").append(newLine);
        }
        result.append(this.ind(level)).append("</Ship>").append(newLine);
        return result.toString();
    }

    public String movementOrdersToXML() {
        int i;
        StringBuffer result = new StringBuffer(128);
        String newLine = "\n";
        String t = XMLUtilities.getIndent();
        result.append(t).append(t);
        result.append("<ShipOrders");
        result.append(" id=\"");
        result.append(this.getId()).append("\">").append(newLine);
        result.append(t).append(t).append(t);
        result.append("<Orders>");
        result.append(this.getOrders());
        result.append("</Orders>").append(newLine);
        ArrayList ids = this.getDamageControlIds();
        if (ids.size() == 0) {
            result.append(t).append(t).append(t);
            result.append("<DamageControl/>").append(newLine);
        } else {
            result.append(t).append(t).append(t);
            result.append("<DamageControl ids=\"");
            for (i = 0; i < ids.size(); ++i) {
                result.append(((Integer)ids.get(i)).toString());
                if (i == ids.size() - 1) continue;
                result.append(",");
            }
            result.append("\"/>").append(newLine);
        }
        if (this.hasVapourShroud()) {
            result.append(t).append(t).append(t);
            result.append("<Defenses>").append(newLine);
            for (i = 0; i < this.defenseSystems.size(); ++i) {
                ShipSystem s = (ShipSystem)this.defenseSystems.get(i);
                if (!(s instanceof VapourShroud)) continue;
                result.append(t).append(t).append(t);
                result.append(s.toXML(1));
            }
            result.append(t).append(t).append(t);
            result.append("</Defenses>").append(newLine);
        }
        result.append(t).append(t);
        result.append("</ShipOrders>").append(newLine);
        return result.toString();
    }

    public String combatOrdersToXML() {
        ShipSystem s;
        int i;
        StringBuffer result = new StringBuffer(512);
        String newLine = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        result.append(t).append(t);
        result.append("<ShipOrders");
        result.append(" id=\"").append(this.getId());
        result.append("\">").append(newLine);
        result.append(t).append(t).append(t);
        result.append("<Electronics>").append(newLine);
        for (i = 0; i < this.electronicsSystems.size(); ++i) {
            s = (ShipSystem)this.electronicsSystems.get(i);
            if (!(s instanceof FireControl) && !(s instanceof AreaDefenseFireControl)) continue;
            result.append(t).append(t).append(t);
            result.append(s.toXML(1));
        }
        result.append(t).append(t).append(t);
        result.append("</Electronics>").append(newLine);
        if (this.hasVapourShroud()) {
            result.append(t).append(t).append(t);
            result.append("<Defenses>").append(newLine);
            for (i = 0; i < this.defenseSystems.size(); ++i) {
                s = (ShipSystem)this.defenseSystems.get(i);
                if (!(s instanceof VapourShroud)) continue;
                result.append(t).append(t).append(t);
                result.append(s.toXML(1));
            }
            result.append(t).append(t).append(t);
            result.append("</Defenses>").append(newLine);
        }
        result.append(t).append(t).append(t);
        result.append("<Weapons>").append(newLine);
        for (i = 0; i < this.weaponSystems.size(); ++i) {
            Pulser pr;
            KineticGun kg;
            BeamBattery bb;
            s = (ShipSystem)this.weaponSystems.get(i);
            boolean pds = false;
            if (s instanceof PointDefense) {
                pds = true;
            }
            if (s instanceof Scattergun) {
                pds = true;
            }
            if (s instanceof BeamBattery && (bb = (BeamBattery)s).getRating() == 1 && bb.getTargetId() != 0) {
                pds = true;
            }
            if (s instanceof KineticGun && (kg = (KineticGun)s).getRating() == 1 && kg.getTargetId() != 0) {
                pds = true;
            }
            if (s instanceof Pulser && (pr = (Pulser)s).getTargetId() != 0) {
                pds = true;
            }
            if (!pds) continue;
            result.append(t).append(t).append(t);
            result.append(s.toXML(1));
        }
        result.append(t).append(t).append(t);
        result.append("</Weapons>").append(newLine);
        result.append(t).append(t);
        result.append("</ShipOrders>").append(newLine);
        return result.toString();
    }
}

