/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.GameEngine;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;

public class PulseTorpedo
extends Weapon {
    public PulseTorpedo() {
        this(Weapon.FORE_ARC);
    }

    public PulseTorpedo(String arcString) {
        this(Weapon.parseArcString(arcString));
    }

    public PulseTorpedo(int a) {
        if (!this.getOptions().getAftArcFire() && a == Weapon.AFT_ARC) {
            a = Weapon.FORE_ARC;
        }
        this.setArcs(a);
        this.setSystemName("Pulse Torpedo Launcher " + this.getArcsString());
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setMaximumRange(5.0 * this.getOptions().getPulseTorpedoRangeBand());
    }

    public void setValue(String Name, String Value) {
        if (Name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(Value));
            this.setSystemName("Pulse Torpedo Launcher " + this.getArcsString());
        } else {
            super.setValue(Name, Value);
        }
    }

    public double getRangeBand() {
        return this.getOptions().getPulseTorpedoRangeBand();
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
        String record;
        int[] damageArray;
        DecimalFormat df = new DecimalFormat("0.0");
        if (!this.isRecharged()) {
            this.setNotes("Weapon is recharging.");
            return;
        }
        if (!this.getSystemStatus().equals("Operational")) {
            return;
        }
        if (!(target instanceof Ship)) {
            return;
        }
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        double rangeBand = this.getRangeBand();
        if (!this.fireAtTargetArc(firer.arcTo(target))) {
            this.setNotes("Target is out of arc.");
            return;
        }
        if (firer.rangeTo(target) > this.getMaximumRange()) {
            return;
        }
        this.setFired();
        int die = Dice.rollD6(firer.getCrewQuality());
        boolean hit = false;
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range) + " (" + die + ")";
        if (die == 1) {
            hit = false;
        }
        if (die == 6 && range <= 5.0 * rangeBand) {
            hit = true;
        }
        if (die >= 5 && range <= 4.0 * rangeBand) {
            hit = true;
        }
        if (die >= 4 && range <= 3.0 * rangeBand) {
            hit = true;
        }
        if (die >= 3 && range <= 2.0 * rangeBand) {
            hit = true;
        }
        if (die >= 2 && range <= rangeBand) {
            hit = true;
        }
        String targetName = target.getName();
        if (!hit) {
            String record2;
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed the " + targetName + ". " + playTestResults);
                record2 = firer.getName() + " missed with a pulse torpedo. " + playTestResults;
            } else {
                this.setNotes("Missed the " + targetName + ".");
                record2 = firer.getName() + " missed with a pulse torpedo.";
            }
            target.addLog("Attack", "Medium", record2);
            return;
        }
        int damage = Dice.rollD6();
        playTestResults = playTestResults + "(" + damage + ") ";
        damageArray = new int[]{(int)Math.ceil((double)damage / 2.0), damage - damageArray[0]};
        if (this.getOptions().getPlayTest()) {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.number(damageArray[0]) + " armor and " + StringUtils.number(damageArray[1]) + " hull points. " + playTestResults);
            record = firer.getName() + " hit for " + StringUtils.points(damage) + " with a pulse torpedo. " + playTestResults;
        } else {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.points(damage) + ".");
            record = firer.getName() + " hit for " + StringUtils.points(damage) + " with a pulse torpedo.";
        }
        target.addLog("Attack", "High", record);
        if (damage >= 6) {
            GameEngine ge = firer.getGameEngine();
            record = firer.getName() + " hit " + target.getName() + " for " + StringUtils.points(damage) + " with a pulse torpedo.";
            ge.addTurnReport("Attack", "High", record);
        }
        Ship s = (Ship)target;
        s.takeDamage(damageArray);
    }

    public int computeMass() {
        int mass = 4;
        int count = this.computeNumberOfArcs();
        if (count > 1) {
            mass = 4 + (count - 1);
        }
        return mass;
    }

    public int computePointCost() {
        return 3 * this.computeMass();
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String s = "";
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        if (level >= 6) {
            return s;
        }
        sb.append(t);
        sb.append(t);
        sb.append("<PulseTorpedo ");
        if (level > 0) {
            sb.append("id=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" arcs=\"");
        sb.append(this.getArcsString());
        sb.append("\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"");
            sb.append(this.getSystemStatus());
            sb.append("\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        sb.append(sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("PulseTorpedo", new PulseTorpedo());
    }
}

