/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.Missile;
import ftjava.std.MissileSalvo;
import ftjava.std.PlasmaBolt;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.ShipUtilities;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;

public class PointDefense
extends Weapon {
    public PointDefense() {
        this.setSystemName("Point Defense System");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setMaximumRange(this.getOptions().getPointDefenseRange());
        this.setFireTypePointDefense();
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("targetId")) {
            this.setTargetId(Integer.parseInt(Value));
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
        FighterGroup fighters;
        DecimalFormat df = new DecimalFormat("0.0");
        if (target == null) {
            return;
        }
        int rerolls = 0;
        int kills = 0;
        int plasmaHits = 0;
        double rangeBand = this.getOptions().getPointDefenseRange();
        boolean hit = false;
        if (!(target instanceof MissileSalvo || target instanceof Missile || target instanceof FighterGroup || target instanceof PlasmaBolt || target instanceof AntiMatterTorpedo || target instanceof Ship)) {
            return;
        }
        if (!this.isRecharged()) {
            this.setNotes("Weapon is recharging.");
            return;
        }
        if (!this.getSystemStatus().equals("Operational")) {
            return;
        }
        if (!ShipUtilities.isPDSTarget((Ship)firer, target, rangeBand)) {
            return;
        }
        this.setFired();
        String targetName = target.getName();
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range);
        if (target instanceof Ship) {
            String record;
            int die = Dice.rollD6(firer.getCrewQuality());
            playTestResults = playTestResults + "(" + die + ") ";
            if (die == 6) {
                hit = true;
            }
            if (!hit) {
                String record2;
                if (this.getOptions().getPlayTest()) {
                    this.setNotes("Missed the " + targetName + "." + playTestResults);
                    record2 = firer.getName() + " missed with a point defense system." + playTestResults;
                } else {
                    this.setNotes("Missed the " + targetName + ".");
                    record2 = firer.getName() + " missed with a point defense system.";
                }
                target.addLog("Attack", "Medium", record2);
                return;
            }
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Hit the " + targetName + " for one point." + playTestResults);
                record = firer.getName() + " hit for one point with a point defense system." + playTestResults;
            } else {
                this.setNotes("Hit the " + targetName + " for one point.");
                record = firer.getName() + " hit for one point with a point defense system.";
            }
            target.addLog("Attack", "Medium", record);
            Ship s = (Ship)target;
            s.takeDamage(new int[]{1});
            return;
        }
        int die = Dice.rollD6(firer.getCrewQuality());
        playTestResults = playTestResults + "(" + die + ") ";
        boolean isHeavyFighter = false;
        if (target instanceof FighterGroup && (fighters = (FighterGroup)target).getType().isAHeavyFighter()) {
            isHeavyFighter = true;
        }
        switch (die) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                if (isHeavyFighter) break;
            }
            case 5: {
                ++kills;
                hit = true;
                break;
            }
            case 6: {
                kills += 2;
                ++plasmaHits;
                hit = true;
                ++rerolls;
            }
        }
        if (this.getOptions().getPenetratingDamage()) {
            while (rerolls > 0) {
                --rerolls;
                die = Dice.rollD6(firer.getCrewQuality());
                playTestResults = playTestResults + "(" + die + ") ";
                switch (die) {
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        if (isHeavyFighter) break;
                    }
                    case 5: {
                        ++kills;
                        break;
                    }
                    case 6: {
                        kills += 2;
                        ++rerolls;
                    }
                }
            }
        }
        if ((target instanceof PlasmaBolt || target instanceof AntiMatterTorpedo || target instanceof Missile) && plasmaHits == 0) {
            hit = false;
        }
        if (!hit) {
            this.setNotes("Missed " + targetName + ".");
            if (this.getOptions().getPlayTest()) {
                this.appendNotes(playTestResults);
            }
            if (target instanceof FighterGroup) {
                target.addLog("Status", "Low", firer.getName() + " missed with " + "a Point Defense.");
            }
            return;
        }
        if (target instanceof PlasmaBolt || target instanceof AntiMatterTorpedo || target instanceof Missile) {
            this.setNotes("Hit " + targetName + " for " + StringUtils.points(plasmaHits) + ".");
        } else {
            if (target instanceof FighterGroup) {
                target.addLog("Attack", "High", firer.getName() + " hit for " + StringUtils.kills(kills) + " with a Point Defense.");
            }
            this.setNotes("Hit " + targetName + " for " + StringUtils.kills(kills) + ".");
        }
        if (this.getOptions().getPlayTest()) {
            this.appendNotes(playTestResults);
        }
        if (target instanceof MissileSalvo) {
            MissileSalvo ms = (MissileSalvo)target;
            ms.takeDamage(new int[]{kills});
        }
        if (target instanceof FighterGroup) {
            FighterGroup fg = (FighterGroup)target;
            fg.takeDamage(new int[]{kills});
        }
        if (target instanceof PlasmaBolt || target instanceof AntiMatterTorpedo || target instanceof Missile) {
            target.takeDamage(new int[]{plasmaHits});
        }
    }

    public int computeMass() {
        return 1;
    }

    public int computePointCost() {
        return 3;
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t);
        sb.append(t);
        sb.append("<PointDefense");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        if (level == 2 || level == 1) {
            sb.append(" targetId=\"" + this.getTargetId() + "\"");
        }
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>");
        sb.append(sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("PointDefense", new PointDefense());
    }
}

