/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.PlasmaBolt;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;

public class PlasmaBoltLauncher
extends Weapon {
    private int rating;

    public PlasmaBoltLauncher() {
        this(1, Weapon.FRONT_ARCS);
    }

    public PlasmaBoltLauncher(int rating, String arcString) {
        this(rating, Weapon.parseArcString(arcString));
    }

    public PlasmaBoltLauncher(int r, int a) {
        this.setRating(r);
        this.setArcs(a);
        this.setFireRate(2);
        this.setSystemName("Class " + r + " Plasma Bolt Launcher " + this.getArcsString());
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setFireTypeLaunched();
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(Value));
            handled = true;
        }
        if (Name.equals("rating")) {
            this.setRating(Integer.valueOf(Value));
            handled = true;
        }
        if (Name.equals("recharge")) {
            this.setRecharge(Integer.valueOf(Value));
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        } else {
            this.setSystemName("Class " + this.getRating() + " Plasma Bolt Launcher " + this.getArcsString());
        }
    }

    public void setRating(int r) {
        this.rating = r;
    }

    public int getRating() {
        return this.rating;
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
    }

    public boolean canLaunch(SpaceObject firer, PlasmaBolt pb) {
        if (!this.getSystemStatus().equals("Operational")) {
            return false;
        }
        if (this.hasFired()) {
            return false;
        }
        double range = firer.rangeTo(pb);
        if (range > this.getOptions().getPlasmaBoltRange()) {
            return false;
        }
        if (!this.fireAtTargetArc(firer.arcTo(pb))) {
            return false;
        }
        return this.isRecharged();
    }

    public void fireBolt(SpaceObject firer, PlasmaBolt pb) {
        this.setFired();
    }

    public int computeMass() {
        return 5 * this.rating;
    }

    public int computePointCost() {
        return 15 * this.rating;
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<PlasmaBoltLauncher");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" rating=\"");
        sb.append(this.rating);
        sb.append("\" arcs=\"");
        sb.append(this.getArcsString());
        sb.append("\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            sb.append(" recharge=\"" + this.getRecharge() + "\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("PlasmaBoltLauncher", new PlasmaBoltLauncher());
    }
}

