/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.MissileSalvo;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;

public class PlasmaBolt
extends SpaceObject {
    private String team = "";
    private int strength = 1;
    private int launchingShipId = 0;
    private int launcherId = 0;
    private boolean hasAttacked = false;

    public void setName() {
        this.setName("PB-" + this.getStrength() + " " + this.getId());
    }

    public void setTeam(String s) {
        this.team = s;
    }

    public String getTeam() {
        return this.team;
    }

    public void setStrength(int s) {
        this.strength = s;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setLaunchingShipId(int id) {
        this.launchingShipId = id;
    }

    public int getLaunchingShipId() {
        return this.launchingShipId;
    }

    public void setLauncherId(int id) {
        this.launcherId = id;
    }

    public int getLauncherId() {
        return this.launcherId;
    }

    public void setHasAttacked(boolean b) {
        this.hasAttacked = b;
    }

    public boolean hasAttacked() {
        return this.hasAttacked;
    }

    private Ship getLaunchingShip() {
        return this.getGameEngine().getShipById(this.launchingShipId);
    }

    private Weapon getLauncher() {
        Ship s = this.getLaunchingShip();
        if (s == null) {
            return null;
        }
        return s.getWeaponById(this.launcherId);
    }

    public double getMaximumRange() {
        return this.getOptions().getPlasmaBoltRange();
    }

    public void takeDamage(int[] hits) {
        for (int i = 0; i < hits.length; ++i) {
            this.strength -= hits[i];
        }
        if (this.strength < 0) {
            this.strength = 0;
        }
    }

    public void fireAt() {
        String playTestResults = "";
        Weapon launcher = this.getLauncher();
        this.setHasAttacked(true);
        if (this.getStrength() == 0) {
            launcher.setNotes("Plasma bolt was intercepted.");
            return;
        }
        double blastRadius = this.getOptions().getPlasmaBoltBlastRange();
        int[] damage = new int[1];
        GameEngine game = this.getGameEngine();
        ArrayList allObjects = game.getActiveObjects();
        for (int i = 0; i < allObjects.size(); ++i) {
            SpaceObject so = (SpaceObject)allObjects.get(i);
            int screenLevel = 0;
            if (so instanceof PlasmaBolt || so instanceof AntiMatterTorpedo || this.rangeTo(so) > blastRadius) continue;
            if (so.isShip()) {
                Ship s = (Ship)so;
                if (s.isDestroyed() || s.hasJumped() || !s.hasArrived()) continue;
                screenLevel = ((Ship)so).getNumberOfActiveScreens();
            }
            if (so instanceof FighterGroup) {
                if (((FighterGroup)so).isOnBoard()) continue;
                FighterGroup fg = (FighterGroup)so;
                if (fg.getType().isAHeavyFighter()) {
                    screenLevel = 1;
                }
            }
            damage[0] = 0;
            playTestResults = "";
            block6: for (int j = 0; j < this.strength; ++j) {
                int die = Dice.rollD6();
                playTestResults = playTestResults + "(" + die + ") ";
                switch (die) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        damage[0] = damage[0] + die;
                        continue block6;
                    }
                    case 5: {
                        if (screenLevel < 2) {
                            damage[0] = damage[0] + die;
                            continue block6;
                        }
                    }
                    case 6: {
                        if (screenLevel >= 1) continue block6;
                        damage[0] = damage[0] + die;
                    }
                }
            }
            String record = this.getName() + ": Plasma bolt hit for " + StringUtils.points(damage[0]) + ".";
            String report = this.getName() + " hit " + so.getName() + " for " + StringUtils.points(damage[0]) + ".";
            if (this.getOptions().getPlayTest()) {
                record = record + " " + playTestResults;
                report = report + " " + playTestResults;
            }
            game.addTurnReport("Attack", "High", report);
            if (so instanceof MissileSalvo) {
                ((MissileSalvo)so).takeDamage(damage);
            }
            if (so instanceof FighterGroup) {
                ((FighterGroup)so).takeDamage(damage);
            }
            if (!so.isShip()) continue;
            ((Ship)so).takeDamage(damage);
            so.addLog("Attack", "High", record);
        }
    }

    public String toString() {
        String result = "";
        String newLine = System.getProperty("line.separator");
        DecimalFormat df = new DecimalFormat("0.0");
        result = result + this.getRace() + " plasma bolt" + newLine;
        result = result + "Strength:  " + this.strength + newLine;
        result = result + newLine;
        result = result + "Position: ";
        result = result + df.format(this.getXPosition()) + ", ";
        result = result + df.format(this.getYPosition()) + newLine;
        return result;
    }

    private String ind(int level) {
        if (level > 0) {
            return XMLUtilities.getIndent() + XMLUtilities.getIndent();
        }
        return "";
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String s = "";
        String sep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("0.0");
        df.setDecimalFormatSymbols(dfs);
        if (level == 10) {
            return s;
        }
        sb.append(this.ind(level) + "<PlasmaBolt");
        if (level >= 1) {
            sb.append(" id=\"" + this.getId() + "\">" + sep);
        } else {
            sb.append(">" + sep);
        }
        if (level >= 1) {
            sb.append(this.ind(level) + t);
            sb.append("<Strength>" + this.getStrength() + "</Strength>" + sep);
            sb.append(this.ind(level) + t + "<Position ");
            sb.append("x=\"" + df.format(this.getXPosition()) + "\" ");
            sb.append("y=\"" + df.format(this.getYPosition()) + "\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Heading heading=\"" + this.getHeading() + "\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Race>" + this.getRace() + "</Race>" + sep);
            if (this.getIconFamily() != null) {
                sb.append(this.ind(level)).append(t);
                sb.append("<IconFamily value=\"");
                sb.append(this.getIconFamily());
                sb.append("\"/>").append(sep);
            }
            sb.append(this.ind(level) + t);
            sb.append("<Ship id=\"" + this.getLaunchingShipId());
            sb.append("\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Launcher id=\"" + this.getLauncherId());
            sb.append("\"/>" + sep);
        }
        sb.append(this.ind(level) + "</PlasmaBolt>" + sep);
        return sb.toString();
    }

    public String movementOrdersToXML() {
        StringBuffer sb = new StringBuffer();
        String sep = "\n";
        String t = XMLUtilities.getIndent();
        Ship s = this.getLaunchingShip();
        if (s.hasActiveVapourShroud()) {
            return "";
        }
        sb.append(t + t + "<LaunchBolt ");
        sb.append("shipId=\"" + this.getLaunchingShipId() + "\" ");
        sb.append("launcherId=\"" + this.getLauncherId() + "\" ");
        sb.append("x=\"" + this.getXPosition() + "\" ");
        sb.append("y=\"" + this.getYPosition() + "\" ");
        sb.append("heading=\"" + this.getHeading() + "\" ");
        sb.append("strength=\"" + this.getStrength() + "\"/>");
        sb.append(sep);
        return sb.toString();
    }
}

