/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;

public class MultipleKineticPenetratorPack
extends Weapon {
    public MultipleKineticPenetratorPack() {
        this(Weapon.FORE_ARC);
    }

    public MultipleKineticPenetratorPack(String arcString) {
        this(Weapon.parseArcString(arcString));
    }

    public MultipleKineticPenetratorPack(int a) {
        this.setArcs(a);
        this.setSystemName("Multiple Kinetic Penetrator Pack " + this.getArcsString());
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setMaximumRange(this.getOptions().getMultipleKineticPenetratorPackRange());
    }

    public void setValue(String Name, String Value) {
        if (Name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(Value));
            this.setSystemName("Multiple Kinetic Penetrator Pack " + this.getArcsString());
        } else {
            super.setValue(Name, Value);
        }
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
        String record;
        int[] damage = new int[2];
        DecimalFormat df = new DecimalFormat("0.0");
        damage[0] = 0;
        damage[1] = 0;
        double rangeBand = this.getOptions().getMultipleKineticPenetratorPackRange();
        if (!this.getSystemStatus().equals("Operational")) {
            return;
        }
        if (!(target instanceof Ship)) {
            return;
        }
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        if (!this.fireAtTargetArc(firer.arcTo(target))) {
            return;
        }
        this.setFired();
        this.setExpended();
        String targetName = target.getName();
        boolean hit = false;
        int die = Dice.rollD6(firer.getCrewQuality());
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range) + " (" + die + ") ";
        if (range < rangeBand) {
            switch (die) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    damage[0] = damage[0] + 1;
                    damage[1] = damage[1] + 3;
                    hit = true;
                    break;
                }
                case 6: {
                    damage[0] = damage[0] + 2;
                    damage[1] = damage[1] + 6;
                    hit = true;
                }
            }
        }
        if (!hit) {
            String record2;
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed the " + targetName + "." + playTestResults);
                record2 = firer.getName() + " missed with a multiple kinetic" + " penetrator pack." + playTestResults;
            } else {
                this.setNotes("Missed the " + targetName + ".");
                record2 = firer.getName() + " missed with a multiple kinetic" + " penetrator pack.";
            }
            target.addLog("Attack", "Medium", record2);
            return;
        }
        int totalDamage = damage[0] + damage[1];
        if (this.getOptions().getPlayTest()) {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.points(totalDamage) + playTestResults);
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a multiple kinetic penetrator pack." + playTestResults;
        } else {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.number(totalDamage) + " points.");
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a multiple kinetic penetrator pack.";
        }
        target.addLog("Attack", "High", record);
        Ship s = (Ship)target;
        s.takeDamage(damage);
    }

    public int computeMass() {
        return 1;
    }

    public int computePointCost() {
        return 4;
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<MultipleKineticPenetratorPack");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" arcs=\"" + this.getArcsString() + "\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("MultipleKineticPenetratorPack", new MultipleKineticPenetratorPack());
    }
}

