/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.GameEngine;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;

public class Graser
extends Weapon {
    private int rating;

    public Graser() {
        this(1, Weapon.FORE_ARC);
    }

    public Graser(int graserClass, int arcCoverage) {
        this.rating = graserClass;
        this.setArcs(arcCoverage);
        this.setSystemName("Class " + this.rating + " Graser " + this.getArcsString());
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setMaximumRange((double)this.rating * this.getOptions().getGraserRangeBand());
    }

    public Graser(int graserClass, String arcString) {
        this.rating = graserClass;
        this.setArcs(Weapon.parseArcString(arcString));
        this.setSystemName("Class " + this.rating + " Graser " + this.getArcsString());
        this.setMaximumRange((double)this.rating * this.getOptions().getGraserRangeBand());
    }

    public int getRating() {
        return this.rating;
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("rating")) {
            this.rating = Integer.parseInt(Value);
            this.setMaximumRange((double)this.rating * this.getOptions().getGraserRangeBand());
            handled = true;
        }
        this.setSystemName("Class " + this.rating + " Graser " + this.getArcsString());
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
        String record;
        int die;
        int i;
        Ship s;
        double rangeBand = this.getOptions().getGraserRangeBand();
        if (!this.isRecharged()) {
            this.setNotes("Weapon is recharging.");
            return;
        }
        if (!this.getSystemStatus().equals("Operational")) {
            return;
        }
        if (!(target instanceof Ship)) {
            return;
        }
        if (!this.fireAtTargetArc(firer.arcTo(target))) {
            return;
        }
        int[] damage = new int[2];
        DecimalFormat df = new DecimalFormat("0.0");
        int hits = 0;
        int rerolls = 0;
        int screens = 0;
        int totalDamage = 0;
        int armorDamage = 0;
        int hullDamage = 0;
        if (target instanceof Ship) {
            s = (Ship)target;
            screens = s.getNumberOfActiveScreens();
        }
        int dice = this.rating;
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        for (int i2 = 1; i2 <= this.rating; ++i2) {
            if (!(range > (double)i2 * rangeBand)) continue;
            --dice;
        }
        if (firer.rangeTo(target) > this.getMaximumRange()) {
            return;
        }
        if (range > this.getMaximumRange()) {
            dice = 0;
        }
        String targetName = target.getName();
        this.setFired();
        boolean hit = false;
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range) + " ";
        block12: for (i = 0; i < dice; ++i) {
            die = Dice.rollD6(firer.getCrewQuality());
            playTestResults = playTestResults + "(" + die + ") ";
            switch (die) {
                case 1: 
                case 2: 
                case 3: {
                    continue block12;
                }
                case 4: {
                    if (screens != 0) continue block12;
                    ++hits;
                    hit = true;
                    continue block12;
                }
                case 5: {
                    ++hits;
                    hit = true;
                    continue block12;
                }
                case 6: {
                    hits = screens == 2 ? ++hits : (hits += 2);
                    hit = true;
                    continue block12;
                }
            }
        }
        if (this.getOptions().getPenetratingDamage()) {
            int rerollDamageIndex = 0;
            int nextRerollCount = rerolls;
            while (nextRerollCount > 0) {
                rerolls = nextRerollCount;
                nextRerollCount = 0;
                ++rerollDamageIndex;
                block14: for (i = 0; i < rerolls; ++i) {
                    die = Dice.rollD6(firer.getCrewQuality());
                    playTestResults = playTestResults + "(" + die + "*) ";
                    switch (die) {
                        case 1: 
                        case 2: 
                        case 3: {
                            continue block14;
                        }
                        case 4: 
                        case 5: {
                            ++hits;
                            continue block14;
                        }
                        case 6: {
                            hits += 2;
                            ++nextRerollCount;
                            continue block14;
                        }
                    }
                }
            }
        }
        if (!hit) {
            String record2;
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed the " + targetName + ". " + playTestResults);
                record2 = firer.getName() + " missed with a class " + this.getRating() + " graser. " + playTestResults;
            } else {
                this.setNotes("Missed the " + targetName + ".");
                record2 = firer.getName() + " missed with a class " + this.getRating() + " graser.";
            }
            target.addLog("Attack", "Medium", record2);
            return;
        }
        for (i = 0; i < hits; ++i) {
            totalDamage += Dice.rollD6();
        }
        armorDamage = (totalDamage + 1) / 2;
        hullDamage = totalDamage - armorDamage;
        damage[0] = armorDamage;
        damage[1] = hullDamage;
        if (this.getOptions().getPlayTest()) {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.number(armorDamage) + " armor and " + StringUtils.number(hullDamage) + " hull points. " + playTestResults);
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a class " + this.getRating() + " graser. " + playTestResults;
        } else {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.points(totalDamage) + ".");
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a class " + this.getRating() + " graser.";
        }
        target.addLog("Attack", "High", record);
        if (totalDamage >= 3 * this.rating) {
            GameEngine ge = firer.getGameEngine();
            record = firer.getName() + " hit " + target.getName() + " for " + StringUtils.points(totalDamage) + " with a class " + this.getRating() + " graser.";
            ge.addTurnReport("Attack", "High", record);
        }
        s = (Ship)target;
        s.takeDamage(damage);
    }

    public int computeMass() {
        int count = this.computeNumberOfArcs();
        if (this.rating == 1 && count == 1) {
            return 2;
        }
        if (this.rating == 1 && count <= 3) {
            return 3;
        }
        if (this.rating == 1 && count <= 6) {
            return 4;
        }
        if (this.rating == 2) {
            return 9 + 3 * (count - 1);
        }
        if (this.rating == 3) {
            return 24 + 6 * (count - 1);
        }
        return 0;
    }

    public int computePointCost() {
        return 4 * this.computeMass();
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String s = "";
        String t = XMLUtilities.getIndent();
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return s;
        }
        sb.append(t);
        sb.append(t);
        sb.append("<Graser ");
        if (level > 0) {
            sb.append(" id=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" rating=\"");
        sb.append(this.rating);
        sb.append("\" arcs=\"");
        sb.append(this.getArcsString());
        sb.append("\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"");
            sb.append(this.getSystemStatus());
            sb.append("\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        sb.append(newLine);
        return sb.toString();
    }

    static {
        Weapon.addSystem("Graser", new Graser());
    }
}

