/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.Electronics;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class FireControl
extends Electronics {
    private SpaceObject target;
    private int targetId;
    private HashSet slavedWeapons;
    private ArrayList slavedWeaponsIds;

    public FireControl() {
        this.setSystemName("Fire Control");
        this.target = null;
        this.targetId = 0;
        this.slavedWeapons = null;
        this.slavedWeaponsIds = null;
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
    }

    public HashSet getSlavedWeapons() {
        return this.slavedWeapons;
    }

    public void slaveWeapon(Weapon w) {
        if (this.slavedWeapons == null) {
            this.slavedWeapons = new HashSet();
        }
        w.setMasterFireControl(this);
        this.slavedWeapons.add(w);
    }

    public void unslaveAllWeapons() {
        if (this.slavedWeapons == null) {
            return;
        }
        Iterator Weapons = this.getSlavedWeapons().iterator();
        while (Weapons.hasNext()) {
            Weapon w = (Weapon)Weapons.next();
            w.setMasterFireControl(null);
        }
        this.slavedWeapons = null;
        this.slavedWeaponsIds = null;
    }

    public void prepareForFTL() {
        this.setTargetId(0);
    }

    public ArrayList getSlavedWeaponsIds() {
        return this.slavedWeaponsIds;
    }

    public void setTarget(SpaceObject t) {
        this.target = t;
        if (t != null) {
            this.setTargetId(t.getId());
        } else {
            this.setTargetId(0);
        }
    }

    public SpaceObject getTarget() {
        return this.target;
    }

    public void setTargetId(int t) {
        this.targetId = t;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public int computeMass() {
        return 1;
    }

    public int computePointCost() {
        return 4;
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("targetId")) {
            this.setTargetId(Integer.parseInt(Value));
            handled = true;
        }
        if (Name.equals("slavedWeapons")) {
            StringTokenizer st = new StringTokenizer(Value, ",");
            if (this.slavedWeaponsIds == null) {
                this.slavedWeaponsIds = new ArrayList();
            }
            while (st.hasMoreTokens()) {
                String id = st.nextToken();
                Integer iobj = new Integer(id);
                this.slavedWeaponsIds.add(iobj);
            }
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        while (result.length() < this.getOptions().getStatusSpacing()) {
            result = result + " ";
        }
        if (!this.getSystemStatus().equals("Operational")) {
            result = result + this.getSystemStatus();
        } else if (this.target != null) {
            result = result + "[" + this.target.getName() + "]";
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String s = "";
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return s;
        }
        sb.append(t).append(t).append("<FireControl");
        if (level > 0) {
            sb.append(" id=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        if ((level == 2 || level == 1) && this.getTargetId() != 0) {
            Iterator Weapons;
            sb.append(" targetId=\"");
            sb.append(this.getTargetId());
            sb.append("\"");
            if (this.slavedWeapons != null && (Weapons = this.getSlavedWeapons().iterator()).hasNext()) {
                sb.append(" slavedWeapons=\"");
                boolean first = true;
                while (Weapons.hasNext()) {
                    Weapon w = (Weapon)Weapons.next();
                    if (!first) {
                        sb.append(",");
                    } else {
                        first = false;
                    }
                    sb.append(w.getId());
                }
                sb.append("\"");
            }
        }
        if (level != 0 && level != 5) {
            sb.append(" status=\"");
            sb.append(this.getSystemStatus());
            sb.append("\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        sb.append(sep);
        return sb.toString();
    }

    static {
        Electronics.addSystem("FireControl", new FireControl());
    }
}

