/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.ShipSystem;
import ftjava.util.XMLUtilities;

public class FTLDrive
extends ShipSystem {
    private int phasesActive = 0;
    private boolean active = false;
    private int recharge = 0;

    public FTLDrive() {
        this.setSystemName("FTL Drive");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("active")) {
            if (Value.equals("true")) {
                this.active = true;
            } else if (Value.equals("false")) {
                this.active = false;
            }
            handled = true;
        }
        if (Name.equals("phasesActive")) {
            this.phasesActive = Integer.parseInt(Value);
            handled = true;
        }
        if (Name.equals("recharge")) {
            this.setRecharge(Integer.valueOf(Value));
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void setRecharge(int i) {
        this.recharge = i;
    }

    public int getRecharge() {
        return this.recharge;
    }

    public void decrementRecharge() {
        if (!this.isRecharged()) {
            --this.recharge;
        } else {
            this.setRecharge(0);
        }
    }

    public boolean isRecharged() {
        return this.recharge == 0;
    }

    public void setPhasesActive(int n) {
        if (this.isOperational()) {
            this.phasesActive = n >= 0 ? n : -n;
        }
    }

    public void activate() {
        if (!this.active && this.isOperational() && this.isRecharged()) {
            ++this.phasesActive;
            this.active = true;
        }
    }

    public void deactivate() {
        if (this.active && this.isOperational()) {
            --this.phasesActive;
            this.active = false;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isJumping() {
        return this.phasesActive >= 3;
    }

    public void setSystemStatus(String s) {
        super.setSystemStatus(s);
        if (!this.isOperational()) {
            this.phasesActive = 0;
            this.active = false;
        }
    }

    public int computeMass(int shipMass) {
        int mass = (int)Math.round(0.1 * (double)shipMass);
        if (mass <= 0) {
            mass = 1;
        }
        return mass;
    }

    public int computePointCost(int shipMass) {
        return 2 * this.computeMass(shipMass);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("   " + this.getSystemName());
        if (!this.getSystemStatus().equals("Operational")) {
            while (sb.length() < this.getOptions().getStatusSpacing()) {
                sb.append(" ");
            }
            sb.append(this.getSystemStatus());
        }
        return sb.toString();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String t = XMLUtilities.getIndent();
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (level >= 7) {
            return "";
        }
        sb.append(t + "<FTLDrive");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (level != 0 && level != 5 && level != 6) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if (this.isOperational() && level != 0 && level <= 6) {
            sb.append(" active=\"" + this.active + "\"");
        }
        if (this.active && this.isOperational() && level != 0 && level <= 6) {
            sb.append(" phasesActive=\"" + this.phasesActive + "\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + newLine);
        return sb.toString();
    }
}

