/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.ShipSystem;
import ftjava.util.Dice;

public class CoreLifeSupport
extends ShipSystem {
    private int turnsRemaining;

    public CoreLifeSupport() {
        this.setTurnsRemaining(0);
        this.setSystemName("Life Support");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
    }

    public void takeThresholdCheck(int level) {
        if (this.getSystemStatus().equals("Destroyed")) {
            return;
        }
        if (Dice.rollD6() < level + 1) {
            return;
        }
        if (this.getSystemStatus().equals("Damaged")) {
            this.setDestroyed();
            this.setTurnsRemaining(0);
        } else {
            this.setDamaged();
            this.setTurnsRemaining(Dice.rollD6());
        }
    }

    public void setTurnsRemaining(int turns) {
        this.turnsRemaining = turns;
    }

    public int getTurnsRemaining() {
        return this.turnsRemaining;
    }

    public void decrementTurnsRemaining() {
        if (this.getSystemStatus().equals("Destroyed")) {
            return;
        }
        --this.turnsRemaining;
        if (this.turnsRemaining <= 0) {
            this.setDestroyed();
            this.setTurnsRemaining(0);
        }
    }

    public int computeMass() {
        return 0;
    }

    public int computePointCost() {
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("   ");
        sb.append(this.getSystemName());
        if (!this.getSystemStatus().equals("Operational")) {
            while (sb.length() < this.getOptions().getStatusSpacing()) {
                sb.append(" ");
            }
            sb.append(this.getSystemStatus());
            sb.append(" (");
            sb.append(this.getTurnsRemaining());
            sb.append(")");
        }
        return sb.toString();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String result = "";
        StringBuffer sb = new StringBuffer();
        if (level == 0) {
            return result;
        }
        if (level >= 5) {
            return result;
        }
        sb.append("<CoreLifeSupport id=\"");
        sb.append(this.getId());
        sb.append("\"");
        sb.append(" status=\"");
        sb.append(this.getSystemStatus());
        sb.append("\"");
        if (!this.getSystemStatus().equals("Operational")) {
            sb.append(" turnsRemaining=\"");
            sb.append(this.getTurnsRemaining());
            sb.append("\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        return sb.toString();
    }
}

