/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;

public class AntiMatterTorpedoLauncher
extends Weapon {
    public AntiMatterTorpedoLauncher() {
        this.setArcs(Weapon.FRONT_ARCS);
        this.setSystemName("AntiMatter Torpedo Launcher");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setFireTypeLaunched();
    }

    public void setValue(String Name, String Value) {
        super.setValue(Name, Value);
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
    }

    public boolean canLaunch(SpaceObject firer, AntiMatterTorpedo amt) {
        if (!this.getSystemStatus().equals("Operational")) {
            this.setNotes("Weapon is not operational.");
            return false;
        }
        if (this.hasFired()) {
            this.setNotes("Weapon has fired already!");
            return false;
        }
        double range = firer.rangeTo(amt);
        if (range > this.getOptions().getAntiMatterTorpedoRange()) {
            this.setNotes("Launch point is out of range.");
            return false;
        }
        if (!this.fireAtTargetArc(firer.arcTo(amt))) {
            this.setNotes("Launch point is out of arc.");
            return false;
        }
        return true;
    }

    public void fireAMT(SpaceObject firer) {
        this.setFired();
        this.setExpended();
    }

    public int computeMass() {
        return 2;
    }

    public int computePointCost() {
        return 8;
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String sep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<AntiMatterTorpedoLauncher");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("AntiMatterTorpedoLauncher", new AntiMatterTorpedoLauncher());
    }
}

