/*
 * Decompiled with CFR 0.152.
 */
package ftjava.server;

import ftjava.server.ProcessGame;
import ftjava.std.GameEngine;
import ftjava.std.Player;
import ftjava.std.importer.ImportGameEngine;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ServerUtilities {
    public static String parseGameName(String input) {
        String result = "No active game found";
        StringTokenizer st = new StringTokenizer(input);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.indexOf("Game") != 0) continue;
            result = token;
            break;
        }
        return result;
    }

    public static GameEngine getLatestGame(String postOffice, String gameId) {
        GameEngine game = null;
        File pathName = new File(postOffice, gameId);
        String[] fileNames = pathName.list();
        int turnNumber = ProcessGame.getGameTurn(fileNames);
        String gameFile = ProcessGame.getLatestGameFile(gameId, turnNumber, fileNames);
        ImportGameEngine ige = new ImportGameEngine();
        try {
            game = ige.readGameEngine(new File(pathName, gameFile));
        }
        catch (Exception e) {
            System.out.println("Failed to read: " + gameFile);
            return game;
        }
        return game;
    }

    public static int getPlayerNumber(String address, String postOffice, String gameId) {
        int result = -1;
        GameEngine game = ServerUtilities.getLatestGame(postOffice, gameId);
        if (game == null) {
            return result;
        }
        ArrayList players = game.getPlayers();
        address = address.toLowerCase();
        for (int i = 0; i < players.size(); ++i) {
            Player p = (Player)players.get(i);
            String email = p.getEmail().toLowerCase();
            if (address.indexOf(email) == -1) continue;
            result = p.getId();
        }
        return result;
    }
}

