/*
 * Decompiled with CFR 0.152.
 */
package ftjava.server;

import ftjava.mailman.MailToServer;
import ftjava.server.BackUpAllGames;
import ftjava.server.BackUpGame;
import ftjava.server.ProcessFinishGame;
import ftjava.server.ProcessGame;
import ftjava.server.Server;
import ftjava.server.ServerQuery;
import ftjava.server.ServerUtilities;
import ftjava.std.GameMaster;
import ftjava.std.Player;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import javax.mail.MessagingException;

public class ProcessQuery {
    static final String GAME = "Game";
    static final String HELP = "HELP";
    static final String STATUS = "STATUS";
    static final String RESEND = "RESEND";
    static final String ACTIVE = "ALLGAMES";
    static final String ALLSTATUS = "ALLSTATUS";
    static final String FORCE = "FORCE";
    static final String RESENDALL = "RESENDALL";
    static final String COMPLETE = "COMPLETE";
    static final String INACTIVATE = "INACTIVATE";
    static final String REACTIVATE = "REACTIVATE";
    static final String ALLPLAYERS = "ALLPLAYERS";
    static final String MAILPLAYERS = "MAILPLAYERS";
    static final String BACKUP = "BACKUP";
    static final String BACKUPALL = "BACKUPALL";
    static final String COMPLETED_GAMES = "CompletedGames";
    static final String INACTIVE_GAMES = "InactiveGames";

    public static void execute(String replyTo, String subject, Object contents) {
        GameMaster gm = new GameMaster();
        boolean isGameMaster = false;
        String gameId = "";
        String postOffice = Server.props.getProperty("PostOfficeDirectory");
        String sep = System.getProperty("line.separator");
        String password = Server.props.getProperty("server.password");
        String gmAddress = Server.props.getProperty("mail.replyto");
        isGameMaster = gm.isGameMaster(replyTo);
        if (subject == null) {
            return;
        }
        if (subject.indexOf(".xml") != -1) {
            return;
        }
        if (isGameMaster) {
            System.out.println("### Command from " + replyTo + " " + subject);
        } else {
            System.out.println("::: Command from " + replyTo + " " + subject);
        }
        String subjectUpper = subject.toUpperCase();
        if (subjectUpper.indexOf(HELP) != -1) {
            System.out.println("::: Help");
            ServerQuery.sendHelp(replyTo);
            return;
        }
        if (subjectUpper.indexOf(STATUS) != -1 && subjectUpper.indexOf(ALLSTATUS) == -1) {
            gameId = ServerUtilities.parseGameName(subject);
            if (gameId.indexOf(GAME) == -1) {
                ServerQuery.sendNoGameFound(replyTo, subject);
                return;
            }
            File gameDir = new File(postOffice, gameId);
            if (!gameDir.exists() || !gameDir.isDirectory()) {
                ServerQuery.sendNotAnActiveGame(replyTo, gameId);
                return;
            }
            System.out.println("::: Status for " + gameId);
            String gameStatus = ProcessGame.waitingOn(gameDir);
            ServerQuery.sendStatus(replyTo, gameId, gameStatus);
            return;
        }
        if (subjectUpper.indexOf(RESEND) != -1 && subjectUpper.indexOf(RESENDALL) == -1) {
            gameId = ServerUtilities.parseGameName(subject);
            if (gameId.indexOf(GAME) == -1) {
                ServerQuery.sendNoGameFound(replyTo, subject);
                return;
            }
            File gameDir = new File(postOffice, gameId);
            if (!gameDir.exists() || !gameDir.isDirectory()) {
                ServerQuery.sendNotAnActiveGame(replyTo, gameId);
                return;
            }
            int playerNumber = ServerUtilities.getPlayerNumber(replyTo, postOffice, gameId);
            if (playerNumber != -1) {
                System.out.println("::: Resend for " + gameId);
                ServerQuery.resendGame(playerNumber, postOffice, gameId);
            } else {
                ServerQuery.sendNotPlayer(replyTo, gameId);
            }
            return;
        }
        if (isGameMaster) {
            if (subjectUpper.indexOf(RESENDALL) != -1) {
                gameId = ServerUtilities.parseGameName(subject);
                if (gameId.indexOf(GAME) == -1) {
                    ServerQuery.sendNoGameFound(replyTo, subject);
                    return;
                }
                File gameDir = new File(postOffice, gameId);
                if (!gameDir.exists() || !gameDir.isDirectory()) {
                    ServerQuery.sendNotAnActiveGame(replyTo, gameId);
                    return;
                }
                System.out.println("::: Resend All for " + gameId);
                ServerQuery.resendAllGame(postOffice, gameId);
                return;
            }
            if (subjectUpper.indexOf(FORCE) != -1) {
                gameId = ServerUtilities.parseGameName(subject);
                if (gameId.indexOf(GAME) == -1) {
                    ServerQuery.sendNoGameFound(replyTo, subject);
                    return;
                }
                File gameDir = new File(postOffice, gameId);
                if (!gameDir.exists() || !gameDir.isDirectory()) {
                    ServerQuery.sendNotAnActiveGame(replyTo, gameId);
                    return;
                }
                System.out.println("::: Force processing for " + gameId);
                if (subject.indexOf(password) == -1) {
                    System.out.println("::: Missing password ");
                    return;
                }
                System.out.println(sep + sep + "Processing: " + gameId);
                File directory = new File(postOffice, gameId);
                ProcessGame.process(directory, true);
                return;
            }
            if (subjectUpper.indexOf(ACTIVE) != -1 && subjectUpper.indexOf(ALLSTATUS) == -1) {
                System.out.println("::: List all Active Games");
                try {
                    ServerQuery.sendActiveGames(replyTo, postOffice);
                }
                catch (Exception e) {
                    System.out.println("Missing post office! ");
                }
                return;
            }
            if (subjectUpper.indexOf(ALLSTATUS) != -1) {
                String msg = "";
                StringBuffer makeBar = new StringBuffer();
                while (makeBar.length() < 115) {
                    makeBar.append("-");
                }
                String bar = makeBar.toString();
                System.out.println("::: Status - All Active Games");
                File postOfficeDir = new File(postOffice);
                if (!postOfficeDir.exists()) {
                    System.out.println("Missing post office!");
                    return;
                }
                Object[] gameList = postOfficeDir.list();
                Arrays.sort(gameList);
                for (int i = 0; i < gameList.length; ++i) {
                    if (((String)gameList[i]).indexOf(GAME) != 0) continue;
                    File gameDir = new File(postOffice, (String)gameList[i]);
                    msg = msg + ProcessGame.waitingOn(gameDir, true) + sep + bar + sep;
                }
                ServerQuery.sendAllStatus(replyTo, msg);
                return;
            }
            if (subjectUpper.indexOf(BACKUPALL) != -1) {
                BackUpAllGames.execute(replyTo, subject);
                return;
            }
            if (subjectUpper.indexOf(BACKUP) != -1) {
                BackUpGame.execute(replyTo, subject);
                return;
            }
            if (subjectUpper.indexOf(COMPLETE) != -1) {
                gameId = ServerUtilities.parseGameName(subject);
                if (gameId.indexOf(GAME) == -1) {
                    ServerQuery.sendNoGameFound(replyTo, subject);
                    return;
                }
                File gameDir = new File(postOffice, gameId);
                if (!gameDir.exists() || !gameDir.isDirectory()) {
                    ServerQuery.sendNotAnActiveGame(replyTo, gameId);
                    return;
                }
                if (subject.indexOf(password) == -1) {
                    System.out.println("::: Missing password ");
                    return;
                }
                System.out.println("::: Complete " + gameId);
                String[] gameList = new String[]{gameId};
                ProcessFinishGame.execute(gameList, true);
                return;
            }
            if (subjectUpper.indexOf(INACTIVATE) != -1) {
                gameId = ServerUtilities.parseGameName(subject);
                if (gameId.indexOf(GAME) == -1) {
                    ServerQuery.sendNoGameFound(replyTo, subject);
                    return;
                }
                File gameDir = new File(postOffice, gameId);
                if (!gameDir.exists() || !gameDir.isDirectory()) {
                    ServerQuery.sendNotAnActiveGame(replyTo, gameId);
                    return;
                }
                if (subject.indexOf(password) == -1) {
                    System.out.println("::: Missing password ");
                    return;
                }
                System.out.println("::: Inactivate " + gameId);
                File inactiveDir = new File(postOffice, INACTIVE_GAMES);
                File newDir = new File(inactiveDir, gameId);
                gameDir.renameTo(newDir);
                try {
                    String subj = "FTJava: Inactivated " + gameId;
                    String msg = gameId + " has been moved to the InactiveGames directory";
                    MailToServer.sendSimpleMail(replyTo, subj, msg, "Server reply");
                }
                catch (MessagingException me) {
                    me.printStackTrace();
                }
                return;
            }
            if (subjectUpper.indexOf(REACTIVATE) != -1) {
                gameId = ServerUtilities.parseGameName(subject);
                if (gameId.indexOf(GAME) == -1) {
                    ServerQuery.sendNoGameFound(replyTo, subject);
                    return;
                }
                File gameDir = new File(postOffice, gameId);
                File inactiveDir = new File(postOffice, INACTIVE_GAMES);
                File completeDir = new File(postOffice, COMPLETED_GAMES);
                File look1Dir = new File(inactiveDir, gameId);
                File look2Dir = new File(completeDir, gameId);
                File theGameDir = look1Dir;
                if (!look1Dir.exists()) {
                    theGameDir = look2Dir;
                }
                if (!theGameDir.exists() || !theGameDir.isDirectory()) {
                    ServerQuery.sendUnableToFindGame(replyTo, gameId);
                    return;
                }
                if (subject.indexOf(password) == -1) {
                    System.out.println("::: Missing password ");
                    return;
                }
                System.out.println("::: Reactivate " + gameId);
                theGameDir.renameTo(gameDir);
                try {
                    String subj = "FTJava: Reactivated " + gameId;
                    String msg = gameId + " has been reactivated";
                    MailToServer.sendSimpleMail(replyTo, subj, msg, "Server reply");
                }
                catch (MessagingException me) {
                    me.printStackTrace();
                }
                return;
            }
            if (subjectUpper.indexOf(ALLPLAYERS) != -1) {
                StringBuffer sb = new StringBuffer();
                TreeSet<String> aSet = new TreeSet<String>();
                System.out.println("::: Status - All Active Players");
                File postOfficeDir = new File(postOffice);
                if (!postOfficeDir.exists()) {
                    System.out.println("Missing post office!");
                    return;
                }
                Object[] gameList = postOfficeDir.list();
                Arrays.sort(gameList);
                for (int i = 0; i < gameList.length; ++i) {
                    if (((String)gameList[i]).indexOf(GAME) != 0) continue;
                    File gameDir = new File(postOffice, (String)gameList[i]);
                    ArrayList a = ProcessGame.getPlayers(gameDir);
                    for (int j = 0; j < a.size(); ++j) {
                        Player p = (Player)a.get(j);
                        String pName = p.getName();
                        aSet.add(pName);
                    }
                }
                sb.append(sep);
                sb.append("All Active Players");
                sb.append(sep);
                sb.append(sep);
                Iterator it = aSet.iterator();
                while (it.hasNext()) {
                    sb.append("   " + (String)it.next() + sep);
                }
                try {
                    MailToServer.sendSimpleMail(replyTo, "FTJava Reply - Status - All Players", sb.toString(), "Server reply");
                }
                catch (MessagingException me) {
                    me.printStackTrace();
                }
                return;
            }
            if (subjectUpper.indexOf(MAILPLAYERS) != -1) {
                TreeSet<String> aSet = new TreeSet<String>();
                System.out.println("::: Mail - All Active Players");
                File postOfficeDir = new File(postOffice);
                if (!postOfficeDir.exists()) {
                    System.out.println("Missing post office!");
                    return;
                }
                Object[] gameList = postOfficeDir.list();
                Arrays.sort(gameList);
                for (int i = 0; i < gameList.length; ++i) {
                    if (((String)gameList[i]).indexOf(GAME) != 0) continue;
                    File gameDir = new File(postOffice, (String)gameList[i]);
                    ArrayList a = ProcessGame.getPlayers(gameDir);
                    for (int j = 0; j < a.size(); ++j) {
                        Player p = (Player)a.get(j);
                        String pName = p.getEmail();
                        if (pName == null || pName.length() <= 0) continue;
                        aSet.add(pName);
                    }
                }
                Iterator it = aSet.iterator();
                String[] toPlayers = new String[aSet.size()];
                int i = 0;
                while (it.hasNext()) {
                    toPlayers[i++] = (String)it.next();
                }
                String mailText = contents.toString() + sep;
                mailText = mailText + sep;
                mailText = mailText + "FTJava Game Master";
                mailText = mailText + sep;
                try {
                    MailToServer.sendMultipleMail(toPlayers, gmAddress, "FTJava - To All Players", mailText, "Server reply");
                }
                catch (MessagingException me) {
                    me.printStackTrace();
                }
                return;
            }
        }
    }
}

