/*
 * Decompiled with CFR 0.152.
 */
package ftjava.server;

import ftjava.mailman.MailToServer;
import ftjava.server.ProcessGame;
import ftjava.server.Server;
import ftjava.std.GameEngine;
import ftjava.std.GameMaster;
import ftjava.std.Player;
import ftjava.std.importer.ImportGameEngine;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.mail.MessagingException;

public class ProcessFinishGame {
    static boolean debug = false;
    static String GAME = "Game";

    public static void execute() {
        String postOffice = Server.props.getProperty("PostOfficeDirectory");
        File postOfficeDir = new File(postOffice);
        if (!postOfficeDir.exists()) {
            System.out.println("Missing post office!");
            return;
        }
        Object[] gameList = postOfficeDir.list();
        Arrays.sort(gameList);
        ProcessFinishGame.execute((String[])gameList, false);
    }

    public static void execute(String[] gameList, boolean forceClose) {
        String postOffice = Server.props.getProperty("PostOfficeDirectory");
        File postOfficeDir = new File(postOffice);
        if (!postOfficeDir.exists()) {
            System.out.println("Missing post office!");
            return;
        }
        for (int i = 0; i < gameList.length; ++i) {
            boolean closeGame = false;
            if (gameList[i].indexOf(GAME) != 0) continue;
            File gameDir = new File(postOffice, gameList[i]);
            String gameName = null;
            try {
                gameName = ProcessGame.getGameName(gameDir.getCanonicalPath());
            }
            catch (IOException ioe) {
                System.err.println("IO Exception during deadline processing!");
            }
            String[] fileNames = gameDir.list();
            int turnNumber = ProcessGame.getGameTurn(fileNames);
            String gameFile = ProcessGame.getLatestGameFile(gameName, turnNumber, fileNames);
            File theFile = null;
            try {
                theFile = new File(gameDir.getCanonicalPath(), gameFile);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            ImportGameEngine ige = new ImportGameEngine();
            GameEngine game = null;
            try {
                game = ige.readGameEngine(theFile);
            }
            catch (Exception e) {
                System.err.println("Server Error: Failed to read: " + gameFile);
                e.printStackTrace();
                continue;
            }
            if (forceClose) {
                closeGame = true;
            }
            int livePlayers = 0;
            int deadPlayers = 0;
            int botPlayers = 0;
            ArrayList playerList = game.getPlayers();
            ArrayList<String> emailList = new ArrayList<String>();
            ArrayList<Player> liveList = new ArrayList<Player>();
            for (int j = 0; j < playerList.size(); ++j) {
                Player p = (Player)playerList.get(j);
                if (p.isPlayerDead()) {
                    ++deadPlayers;
                }
                if (p.isPlayerRobot()) {
                    ++botPlayers;
                } else {
                    emailList.add(p.getEmail());
                }
                if (p.isPlayerDead()) continue;
                liveList.add(p);
                ++livePlayers;
            }
            if (livePlayers == 0 || livePlayers == 1) {
                closeGame = true;
            } else {
                boolean twoTeams = false;
                String firstTeam = ((Player)liveList.get(0)).getTeam();
                for (int j = 1; j < liveList.size(); ++j) {
                    String theTeam = ((Player)liveList.get(j)).getTeam();
                    if (firstTeam.equals(theTeam)) continue;
                    twoTeams = true;
                }
                if (!twoTeams) {
                    closeGame = true;
                }
            }
            if (!closeGame) continue;
            String gameId = "Game" + game.getId();
            File completeDir = new File(postOffice, "CompletedGames");
            File newDir = new File(completeDir, gameId);
            gameDir.renameTo(newDir);
            GameMaster gm = new GameMaster();
            emailList.add(gm.getEmail());
            ProcessFinishGame.sendGameCompleteMessage(game, emailList);
        }
    }

    public static void sendGameCompleteMessage(GameEngine game, ArrayList emailList) {
        String report = ProcessFinishGame.createReport(game);
        for (int j = 0; j < emailList.size(); ++j) {
            try {
                String replyTo = (String)emailList.get(j);
                String subject = "FTJava: Game" + game.getId() + " Completed";
                MailToServer.sendSimpleMail(replyTo, subject, report, "Server reply");
                continue;
            }
            catch (MessagingException me) {
                me.printStackTrace();
            }
        }
    }

    public static String createReport(GameEngine game) {
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        sb.append(sep).append(sep);
        sb.append("  Game" + game.getId() + " has been completed.");
        sb.append(sep).append(sep);
        sb.append("  " + game.getName());
        sb.append(sep).append(sep);
        sb.append(game.createSensorReport());
        sb.append(sep);
        sb.append("  Thanks for playing!");
        sb.append(sep).append(sep);
        sb.append("  FTJava GameMaster");
        sb.append(sep).append(sep);
        return sb.toString();
    }
}

