/*
 * Decompiled with CFR 0.152.
 */
package ftjava.server;

import ftjava.server.ProcessGame;
import ftjava.server.Server;
import ftjava.std.GameEngine;
import ftjava.std.importer.ImportGameEngine;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class ProcessDeadline {
    static boolean debug = false;
    static String GAME = "Game";

    public static void execute() {
        String postOffice = Server.props.getProperty("PostOfficeDirectory");
        File postOfficeDir = new File(postOffice);
        if (!postOfficeDir.exists()) {
            System.out.println("Missing post office!");
            return;
        }
        Object[] gameList = postOfficeDir.list();
        Arrays.sort(gameList);
        for (int i = 0; i < gameList.length; ++i) {
            if (((String)gameList[i]).indexOf(GAME) != 0) continue;
            File gameDir = new File(postOffice, (String)gameList[i]);
            String gameName = null;
            try {
                gameName = ProcessGame.getGameName(gameDir.getCanonicalPath());
            }
            catch (IOException ioe) {
                System.err.println("IO Exception during deadline processing!");
            }
            String[] fileNames = gameDir.list();
            int turnNumber = ProcessGame.getGameTurn(fileNames);
            String gameFile = ProcessGame.getLatestGameFile(gameName, turnNumber, fileNames);
            File theFile = null;
            try {
                theFile = new File(gameDir.getCanonicalPath(), gameFile);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            long lastMod = theFile.lastModified();
            long now = new Date().getTime();
            long age = now - lastMod;
            long seconds = age / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            long days = hours / 24L;
            ImportGameEngine ige = new ImportGameEngine();
            GameEngine game = null;
            try {
                game = ige.readGameEngine(theFile);
            }
            catch (Exception e) {
                System.err.println("Server Error: Failed to read: " + gameFile);
                e.printStackTrace();
                continue;
            }
            int deadline = game.getDeadline();
            if (days < (long)deadline) continue;
            ProcessGame.process(gameDir, true);
        }
    }
}

