/*
 * Decompiled with CFR 0.152.
 */
package ftjava.server;

import ftjava.mailman.MailToServer;
import ftjava.server.Server;
import ftjava.server.ServerQuery;
import ftjava.server.ServerUtilities;
import ftjava.std.GameMaster;
import ftjava.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.MessagingException;

public class BackUpGame {
    public static void execute(String replyTo, String mailSubject) {
        String postOffice = Server.props.getProperty("PostOfficeDirectory");
        String password = Server.props.getProperty("server.password");
        String fileSep = System.getProperty("file.separator");
        String sep = System.getProperty("line.separator");
        GameMaster gm = new GameMaster();
        String gameId = ServerUtilities.parseGameName(mailSubject);
        File gameDir = new File(postOffice, gameId);
        if (!gameDir.exists() || !gameDir.isDirectory()) {
            ServerQuery.sendNotAnActiveGame(replyTo, gameId);
            return;
        }
        if (mailSubject.indexOf(password) == -1) {
            System.out.println("::: Missing password ");
            return;
        }
        System.out.println("    Backup game " + gameId);
        String[] allFiles = gameDir.list();
        String[] zipEntries = new String[allFiles.length];
        String absPath = gameDir.getAbsolutePath();
        String zipFileName = absPath + fileSep + gameId + ".zip";
        byte[] buffer = new byte[1024];
        for (int i = 0; i < allFiles.length; ++i) {
            zipEntries[i] = gameId + fileSep + allFiles[i];
            allFiles[i] = absPath + fileSep + allFiles[i];
        }
        try {
            ZipOutputStream fOut = new ZipOutputStream(new FileOutputStream(zipFileName));
            for (int i = 0; i < allFiles.length; ++i) {
                int len;
                FileInputStream fIn = new FileInputStream(allFiles[i]);
                fOut.putNextEntry(new ZipEntry(zipEntries[i]));
                while ((len = fIn.read(buffer)) > 0) {
                    fOut.write(buffer, 0, len);
                }
                fOut.closeEntry();
                fIn.close();
            }
            fOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                StringBuffer sb = new StringBuffer();
                sb.append(e.toString()).append(sep).append(sep);
                sb.append(StringUtils.traceToString(e));
                MailToServer.sendSimpleMail(gm.getEmail(), "FTJava Server Exception", sb.toString(), "Server error");
            }
            catch (MessagingException me) {
                me.printStackTrace();
                System.out.println("We're really hosed");
            }
        }
        try {
            MailToServer.sendZipFile(replyTo, gameId + ".zip", zipFileName, "Zip file backup");
        }
        catch (MessagingException me) {
            me.printStackTrace();
        }
        File zipFile = new File(zipFileName);
        zipFile.delete();
    }
}

