/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.util;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntegerTextField
extends JTextField {
    private static final long serialVersionUID = 1L;

    public IntegerTextField(int cols) {
        super(Integer.toString(0), cols);
    }

    public IntegerTextField(int cols, int initialValue) {
        super(Integer.toString(initialValue), cols);
    }

    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    static class IntegerDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        IntegerDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] charStr = str.toCharArray();
            int firstInt = -1;
            int lastInt = -1;
            for (int i = 0; i < charStr.length; ++i) {
                if (Character.isDigit(charStr[i])) {
                    if (firstInt >= 0) continue;
                    firstInt = i;
                    continue;
                }
                if (firstInt < 0) continue;
                lastInt = i;
            }
            if (firstInt < 0) {
                return;
            }
            if (lastInt < 0) {
                super.insertString(offs, str.substring(firstInt), a);
            } else {
                super.insertString(offs, str.substring(firstInt, lastInt), a);
            }
        }
    }
}

