/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd.variant;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.gui.util.IntegerInputDialog;
import ftjava.std.Weapon;
import ftjava.std.variant.HeavyBeamBattery;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class HeavyBeamBatteryWidget
extends SystemWidget {
    private static final long serialVersionUID = 1L;
    private static final Dimension BEAM_BATTERY_SIZE = new Dimension(34, 34);
    private static final Arc2D FRONT_ARC_AREA = new Arc2D.Double(2.0, 2.0, 32.0, 32.0, 60.0, 60.0, 2);
    private static final Arc2D FRONT_STARBOARD_ARC_AREA = new Arc2D.Double(2.0, 2.0, 32.0, 32.0, 0.0, 60.0, 2);
    private static final Arc2D AFT_STARBOARD_ARC_AREA = new Arc2D.Double(2.0, 2.0, 32.0, 32.0, 300.0, 60.0, 2);
    private static final Arc2D AFT_ARC_AREA = new Arc2D.Double(2.0, 2.0, 32.0, 32.0, 240.0, 60.0, 2);
    private static final Arc2D AFT_PORT_ARC_AREA = new Arc2D.Double(2.0, 2.0, 32.0, 32.0, 180.0, 60.0, 2);
    private static final Arc2D FRONT_PORT_ARC_AREA = new Arc2D.Double(2.0, 2.0, 32.0, 32.0, 120.0, 60.0, 2);
    private static final Arc2D arc = new Arc2D.Double(-15.0, -15.0, 30.0, 30.0, 240.0, 60.0, 2);
    private static final Ellipse2D ellipse = new Ellipse2D.Double(-10.0, -10.0, 20.0, 20.0);
    private static final Ellipse2D ring = new Ellipse2D.Double(-8.0, -8.0, 16.0, 16.0);

    public HeavyBeamBatteryWidget() {
        this(new HeavyBeamBattery(2, Weapon.ALL_ARCS), true);
    }

    public HeavyBeamBatteryWidget(HeavyBeamBattery bb) {
        this(bb, false);
    }

    public HeavyBeamBatteryWidget(HeavyBeamBattery bb, boolean mutable) {
        super(bb, mutable);
        this.initialiseBeamMenuItems();
        this.setMinimumSize(BEAM_BATTERY_SIZE);
        this.setMaximumSize(BEAM_BATTERY_SIZE);
        this.setPreferredSize(BEAM_BATTERY_SIZE);
        this.setSize(BEAM_BATTERY_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        int fireArcs = ((Weapon)this.theSystem).getArcs() >> 21;
        AffineTransform lastTransform = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        g.translate(17, 17);
        for (int i = 0; i < 6; ++i) {
            if ((fireArcs >> i & 1) != 0) {
                g.setColor(Color.white);
            } else {
                g.setColor(SSDDrawingTools.getSystemColor(this.theSystem).brighter());
            }
            g.fill(arc);
            g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
            g.draw(arc);
            g.rotate(-1.0471975511965976);
        }
        g.setColor(Color.white);
        g.fill(ellipse);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(ellipse);
        g.draw(ring);
        String strength = Integer.toString(((HeavyBeamBattery)this.theSystem).getRating());
        FontMetrics fm = g.getFontMetrics(g.getFont());
        g.drawString(strength, -fm.stringWidth(strength) / 2, fm.getAscent() / 2 - 1);
        g.setTransform(lastTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void mouseClicked(MouseEvent me) {
        super.mouseClicked(me);
        int x = me.getX();
        int y = me.getY();
        int mods = me.getModifiers();
        HeavyBeamBattery theBB = (HeavyBeamBattery)this.theSystem;
        if ((mods & 1) != 0 && !me.isConsumed()) {
            if (FRONT_ARC_AREA.contains(x, y)) {
                theBB.setArcs(theBB.getArcs() ^ Weapon.FORE_ARC);
            } else if (FRONT_STARBOARD_ARC_AREA.contains(x, y)) {
                theBB.setArcs(theBB.getArcs() ^ Weapon.FORE_STARBOARD_ARC);
            } else if (AFT_STARBOARD_ARC_AREA.contains(x, y)) {
                theBB.setArcs(theBB.getArcs() ^ Weapon.AFT_STARBOARD_ARC);
            } else if (AFT_ARC_AREA.contains(x, y)) {
                theBB.setArcs(theBB.getArcs() ^ Weapon.AFT_ARC);
            } else if (AFT_PORT_ARC_AREA.contains(x, y)) {
                theBB.setArcs(theBB.getArcs() ^ Weapon.AFT_PORT_ARC);
            } else if (FRONT_PORT_ARC_AREA.contains(x, y)) {
                theBB.setArcs(theBB.getArcs() ^ Weapon.FORE_PORT_ARC);
            }
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        HeavyBeamBattery theBB = (HeavyBeamBattery)this.theSystem;
        String ac = ae.getActionCommand();
        if (ac.equals("more")) {
            int newRating = IntegerInputDialog.showIntegerInputDialog(JOptionPane.getFrameForComponent(this), theBB.getRating());
            if (newRating >= 0) {
                theBB.setValue("rating", Integer.toString(newRating));
            }
        } else {
            try {
                theBB.setValue("rating", ac);
            }
            catch (NumberFormatException nfe) {
                super.actionPerformed(ae);
                this.repaint();
                return;
            }
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    private void initialiseBeamMenuItems() {
        if (this.mutable) {
            JRadioButtonMenuItem mi;
            this.popup.addSeparator();
            ButtonGroup bg = new ButtonGroup();
            for (int i = 1; i <= 4; ++i) {
                mi = new JRadioButtonMenuItem(Integer.toString(i), i == 1);
                mi.setActionCommand(Integer.toString(i));
                mi.addActionListener(this);
                bg.add(mi);
                this.popup.add(mi);
            }
            mi = new JRadioButtonMenuItem("More Sizes...", false);
            mi.setActionCommand("more");
            mi.addActionListener(this);
            bg.add(mi);
            this.popup.add(mi);
        }
    }

    private String getToolTip() {
        HeavyBeamBattery theBB = (HeavyBeamBattery)this.theSystem;
        return "Class " + theBB.getRating() + " Heavy Beam Battery" + theBB.getArcsString();
    }
}

