/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.util.PointInputDialog;
import ftjava.std.ShipSystem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class SystemWidget
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected ShipSystem theSystem;
    protected boolean mutable;
    protected JPopupMenu popup;
    protected static final Point GLYPH_OFFSET = new Point(2, 2);
    private Point dragStartPoint;
    private Point widgetStartPoint;
    private boolean isDrag;

    protected SystemWidget(ShipSystem s) {
        this(s, false);
    }

    protected SystemWidget(ShipSystem s, boolean m) {
        this.theSystem = s;
        this.mutable = m;
        this.initialisePopup();
        this.addListeners();
        this.dragStartPoint = null;
        this.widgetStartPoint = null;
        this.isDrag = false;
    }

    protected SystemWidget() {
        this(null, true);
    }

    protected void setShipSystem(ShipSystem s) {
        this.theSystem = s;
    }

    public ShipSystem getShipSystem() {
        return this.theSystem;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    private void addListeners() {
        if (this.mutable) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    private void initialisePopup() {
        if (this.mutable) {
            this.popup = new JPopupMenu();
            JMenuItem mi = new JMenuItem("Set Position...");
            mi.setActionCommand("position");
            mi.addActionListener(this);
            this.popup.add(mi);
        }
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
        if (this.isDrag) {
            this.setLocation(this.widgetStartPoint);
            this.isDrag = false;
        }
    }

    public void mousePressed(MouseEvent me) {
        int mods = me.getModifiers();
        if (!me.isPopupTrigger()) {
            return;
        }
        this.handlePopupTrigger(me);
        me.consume();
        this.repaint();
    }

    public void mouseReleased(MouseEvent me) {
        if (this.isDrag) {
            this.isDrag = false;
        } else {
            this.mousePressed(me);
        }
    }

    public void mouseMoved(MouseEvent mme) {
    }

    public void mouseDragged(MouseEvent mme) {
        mme.translatePoint(this.getX(), this.getY());
        if (!this.isDrag) {
            this.widgetStartPoint = this.getLocation();
            this.dragStartPoint = mme.getPoint();
            this.isDrag = true;
        }
        Point p = mme.getPoint();
        p.x -= this.dragStartPoint.x;
        p.x += this.widgetStartPoint.x;
        p.y -= this.dragStartPoint.y;
        p.y += this.widgetStartPoint.y;
        this.setLocation(p);
        this.theSystem.setXSSD(p.x + this.getWidth() / 2);
        this.theSystem.setYSSD(p.y + this.getHeight() / 2);
    }

    public void actionPerformed(ActionEvent ae) {
        String ac = ae.getActionCommand();
        if (ac.equals("position")) {
            Point p = PointInputDialog.showPointInputDialog(JOptionPane.getFrameForComponent(this), this.getX(), this.getY());
            this.setLocation(p);
            this.theSystem.setXSSD(p.x + this.getWidth() / 2);
            this.theSystem.setYSSD(p.y + this.getWidth() / 2);
        }
        this.repaint();
    }

    private void handlePopupTrigger(MouseEvent me) {
        if (this.popup == null) {
            return;
        }
        this.popup.show(me.getComponent(), me.getX(), me.getY());
    }
}

