/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.SalvoMissileRack;
import ftjava.std.Weapon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;

public class SalvoMissileRackWidget
extends SystemWidget {
    private static final Dimension SMR_SIZE = new Dimension(31, 31);
    private static final Arc2D FRONT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 60.0, 60.0, 2);
    private static final Arc2D FRONT_STARBOARD_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 0.0, 60.0, 2);
    private static final Arc2D AFT_STARBOARD_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 300.0, 60.0, 2);
    private static final Arc2D AFT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 240.0, 60.0, 2);
    private static final Arc2D AFT_PORT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 180.0, 60.0, 2);
    private static final Arc2D FRONT_PORT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 120.0, 60.0, 2);
    private static final Ellipse2D CENTER_AREA = new Ellipse2D.Double(5.0, 5.0, 20.0, 20.0);
    private static final Arc2D arc = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 240.0, 60.0, 2);
    private static final Ellipse2D ellipse = new Ellipse2D.Double(5.0, 5.0, 20.0, 20.0);
    private static final GeneralPath missileIcon = new GeneralPath();

    public SalvoMissileRackWidget(SalvoMissileRack smr) {
        this(smr, false);
    }

    public SalvoMissileRackWidget() {
        this(new SalvoMissileRack(), true);
    }

    public SalvoMissileRackWidget(SalvoMissileRack smr, boolean mutable) {
        super(smr, mutable);
        this.initialiseSMRMenuItems();
        this.setMinimumSize(SMR_SIZE);
        this.setMaximumSize(SMR_SIZE);
        this.setPreferredSize(SMR_SIZE);
        this.setSize(SMR_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        int fireArcs = ((Weapon)this.theSystem).getArcs() >> 21;
        AffineTransform lastTransform = g.getTransform();
        SalvoMissileRack theSMR = (SalvoMissileRack)this.theSystem;
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        for (int i = 0; i < 6; ++i) {
            if ((fireArcs >> i & 1) != 0) {
                g.setColor(Color.white);
                g.fill(arc);
                g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
                g.draw(arc);
            }
            g.rotate(-1.0471975511965976, 15.0, 15.0);
        }
        g.setColor(Color.white);
        g.fill(ellipse);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(ellipse);
        g.draw(missileIcon);
        if (theSMR.getType().equals("Extended Range Salvo")) {
            g.fill(missileIcon);
        }
        g.setTransform(lastTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void mouseClicked(MouseEvent me) {
        super.mouseClicked(me);
        int x = me.getX();
        int y = me.getY();
        int mods = me.getModifiers();
        SalvoMissileRack theSMR = (SalvoMissileRack)this.theSystem;
        if ((mods & 1) != 0 && !me.isConsumed()) {
            if (FRONT_ARC_AREA.contains(x, y)) {
                theSMR.setArcs(theSMR.getArcs() ^ Weapon.FORE_ARC);
            } else if (FRONT_STARBOARD_ARC_AREA.contains(x, y)) {
                theSMR.setArcs(theSMR.getArcs() ^ Weapon.FORE_STARBOARD_ARC);
            } else if (AFT_STARBOARD_ARC_AREA.contains(x, y)) {
                theSMR.setArcs(theSMR.getArcs() ^ Weapon.AFT_STARBOARD_ARC);
            } else if (AFT_ARC_AREA.contains(x, y)) {
                theSMR.setArcs(theSMR.getArcs() ^ Weapon.AFT_ARC);
            } else if (AFT_PORT_ARC_AREA.contains(x, y)) {
                theSMR.setArcs(theSMR.getArcs() ^ Weapon.AFT_PORT_ARC);
            } else if (FRONT_PORT_ARC_AREA.contains(x, y)) {
                theSMR.setArcs(theSMR.getArcs() ^ Weapon.FORE_PORT_ARC);
            }
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        SalvoMissileRack theSMR = (SalvoMissileRack)this.theSystem;
        String ac = ae.getActionCommand();
        if (ac.equals("Standard") || ac.equals("Extended Range")) {
            theSMR.setType(ac);
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    private void initialiseSMRMenuItems() {
        if (this.mutable) {
            SalvoMissileRack theSMR = (SalvoMissileRack)this.theSystem;
            this.popup.addSeparator();
            ButtonGroup bg = new ButtonGroup();
            JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem("Standard", theSMR.getType().equals("Standard"));
            rbmi.setActionCommand("Standard");
            rbmi.addActionListener(this);
            bg.add(rbmi);
            this.popup.add(rbmi);
            rbmi = new JRadioButtonMenuItem("Extended Range", theSMR.getType().equals("Extended Range"));
            rbmi.setActionCommand("Extended Range");
            rbmi.addActionListener(this);
            bg.add(rbmi);
            this.popup.add(rbmi);
        }
    }

    private String getToolTip() {
        SalvoMissileRack smr = (SalvoMissileRack)this.theSystem;
        return smr.getType() + " Salvo Missile Rack " + smr.getArcsString();
    }

    static {
        missileIcon.reset();
        missileIcon.moveTo(15.0f, 7.0f);
        missileIcon.lineTo(10.0f, 22.0f);
        missileIcon.lineTo(15.0f, 19.0f);
        missileIcon.lineTo(20.0f, 22.0f);
        missileIcon.closePath();
    }
}

