/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.gui.util.IntegerInputDialog;
import ftjava.std.SalvoMissileMagazine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SalvoMissileMagazineWidget
extends SystemWidget {
    private Rectangle2D boundingRect;
    private Dimension magazineSize;
    private static final Dimension MISSILE_ICON_SIZE = new Dimension(10, 15);
    private static final GeneralPath missileIcon = new GeneralPath();
    private static final int INTERMISSILE_GAP = 5;
    private static final int BOUND_CORNER_RADIUS = 5;

    public SalvoMissileMagazineWidget(SalvoMissileMagazine smm) {
        this(smm, false);
    }

    public SalvoMissileMagazineWidget() {
        this(new SalvoMissileMagazine(), true);
    }

    public SalvoMissileMagazineWidget(SalvoMissileMagazine smm, boolean mutable) {
        super(smm, mutable);
        if (mutable) {
            this.initialiseSMMMenuItems();
        }
        this.magazineSize = new Dimension();
        this.updateMagazineSize();
        this.setWidgetSizes();
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        int currentTypeCounter;
        Graphics2D g = (Graphics2D)g_o;
        SalvoMissileMagazine smm = (SalvoMissileMagazine)this.theSystem;
        AffineTransform originalTransform = g.getTransform();
        g.translate(SalvoMissileMagazineWidget.GLYPH_OFFSET.x, SalvoMissileMagazineWidget.GLYPH_OFFSET.y);
        AffineTransform lastTransform = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        int num_cols = this.getNumColumns();
        int num_rows = this.getNumRows();
        int missile_count = smm.getSalvoCount();
        RoundRectangle2D.Float r = new RoundRectangle2D.Float(0.0f, 0.0f, num_cols * SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.width + 5 * (num_cols + 1), num_rows * SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.height + 5 * (num_rows + 1), 5.0f, 5.0f);
        g.setColor(Color.white);
        g.fill(r);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(r);
        int rowCounter = 0;
        int colCounter = 0;
        for (currentTypeCounter = smm.getSalvoCount("Standard Salvo", "Available"); currentTypeCounter > 0; --currentTypeCounter) {
            if (colCounter >= num_cols) {
                colCounter = 0;
                ++rowCounter;
            }
            g.translate(5 + (SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.width + 5) * colCounter, 5 + (SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.height + 5) * rowCounter);
            ++colCounter;
            g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
            g.draw(missileIcon);
            g.setTransform(lastTransform);
        }
        for (currentTypeCounter = smm.getSalvoCount("Standard Salvo", "Expended"); currentTypeCounter > 0; --currentTypeCounter) {
            if (colCounter >= num_cols) {
                colCounter = 0;
                ++rowCounter;
            }
            g.translate(5 + (SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.width + 5) * colCounter, 5 + (SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.height + 5) * rowCounter);
            ++colCounter;
            g.setColor(SSDDrawingTools.getExpendedColor());
            g.draw(missileIcon);
            g.setTransform(lastTransform);
        }
        for (currentTypeCounter = smm.getSalvoCount("Extended Range Salvo", "Available"); currentTypeCounter > 0; --currentTypeCounter) {
            if (colCounter >= num_cols) {
                colCounter = 0;
                ++rowCounter;
            }
            g.translate(5 + (SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.width + 5) * colCounter, 5 + (SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.height + 5) * rowCounter);
            ++colCounter;
            g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
            g.draw(missileIcon);
            g.fill(missileIcon);
            g.setTransform(lastTransform);
        }
        for (currentTypeCounter = smm.getSalvoCount("Extended Range Salvo", "Expended"); currentTypeCounter > 0; --currentTypeCounter) {
            if (colCounter >= num_cols) {
                colCounter = 0;
                ++rowCounter;
            }
            g.translate(5 + (SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.width + 5) * colCounter, 5 + (SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.height + 5) * rowCounter);
            ++colCounter;
            g.setColor(SSDDrawingTools.getExpendedColor());
            g.draw(missileIcon);
            g.fill(missileIcon);
            g.setTransform(lastTransform);
        }
        g.setTransform(originalTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        SalvoMissileMagazine smm = (SalvoMissileMagazine)this.theSystem;
        if (command.equals("capacity")) {
            int cap = IntegerInputDialog.showIntegerInputDialog(JOptionPane.getFrameForComponent(this), "Enter a magazine capacity (in mass units)", this.getCapacity());
            if (cap >= 2) {
                this.setCapacity(cap);
            }
        } else if (command.equals("columns")) {
            int cols = IntegerInputDialog.showIntegerInputDialog(JOptionPane.getFrameForComponent(this), "Enter the maximum number of columns of missile salvos to display", this.getMaximumInRow());
            if (cols > 0) {
                this.setMaximumInRow(cols);
            }
        } else if (command.indexOf("add") == 0) {
            if (command.indexOf("Standard Salvo") > 0) {
                this.addSalvo("Standard Salvo");
            } else if (command.indexOf("Extended Range Salvo") > 0) {
                this.addSalvo("Extended Range Salvo");
            }
        } else if (command.indexOf("remove") == 0) {
            if (command.indexOf("Standard Salvo") > 0) {
                this.removeSalvo("Standard Salvo");
            } else if (command.indexOf("Extended Range Salvo") > 0) {
                this.removeSalvo("Extended Range Salvo");
            }
        } else {
            super.actionPerformed(ae);
        }
        this.repaint();
    }

    private void setWidgetSizes() {
        this.setMinimumSize(this.magazineSize);
        this.setMaximumSize(this.magazineSize);
        this.setPreferredSize(this.magazineSize);
        this.setSize(this.magazineSize);
    }

    private void updateMagazineSize() {
        int columnCount = this.getNumColumns();
        int rowCount = this.getNumRows();
        this.magazineSize.width = columnCount * SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.width + 5 * (columnCount + 1) + 2 * SalvoMissileMagazineWidget.GLYPH_OFFSET.x;
        this.magazineSize.height = rowCount * SalvoMissileMagazineWidget.MISSILE_ICON_SIZE.height + 5 * (rowCount + 1) + 2 * SalvoMissileMagazineWidget.GLYPH_OFFSET.y;
    }

    private void setMaximumInRow(int rm) {
        ((SalvoMissileMagazine)this.theSystem).setMaximumInRow(rm);
        this.updateMagazineSize();
        this.setWidgetSizes();
    }

    private int getMaximumInRow() {
        int r = ((SalvoMissileMagazine)this.theSystem).getMaximumInRow();
        return r;
    }

    private void setCapacity(int cap) {
        ((SalvoMissileMagazine)this.theSystem).setCapacity(cap);
        this.updateMagazineSize();
        this.setWidgetSizes();
    }

    private int getCapacity() {
        int cap = ((SalvoMissileMagazine)this.theSystem).getCapacity();
        return cap;
    }

    private void addSalvo(String type) {
        ((SalvoMissileMagazine)this.theSystem).addSalvo(type, "Available");
        this.updateMagazineSize();
        this.setWidgetSizes();
    }

    private void removeSalvo(String type) {
        ((SalvoMissileMagazine)this.theSystem).removeSalvo(type, "Available");
        this.updateMagazineSize();
        this.setWidgetSizes();
    }

    private void initialiseSMMMenuItems() {
        this.popup.addSeparator();
        JMenuItem mi = new JMenuItem("Set Capacity...");
        mi.setActionCommand("capacity");
        mi.addActionListener(this);
        this.popup.add(mi);
        mi = new JMenuItem("Set Number of Columns...");
        mi.setActionCommand("columns");
        mi.addActionListener(this);
        this.popup.add(mi);
        JMenu m = new JMenu("Add");
        mi = new JMenuItem("Standard Salvo");
        mi.setActionCommand("addStandard Salvo");
        mi.addActionListener(this);
        m.add(mi);
        mi = new JMenuItem("Extended Range Salvo");
        mi.setActionCommand("addExtended Range Salvo");
        mi.addActionListener(this);
        m.add(mi);
        this.popup.add(m);
        m = new JMenu("Remove");
        mi = new JMenuItem("Standard Salvo");
        mi.setActionCommand("removeStandard Salvo");
        mi.addActionListener(this);
        m.add(mi);
        mi = new JMenuItem("Extended Range Salvo");
        mi.setActionCommand("removeExtended Range Salvo");
        mi.addActionListener(this);
        m.add(mi);
        this.popup.add(m);
    }

    private String getToolTip() {
        return "Salvo Missile Magazine";
    }

    private int getNumColumns() {
        SalvoMissileMagazine smm = (SalvoMissileMagazine)this.theSystem;
        int maxInRow = smm.getMaximumInRow();
        int missileCount = smm.getSalvoCount();
        return missileCount <= maxInRow ? missileCount : maxInRow;
    }

    private int getNumRows() {
        int numMissiles;
        SalvoMissileMagazine smm = (SalvoMissileMagazine)this.theSystem;
        int numColumns = this.getNumColumns();
        if (numColumns == (numMissiles = smm.getSalvoCount())) {
            return 1;
        }
        return numMissiles / numColumns + (numMissiles % numColumns != 0 ? 1 : 0);
    }

    static {
        missileIcon.reset();
        missileIcon.moveTo(5.0f, 0.0f);
        missileIcon.lineTo(0.0f, 15.0f);
        missileIcon.lineTo(5.0f, 12.0f);
        missileIcon.lineTo(10.0f, 15.0f);
        missileIcon.closePath();
    }
}

